//important     before render the heightfield (HF_back_mountains.pov) and put the png in the scene folder.
//              This file generates the tree coordinates - and a black image.
//              Render the file with the same aspect ratio as in Tree_Logo.pov (2:1).

#declare maxdist_trace = 0; // first run -> 1 (result can be seen in the editor window)/ second run -> 0

#if (maxdist_trace = 0)
        #declare ftname = "veg_manythings.inc"
        #warning concat (ftname," veg_manythings file creation start\n")
        #fopen filehandle ftname write  
#end

#declare hfB =
height_field { 
        png "HF_back_mountains"
        water_level 0.005 smooth         
        translate <-0.5,-0.5,-0.5> 
        scale <25000,231,2000>
} 

#declare manytrees_area =
union {
        height_field {
                hfB         
                rotate <0,-25,0>
                translate <900,70,-600>
        }
        height_field {
                hfB
                scale 5         
                rotate <0,-25,0>
                translate <500,350,-5200>
        } 
}

//_________________________________________________________________

#if (maxdist_trace = 1)
        #declare max_dist = 0.000001;
#else
        #declare max_dist = 2169; // from a former run with #declare maxdist_trace = 1; -> see first line
#end

// code ideas from http://www.spiritone.com/~english/cyclopedia/background.html
  
#include "transforms.inc"
#declare cam_loc = <37,3.5,0>;
#declare lookat = <37,3.52,-1>;
#declare cam_ang = 64.8;
#declare cam_mirror = -1;                                                // 1 for normal / -1 for mirror image
#declare cam_z = 0.5*image_width/image_height/tan(radians(cam_ang*0.5)); // the amount of camera zoom you want
#declare cam_ang_up = degrees(2*atan2(0.5/cam_z,1));                     // camera angle in cam_up direction
#declare back_dist = 1000;                                               // how far away the background is
#declare cam_a = cam_mirror*image_width/image_height;                    // camera aspect ratio
#declare cam_s = y;                                                      // camera sky vector
#declare cam_d = vnormalize (lookat-cam_loc);                            // camera direction vector
#declare cam_r = vnormalize (vcross(cam_s,cam_d));                       // camera right vector
#declare cam_up = vnormalize (vcross(cam_d,cam_r));                      // camera up vector
#declare cam_dir = cam_d*cam_z;                                          // direction vector scaled
#declare cam_right = cam_r*cam_a;                                        // right vector scaled

#declare fz = vlength(cam_dir);
#declare fx = vlength(cam_right)/2;
#declare fy = vlength(cam_up)/2; 

#macro OrientZ(p1,p2,cs)          // looks like Reorient_trans macro!
        #local nz = vnormalize(p2-p1);
        #local nx = vnormalize(vcross(cs,nz)); 
        #local ny = vcross(nz,nx);
        matrix <nx.x,nx.y,nx.z,ny.x,ny.y,ny.z,nz.x,nz.y,nz.z,p1.x,p1.y,p1.z>          
#end

#declare view_paint =
box { <0,0,0> <1,1,0.1>
      pigment {color rgb 1}
      translate <-0.5,-0.5,0>
      scale 2*<cam_mirror*fx,fy,0.5>
      translate fz*z
      scale back_dist
      OrientZ(cam_loc,lookat,cam_up)//cam_s) 
}
#declare view_pig =  
pigment {
      image_map {jpeg "pov_logo" once map_type 0 interpolate 2} // "effect" image
      translate <-0.5,-0.5,0>
      scale 2*<cam_mirror*fx,fy,0.5>
      translate fz*z
      scale back_dist
      OrientZ(cam_loc,lookat,cam_up)//cam_s)
}

#declare r1 = seed(1);
#declare r2 = seed(1);
#declare r3 = seed(1);
#declare r4 = seed(1); 
#declare n = 0;
#declare things_numb = 75000;
#if (maxdist_trace = 1)
        #declare things_numb = things_numb*10;
#end
#debug "manythings\n"
#while (n < things_numb)
        #declare rnd_y = vaxis_rotate (cam_d,vcross (cam_d,cam_up),(rand(r1)-0.5)*cam_ang_up);
        #declare rnd_xy = vaxis_rotate (vnormalize (rnd_y),cam_up,(rand(r3)-0.5)*cam_ang);
        #declare Norm = <0,0,0>;
        #declare Inter = trace (manytrees_area,cam_loc,rnd_xy,Norm);
        #if (vlength (Norm) != 0)
                #if (maxdist_trace = 1)                        
                        #declare randdist = -1;
                #else
                        #declare randdist = rand(r4);
                #end
                #if ((Inter.y > 0)&(pow(vlength(cam_loc-Inter)/max_dist,2) > randdist)) //  second condition cares for planting from camera position with equal planting density despite unequal distances
                        #declare ab = (0.6+0.4*rand(r1))*<0.7,1,0.7>*12;
                        #declare ac = 360*rand(r2);
                        #declare ad = 28*pow(rand(r2),2);
                        #declare ae = 360*rand(r2); 
                        #if (maxdist_trace = 1)
                                #declare p = vlength(cam_loc-Inter);
                                #if (p > max_dist)
                                        #declare max_dist = p;
                                #end                        
                        #else        
                                #declare NormP = <0,0,0>;
                                #declare InterP = trace (view_paint,cam_loc,rnd_xy,NormP);
                                #if ((vlength (NormP) != 0)&(eval_pigment(view_pig,InterP).x > 0.1))    //  responsible for all sorts of planting effects from a simple image
                                        #write (filehandle,"object {tree_back2 scale ",ab," rotate y*",ac," rotate <",ad,",",ae,",0> translate ",Inter,"} // ",n+1,"\n")
                                #else
                                        #write (filehandle,"object {tree_back1 scale ",ab," rotate y*",ac," rotate <",ad,",",ae,",0> translate ",Inter,"} // ",n+1,"\n")
                                #end
                        #end
                        #declare n = n+1; 
                #end
        #end
        #if(mod(n,1000)=0)
                #debug concat(str(n,0,0)," things\n")
                //#debug concat(str(max_dist,0,3)," max_dist\n")
        #end        
#end    
#if (maxdist_trace = 1)
        #debug concat(str(max_dist,0,3)," max_dist\n")
#end