/*
   ----------------                Tree Logo                    ------------------------
   ----------------            10.September 2005                ------------------------
   ----------------       copyright by Norbert W. Kern          ------------------------
   ----------------      norbert-werner.kern@t-online.de        ------------------------ 
*/


//      Demonstration scene file for new planting method from camera point of view.

//      Before a HF (HF_back_mountains.pov) and the tree coordinates have to be generated (vegmanythings_WRITE.pov).
//      Render with aspect ratio 2:1

#version 3.5;

#declare Save_Rad = 1;  // 1=save rad; 2=load rad data; 0=no rad storing
#declare RAD      = 2;  // radiosity quality settings 0=out; 1=acceptable; 2=ok
                
global_settings {
        #declare a_g = 2.2;
        assumed_gamma a_g
        max_trace_level 25
        noise_generator 2  
        #if (RAD > 0)
                radiosity {
                        pretrace_start 0.08
                        pretrace_end   0.04/RAD
                        count 30*RAD                
                        nearest_count RAD      
                        error_bound 2/RAD
                        low_error_factor 0.5      
                        recursion_limit 1      
                        gray_threshold 0  
                        minimum_reuse 0.015 
                        brightness 2.5      
                        adc_bailout 0.005
                        normal on
                        media off
                        #if (Save_Rad = 1)
                                save_file "pov.rad"
                        #else
                                #if (Save_Rad = 2)
                                        load_file "pov.rad" 
                                        always_sample off
                                #end
                        #end                          
                }
        #end
} 
       
#include "functions.inc"
#include "transforms.inc"

// code idea from http://www.spiritone.com/~english/cyclopedia/background.html 
#declare cam_loc = <37,3.5,0>;
#declare lookat = <37,3.52,-1>;
#declare cam_ang = 64.8;
#declare cam_mirror = -1;  // 1 for normal / -1 for mirror image
#declare cam_z = 0.5*image_width/image_height/tan(radians(cam_ang*0.5)); //the amount of camera zoom you want
#declare back_dist = 1000; // how far away the background is
#declare cam_a = cam_mirror*image_width/image_height; // camera aspect ratio
#declare cam_s = y; // camera sky vector
#declare cam_d = vnormalize (lookat-cam_loc); // camera direction vector
#declare cam_r = vnormalize (vcross(cam_s,cam_d)); // camera right vector
#declare cam_up = vnormalize (vcross(cam_d,cam_r)); // camera up vector
#declare cam_dir = cam_d*cam_z; // direction vector scaled
#declare cam_right = cam_r*cam_a; // right vector scaled

camera {
        location cam_loc
        up cam_up
        right cam_right
        direction cam_dir 
}
/*  
camera {                        // equivalent camera definition
        location cam_loc 
        right cam_right  
        look_at lookat 
        angle cam_ang
}
*/
//______________________________________________________________________________

#declare lights = <-1,1,-0.7>*100000;
        
#macro G(Color,g)
        <pow(Color.x,g),pow(Color.y,g),pow(Color.z,g)>
#end
        
light_source {
        lights,
        G(<1,0.836,0.567>*7,1/a_g)*4/3 
        //area_light <1000,0,0> <0,0,1000> 3,3 adaptive 0 jitter circular orient
}  

#declare Gamma = 2.2/a_g;

sky_sphere {
        pigment{
                gradient y 
                color_map {
                        [0.0 rgb 3.125]
                        [0.4 rgb G(<0.4,0.4,0.4>,1/a_g)*3.125]
                        [0.7 rgb G(<0.02,0.08,0.3>,1/a_g)*3.125]
                        [1.0 rgb G(<0.005,0.02,0.3>,1/a_g)*3.125]
                }
                scale 2 
                translate -1
        }
}

fog {
        fog_type   2
        distance   2000
        color      rgb <0.7,0.8,1>*1.3
        fog_offset 1000
        fog_alt    1500
        turbulence 0
}

//_________________________________________________________________________________    
// water  
        // water material from Gilles Tran (http://www.oyonale.com/ressources/english/sources15.htm)
#declare C_Water = rgb <96,105,100>/255; 
#declare M_Water = 
material {
        texture {
                pigment {rgbt<C_Water.red,C_Water.green,C_Water.blue,0.8>}
                normal {
                        pigment_pattern {
                                bozo
                                color_map {
                                        [0.45   rgb 0]
                                        [0.55   rgb 1]
                                }
                        }
                        scale 10
                        normal_map {
                                [0      ripples frequency 400 bump_size 0.04 turbulence 0.1]
                                [1      function {
                                                f_noise3d( x*1, y*5, z*5)*0.8
                                                +f_noise3d( x*10, y*50, z*50)*0.2
                                                +f_noise3d( x*100, y*200, z*200)*0.2
                                        }
                                        bump_size 0.1
                                ]
                        }
            
                }
                finish {
                        ambient 0
                        diffuse 0.3
                        specular 1
                        roughness 1/500
                        metallic
                        brilliance 2
                        reflection {
                                0.6,1
                                fresnel on              
                                exponent 1
                        }
                        conserve_energy
                }
        }                
        interior {
                ior 1.33
                fade_distance 0.4
                fade_power 2
        }
}                                       

plane {
        y,-0.05 hollow double_illuminate
        material {M_Water scale 0.5}
}
 
plane {
        y,-1.6 hollow double_illuminate
        texture {
                pigment {color rgb 0.05}
                finish {ambient 0 diffuse 0.5}
        }
}

//_________________________________________________________________________________    
// land
#declare hfB =
height_field { 
        png "HF_back_mountains"
        water_level 0.005 smooth         
        translate <-0.5,-0.5,-0.5> 
        scale <10000,924,8000>*0.25
} 

#declare gam = 1.3;

#declare land_tex =
texture {
        pigment {
                granite
                color_map {
                        [0 rgb G(<0.414-0.1,0.359,0.251>,gam)]
                        [1 rgb G(<0.441+0.1,0.386,0.279>,gam)]
                }
        }
        normal {granite -1}
        finish {
                ambient 0
                diffuse 0.45
        }
}

#declare backtree_area =
union {
        height_field {
                hfB         
                rotate <0,-25,0>
                translate <900,70,-600>
        }
        height_field {
                hfB
                scale 5         
                rotate <0,-25,0>
                translate <500,350,-5200>
        } 
        texture {land_tex}
}

object {backtree_area hollow double_illuminate}    
 
//_________________________________________________________________________________    
// many fake trees 
#declare gam = 1.3;

#declare trunk_tex =
texture {
        pigment {
                granite
                color_map {
                        [0 rgb G(<0.414,0.359,0.251>,gam)]
                        [1 rgb G(<0.441,0.386,0.279>,gam)]
                }
        }
        normal {granite 0.57}
        finish {
                ambient 0
                diffuse 0.45
        }
        scale 0.3
}

#declare needle_tex =
texture {
        pigment {
                granite
                color_map {
                        [0 rgb G(<0.403-0.1,0.435,0.168>,gam)]
                        [1 rgb G(<0.571-0.2,0.543,0.180>,gam)]
                }
        }
        normal {granite 0.6 scale 0.1}
        finish {
                ambient 0
                diffuse 0.35
                phong 1
                phong_size 75
        }
        scale 0.3
}

#declare needle_tex2 =
texture {
        pigment {
                granite
                color_map {
                        [0 rgb G(<0.435,0.403-0.1,0.168>,gam)]
                        [1 rgb G(<0.543,0.571-0.1,0.180>,gam)]
                }
        }
        normal {granite 0.6 scale 0.1}        
        finish {
                ambient 0
                diffuse 0.7
                phong 1
                phong_size 75
        }
        scale 0.3
}
    
#declare tree_back1 = 
union {
        cylinder {<0,0,0>,<0,0.6,0>,0.05 texture {trunk_tex}}
        cone {<0,0.3,0>,0.23,<0,0.98,0>,0 texture {needle_tex}}
        double_illuminate hollow
}

#declare tree_back2 = 
union {
        cylinder {<0,0,0>,<0,0.6,0>,0.05 texture {trunk_tex}}
        cone {<0,0.3,0>,0.23,<0,0.98,0>,0 texture {needle_tex2}}
        double_illuminate hollow
}

#include "veg_manythings.inc" 

