#include "shapes.inc"
#include "colors.inc"
#include "textures.inc"
#include "skies.inc"

global_settings
{
	adc_bailout 0.01
	ambient_light <1.0,1.0,1.0>
  	assumed_gamma 1.9
 	hf_gray_16 off
  	irid_wavelength <0.247059,0.176471,0.137255>
  	max_intersections 64
  	max_trace_level 8
  	number_of_waves 10
  	noise_generator 2
  	charset ascii

	radiosity
	{
		pretrace_start 0.08
		pretrace_end 0.06
		count 80
		
		nearest_count 5
		error_bound 0.4
		recursion_limit 1

		low_error_factor 0.9
		gray_threshold 0.0
		minimum_reuse 0.025
		brightness 1

		adc_bailout 0.01 / 2
		load_file "floater.rad"
	}

	photons
	{
		count 2000000
		autostop 0
		jitter 0.4
		radius 0.625
		load_file "floater.pht"
	}
}

#declare FRONT_TEXTURE = texture {

    pigment {
        //checker color Blue color Red
        //scale 10
        //color Blue
        color red  0 green  0.820312 blue  0
    }
    finish {
        ambient 0.5
        diffuse 0.4
    }
}
#declare BACK_TEXTURE = texture{FRONT_TEXTURE};

#declare floater = object
{
 #include "floater.inc"

	material
	{
	texture
	{
	pigment	
	{
		radial
		
		color_map
		{
			[0 Feldspar transmit 0.15 filter 0.25]
			[0.5 Coral transmit 0.25 filter 0.25 ]
			[1 White transmit 0.35 filter 0.25]
		}
	
		scale 1200
		frequency 8
	}
	finish
	{
		diffuse 0.3	
		ambient 0.45

		reflection{
		 0.45,0.65
		fresnel on
		}	
	}
	}

	interior
	{
		ior 1.5
		dispersion 1.4
		dispersion_samples 10
		caustics 2
	}
	
	}
}

object
{
	floater
	rotate y*180
	rotate z*45
	
	photons
	{
		target 1.0
		reflection on
		refraction on
	}
}

#declare sun = sphere
{
 	<0,0,0>,1000
material
{
	texture
	{
		pigment
		{
			bumps

			color_map
			{
				[0 color White * 2]
				[0.5 color Gray85]
				[1 color Gray70]
			}

			scale 550
			turbulence 1.75
		}

		finish
		{
		 	diffuse 1
			ambient 1
		}
	}
}
	translate <-10000,20000,4000>

	no_shadow
}

//camera
 camera {
  location  <0.0, -1500.0, 800.0>
     right     <-1, 0.0,  0.0>
   //right     <0.0, 0.0,  0.0>
   //up        <0.0, 0.0,  0.0>
  direction <0.0, 0.0,  -1.0>
  look_at <0,1000,0>
 }
 // Light source
 light_source { <-10000,20000,4000> colour White looks_like {sun} photons{reflection on refraction on}}    
 light_source { <-10000,20000,4000> colour Violet looks_like {sun} photons{reflection on refraction on}}    

object
{
 sun
}


plane
{ //Second Water Plane
 z,100
 hollow
	material
	{
		texture
		{
			pigment
			{
				bumps

				color_map
				{
					[0 color LightBlue transmit 0.55 filter 0.25]
					[1 color Blue transmit 0.55 filter 0.25]
				}

				scale 1000
	                }
			finish
			{
				diffuse 0.45
				ambient 0.55
				reflection 0.2

				phong 0.05
				phong_size 0.15
			}

			normal
			{
				ripples 0.25

				scale 1000
			}
		}
	}
}

plane
{ //Third Water Plane
 z,65
 hollow
	material
	{
		texture
		{
			pigment
			{
				bumps

				color_map
				{
					[0 color LightBlue transmit 0.25 filter 0.2]
					[1 color Blue transmit 0.25 filter 0.2]
				}

				scale 1000
				turbulence 0.25
	                }
			finish
			{
				diffuse 0.45
				ambient 0.55
				reflection 0.25
			}

			normal
			{
				ripples 0.15

				scale 1000
			}
		}
	}
}

sphere
{
	<0,0,0>,100000
material
{
	texture
	{
		T_Cloud1
		scale 1000
	}
	rotate x*90
}
	hollow
}

sphere
{
	<0,0,0>,150000
material
{
	texture
	{
		pigment
		{
			color Blue transmit 0.35
		}

		finish

		{
			diffuse 0.1
			ambient 0.2
		}
	}
	rotate x*90
}
	hollow
}

#declare linux = 1;

#declare galaxy_seed = 1122.2333;
#include "/mnt/win/programs/povray/include/galaxy/galaxy.inc"

#declare galaxy_seed = 2333.1122;
#include "/mnt/win/programs/povray/include/galaxy/galaxy.inc"

#declare galaxy_seed = -2333.1122;
#include "/mnt/win/programs/povray/include/galaxy/galaxy.inc"

#declare galaxy_seed = -1122.2333;
#include "/mnt/win/programs/povray/include/galaxy/galaxy.inc"

#declare galaxy_seed = 122.2333;
#include "/mnt/win/programs/povray/include/galaxy/galaxy.inc"

#declare galaxy_seed = 233.122;
#include "/mnt/win/programs/povray/include/galaxy/galaxy.inc"

#declare camera_location = <0.0, -1500.0, 800.0>;
#declare camera_look_at = <0,1000,0>;
#declare effect_location = <9000,28500,0>;
#declare effect_scale = 1.5;
#declare effect_type = "Sun";
#declare effect_always_on_top = false;
#declare effect_intensity = 2;

#include "/mnt/win/programs/povray/include/lens/lens.inc"

light_source
{ 
	<9000,28500,0>
	color Coral
	photons
	{
		reflection on
		refraction on
	}
}

light_source
{ 
	<9000,28500,0>
	color White
}
