/*
 * file 	spyrocandle01.pov
 * desc		A simple object once upon a time used to be drawn on greetings cards
 * auth		Paolo Gibellini
 * date		12/06/2005
 * note		Due to lack of time, both body and flame of the candle was made with Spilineditor
 * todo		Possible use of isosurfaces?
 */

#version 3.5;

// 0= fast draft, 1=final
#declare final=1;
// 1=radiosity on, 0=off
#declare radon=0;
// 0=bumps off, 1=bumps on
#declare bumpon=0;
// 1=area light on, 0=off
#declare areaon=1;

#include "colors.inc"
#include "spyrocandle01.inc"
#include "spyroflame01.inc"  
#if(final=1) 
	#include "woods.inc"
	#include "golds.inc"
	#include "textures.inc"
	#include "metals.inc"
	//#include "glass.inc"
#end

global_settings { 
	#if(radon=1)
		radiosity{}
	#else
  		assumed_gamma 1.0
  	#end
}

// Ambient --------------------------------
camera {
  location  <0.5, 2, -3.0>
  direction 1.5*z
  right     x*image_width/image_height
  look_at   <0.0, 0.6,  0.0>
}

#if(final=1)
	// From net samples ..........................................................
	// sky ---------------------------------------------------------------------
	light_source{ <-1000, 800, 3000> 
	              color White
	              looks_like{ sphere{ <0,0,0>, 200 
	                                  texture{ pigment{ color White*0.9 }
	                                           normal { bumps 1.5
	                                                    scale 20    }
	                                           finish { ambient 0.8   
	                                                    diffuse 0.2
	                                                    phong 1     }
	                                                  
	                                         } // end of texture
	                                } // end of sphere
	                        } //end of looks_like
	            } //end of light_source
	// clouds ------------------------------------------------------------------
	plane{ <0,1,0>,1 hollow  
	       texture{pigment{ bozo turbulence 0.76
	                        color_map { [0.5  rgbf<1.0,1.0,1.0,1.0> ]
	                                    [0.6  rgb <1.0,1.0,1.0>     ]
	                                    [0.65 rgb <1.5,1.5,1.5>     ]
	                                    [1.0  rgb <0.5,0.5,0.5>     ] }
	                       }
	               finish { ambient 0.25 diffuse 0} 
	              }      
	       scale 500}
	// ...........................................................................
#else
	light_source {
	  <0, 0, 0>            // light's position (translated below)
	  color rgb <1, 1, 1>  // light's color
	  translate <-30, 30, -30>
	}
#end
// ----------------------------------------


// Textures -------------------------------
#if(final=1) 
	//#declare t_body=T_Gold_1A
	//#declare t_body=texture {T_Gold_1A normal {bumps 0.7}}
	#declare t_body=texture {T_Gold_1A
		#if(bumpon)
			normal {
				crackle form <-1.0, 1.0, 0.0>
				scale  0.1
			}
		#end
 	}
	#declare t_body_faceted=texture {T_Gold_1A
		normal {
  			facets
  			coords 1.5
 		}
 	}
	//#declare t_flame=T_Ruby_Glass
	#declare t_flame=texture {pigment {color rgbft <1,0,0,0.5,0.1> }}
	//#declare t_plane= T_Wood24
	#declare t_plane=texture {T_Wood24
         normal {
            bumps 0.6
            scale  0.3
         }
 	}
	#declare t_ocean=texture{ Polished_Chrome
	    normal {crackle 0.15 scale <0.35,0.25,0.25> turbulence 0.5 } 
	    finish {ambient 0.1 diffuse 0.7 reflection 0.60}
    }
#else
	#declare t_body=texture {pigment {color rgb <1,1,0> }}
	#declare t_flame=texture {pigment {color rgbft <1,0,0,0.5,0.1> }}
	#declare t_plane= texture{pigment{color rgb <0.7,0.5,0.3>}}
	#declare t_ocean= texture{pigment{color rgb <0.2,0.3,0.7>}}
#end
#declare t_stoppino=texture {pigment {color rgb <0,0,0> }}
#declare t_rossola=texture {      
         pigment { color rgb <0.8854, 0.0104, 0.0104>}      
         normal {
            crackle form <-1.0, 1.0, 0.0>
            scale  0.1
         }      
         finish {
            ambient 0.1
            phong 0.0863
            phong_size 9.933333
            specular 0.640267
            roughness 0.067667
            crand 0.050333
         }
}
// ----------------------------------------

// Objects --------------------------------
#declare spyrocandle=union {
	object {
		spyrocandle_body
		texture {t_body}
		scale <1,1,-1>
		translate <-0.38,0,0.35>
	}
	cylinder {<0,0,0> <0,2.5,0> 0.01 texture {t_stoppino}}	
	object {
		spyroflame
		texture {t_flame}
		scale 2
		rotate <90,0,0>
		translate <-0.8,3.1,-.02>
	}
	#if(final=1) 
		light_source {
		  <0, 0, 0>
		  color rgb <1, 1, 0.7>
		  translate <0,2.6,0.04>
		}
		light_source {
		  <0, 0, 0>
		  color rgb <1, 1, 0.7>
		  translate <0,2.4,-0.04>
		}
		#if(areaon)
			light_source {
			  0*x
			  color rgb <1, 1, 0.7>
			  area_light
			  <2, 0, 0> <0, 0, 2> // lights spread out across this distance (x * z)
			  2, 2                // total number of lights in grid (4x*4z = 16 lights)
			  adaptive 0          // 0,1,2,3...
			  jitter              // adds random softening of light
			  circular            // make the shape of the light circular
			  orient              // orient light
			  translate <0, 2.5, -0.3>   // <x y z> position of light
			}
		#end
	#end
}
// ----------------------------------------

// Scene ----------------------------------
plane {y, 0 texture {t_ocean}}
box {<-2.5,-0.05,-4> <-1.51,0.05,4> texture {t_plane} rotate <-0.5,0,0>}
box {<-1.5,-0.05,-.5> <-0.51,0.05,2.5> texture {t_plane translate <0.2,0,1> rotate <0,20,0>}}

box {<-0.5,-0.05,-4> <0.5,0.05,4> texture {t_plane}}

box {<0.51,-0.05,-3.5> <1.5,0.05,4.5> texture {t_plane translate <-0.2,0,1> rotate <0,10,0>} rotate <0.5,0,0>}
box {<1.51,-0.05,-5> <2.5,0.05,3> texture {t_plane}}
object {
	spyrocandle
	scale .5
}
// ----------------------------------------
