
#if (TRUNK_MESHES)
	#include "corner_geom.inc"        // INCLUDE FILES FOR MESH IMPORTS (INCLUDED IN LOKISLIME_1.ZIP) (
	#include "handleclip_geom.inc"
	#include "handle_geom.inc"
#else
	#declare CORNER = box {<-1,-12.261,-12.26094>, <13,1.143397,2.549042>} // just the (approximate) bounding box
#end


#declare rimsize = 0.02;

// DECLARATION OF EDGE RIMS AND CORNER OBJECT (USING .OBJ EXPORTED MESH)

// corner is now defined as though the origin were the corner of the object,
// with the object edges extending in +x, -y, +z directions
#declare FULL_CORNER = object {
  union {
    object {
      CORNER
      rotate -y*90
      scale 0.02
      translate <-1,1,-1>*0.001
    }
    sphere {
      0,1
      scale <0.02,0.005,0.02>
      translate <0.16,0.002,0.16>
    }
    sphere {
      0,1
      scale <0.02,0.02,0.005>
      translate <0.16,-0.16,-0.002>
    }
    sphere {
      0,1
      scale <0.005,0.02,0.02>
      translate <-0.002,-0.16,0.16>
    }
  }
}

// rim is now defined from x=0 to 1 as though the box were in the +Z and -Y region
#declare RIM = object {
  #declare rimrad = 0.015;
  union {
    difference {
      box {
        <0,-.1,0>,<1,0,0.1>
      }
      box {
        <0,-rimrad,-1>,<1,1,rimrad>
      }
    }
    cylinder {
      <0,-rimsize/2,0.1>,<1,-rimsize/2,0.1>,rimsize/2
    }
    cylinder {
      <0,-0.1,rimsize/2>,<1,-0.1,rimsize/2>,rimsize/2
    }
    cylinder {
      <0,-rimrad,rimrad>,<1,-rimrad,rimrad>,rimrad
    }
    translate <0, -rimsize/2, rimsize/2>
  }
}


// DECLARATIONS OF RED BITS OF BOX

/*
#declare BOXTOPnBOTTOM = object {
	union {
	  box {
		  <-0.99,0.97,-0.99>, <0.99,0.979,0.99>
	  }
	  box {
		  <-0.99,0,-0.99>, <0.99,0.02,0.99>
	  }
	}
	translate y*0.011
}

#declare BOXSIDE = object {
  box {
    <-0.99,0,-0.99>,<0.99,0.979,-0.97>
  }
}
  */
  




#macro Trunk(minextent, maxextent, sidetex, cornertex, handletex)
	#local minextent = minextent * <1,1,1>;
	#local maxextent = maxextent * <1,1,1>;
	object {
	  union {
	    union {                             // EDGE RIMS AND CORNER BULGES
	      union {
	        object {
	          FULL_CORNER
	          translate <minextent.x, maxextent.y, minextent.z>
	        }
	        object {
	          FULL_CORNER
	          rotate y*90
	          translate <minextent.x, maxextent.y, maxextent.z>
	        }
	        object {
	          FULL_CORNER
	          rotate y*180
	          translate <maxextent.x, maxextent.y, maxextent.z>
	        }
	        object {
	          FULL_CORNER
	          rotate y*270
	          translate <maxextent.x, maxextent.y, minextent.z>
	        }
	      }
	  
	      union {  
	        object {
	          FULL_CORNER
	          scale <1,-1,1>
	          translate <minextent.x, minextent.y, minextent.z>
	        } 
	        object {
	          FULL_CORNER
	          rotate y*90
	          scale <1,-1,1>
	          translate <minextent.x, minextent.y, maxextent.z>
	        }   
	        object {
	          FULL_CORNER
	          rotate y*180
	          scale <1,-1,1>
	          translate <maxextent.x, minextent.y, maxextent.z>
	        }  
	        object {
	          FULL_CORNER
	          rotate y*270
	          scale <1,-1,1>
	          translate <maxextent.x, minextent.y, minextent.z>
	        }
	      }
	      
	  
	      union {
	        object {
	          RIM
	          scale <maxextent.x - minextent.x,1,1>
	          translate <minextent.x, maxextent.y, minextent.z>
	        }
	        object {
	          RIM
	          scale <maxextent.z - minextent.z,1,1>
	          rotate y*90
	          translate <minextent.x, maxextent.y, maxextent.z>
	        }
	        object {
	          RIM
	          scale <maxextent.x - minextent.x,1,1>
	          rotate y*180
	          translate <maxextent.x, maxextent.y, maxextent.z>
	        }
	        object {
	          RIM
	          scale <maxextent.z - minextent.z,1,1>
	          rotate y*270
	          translate <maxextent.x, maxextent.y, minextent.z>
	        }
	      }
	      
	      union {
	        object {
	          RIM
	          scale <maxextent.x - minextent.x,-1,1>
	          translate <minextent.x, minextent.y, minextent.z>
	        }
	        object {
	          RIM
	          scale <maxextent.z - minextent.z,-1,1>
	          rotate y*90
	          translate <minextent.x, minextent.y, maxextent.z>
	        }
	        object {
	          RIM
	          scale <maxextent.x - minextent.x,-1,1>
	          rotate y*180
	          translate <maxextent.x, minextent.y, maxextent.z>
	        }
	        object {
	          RIM
	          scale <maxextent.z - minextent.z,-1,1>
	          rotate y*270
	          translate <maxextent.x, minextent.y, minextent.z>
	        }
	      }
	  
	      object {
	        RIM
	        scale <maxextent.y - minextent.y,1,1>
	        rotate z*90
	        translate <minextent.x, minextent.y, minextent.z>
	      }
	      object {
	        RIM
	        scale <maxextent.y - minextent.y,1,1>
	        rotate z*90
	        rotate y*90
	        translate <minextent.x, minextent.y, maxextent.z>
	      }
	      object {
	        RIM
	        scale <maxextent.y - minextent.y,1,1>
	        rotate z*90
	        rotate y*180
	        translate <maxextent.x, minextent.y, maxextent.z>
	      }
	      object {
	        RIM
	        scale <maxextent.y - minextent.y,1,1>
	        rotate z*90
	        rotate y*270
	        translate <maxextent.x, minextent.y, minextent.z>
	      }
	      
	      texture {
	        cornertex
	      }
	    }
	
	
	
	
	    box {
	      minextent + rimsize, maxextent - rimsize
		  texture {sidetex}
	    }
	
	
		#if (TRUNK_MESHES)
		    union {
		      #if (maxextent.x - minextent.x < 1.0)
		      	#warning "Not enough space for trunk handle!"
		      #end
		    
		      object {
		        HANDLECLIP                            // HANDLE (Using mesh import)
		        scale 0.01
		        rotate -x*90
		        translate <-0.4,0,0>
		      }
		      object {
		        HANDLECLIP
		        scale 0.01
		        rotate -x*90
		        translate <-0.4,0,0>
		        scale <-1,1,1>
		      }
		      object {
		        HANDLE
		        scale <0.0265,0.018,0.018>
		        translate <0,0,-0.12>
		      }
		      cylinder {
		        <-0.48,0,-0.12>,<0.48,0,-0.12>,0.03
		      }
		      
		      translate <(minextent.x+maxextent.x)/2, (minextent.y+maxextent.y)/2, minextent.z + 0.02>
		      
	          texture { handletex }
		    }
		#end
	  }
	}

#end


