

#declare FOCALBLUR = off;           // FLAGS TO SELECT DETAILED LIGHTING/CAMERA
#declare AREALIGHT = on;
#declare TRUNK_MESHES = on;
#declare HIGHQUAL_WATER = on;

#include "shapes.inc"
#include "functions.inc"

#include "trunk.inc"


global_settings {
  max_trace_level 100
}

// +A0.2 +AM2


camera {
	location <0, 2, -15>
	look_at <-2,2,0>
	//angle 45
	#if (FOCALBLUR)
		focal_point <-1.8,2.3,-4>*0.25
		aperture 0.23
		blur_samples 130
		confidence 0.999
		variance 1/1250
	#end
}


// primary
light_source {
	<0.7,1.4,-1.3>*99
	rgb 1.5
	#if ( AREALIGHT )
		area_light
		x*20,y*20,5,5
		circular
		orient
		adaptive 1
		jitter
	#end
}

// fill
light_source {
	<-.6,.05,.9>*999
	rgb <1,.7,.5> * 1
	shadowless
}


// ======================================== Textures =====================================


#declare ShinyFinish = finish {
    diffuse 0.2
    specular 0.4
    roughness 0.025
    metallic 0.45
    brilliance 1.65
    reflection {
      0.25,0.75
      exponent 0.8
      metallic 0.55
    }
  }

#declare GridBumpNormal = normal {
    average
    normal_map {
      [1 gradient x+y+z sine_wave]
      [1 gradient x-y-z sine_wave]
      [3 bumps 0.1]
    }
    scale 0.02
}

#macro ShinyTex(Color)
	texture {
	  pigment {rgb Color}
	  finish {
	    ShinyFinish
	  }
	  normal {
	  	GridBumpNormal
	  }
	}
#end

// THIS MATERIAL DECLARATION REQUIRED *BEFORE* GEOMETRY INCLUDE FILES (no longer true; modified include files to be textureless)
#declare SilverBumpyTex = texture {
  pigment {
    color rgb <1,1,1>
  } 
  finish {
    diffuse 0.42
    brilliance 1.85
    specular 0.35
    roughness 0.07
    reflection {
      0.1,0.2 exponent 0.8
    }
  }
  normal {
    granite 0.1
    scale 0.1
  }
}
#declare SmallSilverBumpyTex = texture {
	SilverBumpyTex
	scale 0.1
}

#declare WoodTexture = texture {
	pigment {
		rgb 1
	}
	normal {
		pigment_pattern {
			wood
			color_map {[0 rgb 0][1 rgb 1]}
		}
		rotate 90*y
	}
	scale .01
}



// ======================================== Background =====================================

sky_sphere {
	pigment {
		planar
		color_map {
			[.7 rgb <.7,.7,1.3>*1]
			[1 rgb <.15,.15,.4>*1.2]
		}
	}
}

fog {
	rgb <.5,.7,.9>
	distance 80
	
	fog_type 2
	fog_offset 0
	fog_alt 2
}

// ======================================== Water =====================================

#declare waterbase = isosurface {
	function {
		y + f_waves(x/2,0,z/2)*1
	}
	contained_by {
		box {<-1000,-100,-1000>, <1000,1.1,1000>}
	}
}

#if (HIGHQUAL_WATER)
	isosurface {
		function {
			y + f_waves(x/2,0,z/2)*1 + 
			f_hetero_mf(x*1.5,y*1.5,z*1.5, 1.1, 2.5, 6,   0, 0, 2)*.05 // a little extra noise
		}
		contained_by {
			box {<-1000,-100,-1000>, <1000,1.1,1000>}
		}
		//accuracy 1e-4

#else

plane {
	y,0
	normal {waves .5}

#end
	
	pigment {rgb <.1,.1,.4>*1.5}
	finish {
		reflection {
			.3,1
			fresnel
		}
		specular .5
		//conserve_energy
	}
	interior {
		ior 1.33
	}
}

// ======================================== Pipe =====================================

union {
	difference {
		union {	
			cylinder {
				y*4, y*100, 1
			}
			cylinder {
				y*3.99, y*4.2, 1.2
			}
		}
		
		cylinder {
			y*3, y*100, 0.85
			//pigment {rgb 0}
		}
	}
	
	texture {
		pigment_pattern {
			bozo
			color_map {[0 rgb 0][1 rgb 1]}
			warp {
				turbulence .8
				octaves 2
				omega .7
				lambda 2
			}
			scale .6
		}
		texture_map {
			[.55
				pigment {
					wrinkles
					color_map {
						[0 rgb .1]
						[1 rgb .9]
					}
					scale 3
					warp {
						turbulence .7
						octaves 4
						omega .6
						lambda 4
					}
					scale 1/3
				}
				normal {
					granite .15
					scale .5
				}
				finish {
					specular .4
					roughness .003
				}
			]
			[.8
				pigment {
					granite
					color_map {
						[0 rgb <.2,.2,.1>*.5]
						[1 rgb <.05,.4,.1>*1.5]
					}
				}
			]
		}
	}
}


// ======================================== Trunks =====================================

#declare trunkrnd = seed(437);
#macro RandomTrunk()
	
	#local Color = <rand(trunkrnd), rand(trunkrnd), rand(trunkrnd)>;
	
	#local ColorMax = Color.x;
	#if (Color.y > ColorMax) #local ColorMax = Color.y; #end
	#if (Color.z > ColorMax) #local ColorMax = Color.z; #end
	
	#local Color = 0.2 + Color/ColorMax*0.8;
	
	#local Size = <2 + rand(trunkrnd)*1.6, rand(trunkrnd)*0.5 + 0.75, 2 + rand(trunkrnd)*1.6>;
	
	object {
		Trunk(
			<0, 0.02, 0>, Size,
			ShinyTex(Color), SmallSilverBumpyTex, SilverBumpyTex
		)
		
		translate <-Size.x, 0, -Size.z>/2
	}
#end

#macro placeRandomTrunk(pos)
	#local norm = <0,0,0>;
	#local pos = <pos.x, 2, pos.z>;
	#local pos = trace(waterbase, pos, -y, norm);
	
	object {
		RandomTrunk()
		
		scale .3
		
		rotate y*rand(trunkrnd)*360
		Reorient_Trans(y, norm)
		translate pos - y*(.03 + rand(trunkrnd)*.1)
	}
#end

placeRandomTrunk(<2,0,0>)

#local fallrnd = seed(44);

#local R = 1;
#while (R < 5)
	#local T = 0;
	#while (T < 5)
		object {
			#local thisT = (T - rand(fallrnd)*.8)/5;
			#local thisR = pow((R - rand(fallrnd)*.8)/5, 0.8);
			placeRandomTrunk(vrotate(thisR*x*10, thisT*y*360))
			//translate <X,0,Y>*3.5
		}
		#local T = T + 1;
	#end
	#local R = R + 1;
#end

// falling trunk
object {
	Trunk(
		<-1.01, 0.02, -1.01>, <1.01, 1.01, 1.01>,
		ShinyTex(<1,0,0>), SmallSilverBumpyTex, SilverBumpyTex
	)
	
	scale .5
	rotate 35*z
	rotate -40*y
	translate y*2
}

// old unused stuff
/*object {
	Trunk(
		<-1.5,0,-1.5>,<1.5,1.1,1.5>,
		ShinyTex(<1,0,0>), SmallSilverBumpyTex, SilverBumpyTex
	)
	scale .1
	rotate -25*y
	translate <.8,0,-.6>
}
object {
	Trunk(
		<-1.8,0,-2.7>,<1.8,1.0,0>,
		ShinyTex(<.3,1,.3>), SmallSilverBumpyTex, SilverBumpyTex
	)
	scale .1
	rotate 90*x
	rotate -10*y
	translate <.85,0,-.2>
}
object {
	Trunk(
		<-1.3,0,-2.6>,<1.3,1.2,0>,
		ShinyTex(<.2,.2,1>), SmallSilverBumpyTex, SilverBumpyTex
	)
	scale .1
	rotate 140*x
	rotate -110*y
	translate <1.1,0.1,-.4>
}*/




