        global_settings { 
        
                assumed_gamma 1.0        
        }


        #declare LightPos = vrotate ( <0,0,-900>, <45,   120, 0> );       
        #declare LightColor = 1.2;                                         
        light_source {
          0*x                   
          color LightColor    
          translate LightPos
        }
        #declare CamPos = vrotate ( <0,0,-18>, <40,   30, 0> )+<0,0,0>;       
        #declare LookAt = <  1, 1, 1 >;                                         
        #declare LensAngle = 10;                                                                            
 
        camera {
          location  CamPos
          look_at   LookAt
          right     x*image_width/image_height  
          angle     LensAngle
        }

        plane { y, .975 
                pigment { rgb .1 
                
                } 
                normal { 
                        crackle  
                        poly_wave .6
                        scale .1
                }
                finish { 
                        specular .8
                        roughness .1
                }
        }  
        
        
        #local MyTex = 
        texture {
                pigment { 
                        image_map { 
                                tga "im_oak.tga" 
                        } 
                } 
                normal { 
                        bump_map { 
                                tga "bm_oak.tga" bump_size 4 
                        } 
                }
                finish { 
                        diffuse .7 
                        specular .5 
                        roughness .1 
                        reflection 0 
                }
        }
        
        bicubic_patch {
          type 1  
           flatness 0.1       
          u_steps 3  
          v_steps 3  
          <0, 1,  3> <1, 1, 3> <2, 1, 3> <3, 1, 3>
          <0, 1,  2> <1, 1, 2> <2, 1, 2> <3, 1, 2>
          <0, 1,  1> <1, 1, 1> <2, 1, 1> <3, 1, 1>
          <0, 1,  0> <1, 1, 0> <2, 1, 0> <3, 1, 0>
           
          texture {
             image_pattern { 
                tga "ip_oak.tga" use_alpha 
             }
             texture_map {  
                [0 
                        pigment { rgb 1 transmit 1 } 
                        finish { 
                                diffuse 0 
                                specular 0 
                                reflection 0 
                                ambient 0                        
                        }
                ]
                [1 
                        MyTex 
               
                ]
               
             }  
             scale 3
             rotate x*90
                        
          }       
        }
