// Process this file with filepp, then simulate for 5000 steps with
// raw output to shrinkwrap.raw (use -r shrinkwrap.raw).
// Then uncomment the following line and re-process / re-simulate.
//#define 2ndPASS

#ifdef 2ndPASS
  #define SPEED1 <0, 0, 0>
  #define SPEED2 <0, 0, 0>
  #define POS1(X) <X, -75, 0>
  #define POS2(X) <X, -75, 0>
#else
  #define SPEED1 (-1.5*y+z)*(50 / (0.1*5000))
  #define SPEED2 (-1.5*y-z)*(50 / (0.1*5000))
  #define POS1(X) <X, 0,-50>
  #define POS2(X) <X, 0, 50>
#endif

global_settings {
  step 0.1
  output mesh2
}

cloth {
  x_size    101
  y_size    101
  dist      1
  strength  2
  shear     1
  stiffness 0.05
  weight    0.005
  hnoise    0.01
  vnoise    0.01

#ifdef 2ndPASS
  read_file "shrinkwrap.raw"
#else
  position { <-50, 0, -50>, 100*x, 100*z }
#endif
  
  translate 0.01*y
  
  attach { 0.00, 0.0, POS1 (-50), SPEED1 }
  attach { 0.05, 0.0, POS1 (-45), SPEED1 }
  attach { 0.10, 0.0, POS1 (-40), SPEED1 }
  attach { 0.15, 0.0, POS1 (-35), SPEED1 }
  attach { 0.20, 0.0, POS1 (-30), SPEED1 }
  attach { 0.25, 0.0, POS1 (-25), SPEED1 }
  attach { 0.30, 0.0, POS1 (-20), SPEED1 }
  attach { 0.35, 0.0, POS1 (-15), SPEED1 }
  attach { 0.40, 0.0, POS1 (-10), SPEED1 }
  attach { 0.45, 0.0, POS1 ( -5), SPEED1 }
  attach { 0.50, 0.0, POS1 (  0), SPEED1 }
  attach { 0.55, 0.0, POS1 (  5), SPEED1 }
  attach { 0.60, 0.0, POS1 ( 10), SPEED1 }
  attach { 0.65, 0.0, POS1 ( 15), SPEED1 }
  attach { 0.70, 0.0, POS1 ( 20), SPEED1 }
  attach { 0.75, 0.0, POS1 ( 25), SPEED1 }
  attach { 0.80, 0.0, POS1 ( 30), SPEED1 }
  attach { 0.85, 0.0, POS1 ( 35), SPEED1 }
  attach { 0.90, 0.0, POS1 ( 40), SPEED1 }
  attach { 0.95, 0.0, POS1 ( 45), SPEED1 }
  attach { 1.00, 0.0, POS1 ( 50), SPEED1 }
  
  attach { 0.00, 1.0, POS2 (-50), SPEED2 }
  attach { 0.05, 1.0, POS2 (-45), SPEED2 }
  attach { 0.10, 1.0, POS2 (-40), SPEED2 }
  attach { 0.15, 1.0, POS2 (-35), SPEED2 }
  attach { 0.20, 1.0, POS2 (-30), SPEED2 }
  attach { 0.25, 1.0, POS2 (-25), SPEED2 }
  attach { 0.30, 1.0, POS2 (-20), SPEED2 }
  attach { 0.35, 1.0, POS2 (-15), SPEED2 }
  attach { 0.40, 1.0, POS2 (-10), SPEED2 }
  attach { 0.45, 1.0, POS2 ( -5), SPEED2 }
  attach { 0.50, 1.0, POS2 (  0), SPEED2 }
  attach { 0.55, 1.0, POS2 (  5), SPEED2 }
  attach { 0.60, 1.0, POS2 ( 10), SPEED2 }
  attach { 0.65, 1.0, POS2 ( 15), SPEED2 }
  attach { 0.70, 1.0, POS2 ( 20), SPEED2 }
  attach { 0.75, 1.0, POS2 ( 25), SPEED2 }
  attach { 0.80, 1.0, POS2 ( 30), SPEED2 }
  attach { 0.85, 1.0, POS2 ( 35), SPEED2 }
  attach { 0.90, 1.0, POS2 ( 40), SPEED2 }
  attach { 0.95, 1.0, POS2 ( 45), SPEED2 }
  attach { 1.00, 1.0, POS2 ( 50), SPEED2 }
}

sphere { <-30, -5, 0>, 5 }
sphere { <-10, -5, 0>, 5 }
sphere { < 10, -5, 0>, 5 }
sphere { < 30, -5, 0>, 5 }
cylinder { <-30, -1.5, 0>, <30, -1.5, 0>, 1.5 }

