// Al posto degli aghi ho messo un insieme di aghi 

//*Xmas-tree include-file by Remco de Korte 1998 (made for Vic)

//The xtree-object is a simple firtree, starting at <0,0,0> up to maxheight

//You can change the tree by altering the rand-seed or the height, or by changing the
//tow increment-steps indeicated below. The setting as it is now is working allright for 
//me, changing it can increase the render-time dramatically.

//extra notes:
//- the semi-colons are for v3.1      
//- it may take some time to parse, depending on the parameters (from a few secs to several hours...)
//- you'll get some degenerate CSG-warnings - I don't know how to avoid those and I didn't think
//    it was a very big problem

//comments to remcodek@xs4all.nl

//here you can change the size of the needles - they're quite large and a bit 'fat' now 
//#declare needle=sphere{<0,0,0>,1 scale<.75,.1,.1> scale 0.9 pigment{rgb<.2,.5,.2>}}
//#declare needlittle=sphere{<0,0,0>,1 scale<.8,.1,.1> scale 0.09 pigment{rgb<.2,.5,.2>}}
#declare needlittle=sphere{<0,0,0>,1 scale<.8,.1,.1> scale 0.4 pigment{rgb<.2,.5,.2>}}
#declare qaghi=2;
#declare needle=union{
	sphere{<0,0,0>,1 scale<.8,.04,.04> scale 0.9 pigment{rgb<.1,.4,.1>}}
	#declare naghi=qaghi;
	#while(naghi>=0)
		object{needlittle rotate <0,40,0> translate <(0.4-naghi*0.8/qaghi),0,0.2> }
		object{needlittle rotate <0,-40,0> translate <(0.4-naghi*0.8/qaghi),0,-0.2> }
		#declare naghi=naghi-1;
	#end
}

#declare branch_text=texture{pigment{rgb<.5,.4,.2>} normal{bumps.9 turbulence .7 scale .025}}

#declare maxheight=30;

#declare r=seed(777);


//start the tree:
#declare xtree=union{

	//the stem (is that the right word?) of the tree, width at top and foot depending on the height
	cone{<0,0,0>,maxheight/50,<0,maxheight,0>,maxheight/200 texture{branch_text}}

	//the top
	sphere{<0,maxheight,0>,maxheight/175 texture{branch_text}} 
  
	#declare cc=maxheight/15;
  
	//this starts the branches of at 1/15th of the tree's size off the ground.
	#while (cc<maxheight)

		//start a branch:  
		union{
			#declare i=0;
			#declare dd=(maxheight*.95-cc)/2.5;
	
			//put needles on the branch:  
			#while (i<dd)
				union{
					sphere{<0,0,0>,.2 scale <1,2.5,1> texture{branch_text}}
					#declare j=60*rand(r);
					//put the needles all around:    
					#while (j<360)
						object{needle translate -x rotate z*-15-i*45/dd rotate y*j+30*rand(r)}
						#declare j=j+60;
					#end
					scale 1-.25*i/dd
					translate y*i 
				}
				#declare i=i+.6;
				//the frequency of the needles (~the amount of needles) depends on this step
				//if you make it smaller you have more needles and a much more rendertime
			#end
	
			rotate z*(-75+cc/2)
			//this makes the branch point up a bit (depending on how high it is on the tree)
			
			rotate y*360*rand(r)
			//this puts it on the tree somewhere around
	
			translate y*cc
			//this puts the branch at its proper height
		}
	
		//put some needles on the stem:
		#declare j=0;
		#while (j<360)
			object{needle translate -x rotate z*(-45-15*rand(r)) translate -x*maxheight/400 rotate y*j+30*rand(r) translate y*cc}
			#declare j=j+60;
		#end
	
		#declare cc=cc+.25;
	
		//this step defines the number of branches. 
		//There's one branch for each step, but it can be at any side of the tree
		//Again, if you make this smaller you'll have more branches, but it'll also render much slower
		//You could probably make the tree more realistic by increasing the step towards the top of the tree
	#end
}
