// By Jeff, 25 Nov 2004 
// http://news.povray.org/povray.general/message/%3Cweb.41a5a9ad89fd27df699939e0%40news.povray.org%3E/#%3Cweb.41a5a9ad89fd27df699939e0%40news.povray.org%3E


// Persistence Of Vision raytracer version 3.6.1
// Stars2.pov Demo/Reference SCENE file

// ********************************************************************
// Camera at origin, "normal" Field of View, looking into the +Z axis.
// ********************************************************************
camera {
    perspective
    location <0,0,0>
    angle 45
    look_at  <0,0,1>
}
// ********************************************************************

// ********************************************************************
// A more advanced example of a starfield using a very large sphere
// instead of a sky_sphere.

// The problem with a sky_sphere is that there is no way to turn off
// reflection; the no_reflection keyword cannot be used on a
// sky_sphere.

// A very large sphere can use the no_reflection keyword so you can
// prevent the reflection of a large number of stars in situations
// where it would look strange, such as highly reflective spacecraft
// or reflective seascapes.

// This starfield texture includes the Milky Way, and uses complex
// pigment patterns to provide different tints, magnitudes and
// obscuration for the starfield.

// The POV code fragment below can be copied and pasted directly into
// POV files to provide a ready-made starry background.
// ********************************************************************

// ********************************************************************
// Starfield with Milky Way using a very large sphere.
// ********************************************************************
// This starfield was deliberately structured to be tweaked by the user
// and includes many intrinsic options. Some elements are somewhat
// interdependant and changing one thing can require changing other
// things in order to get the desired appearance.
// ********************************************************************
// Note that for some scenes you might need to increase the
// max_trace_level due to the amount of transparency used.
// ********************************************************************
// To change the presentation of the galactic ecliptic, or the "Milky
// Way", rotate the entire target sphere to get the desired result.
// ********************************************************************

// ********************************************************************
// First insure that there is in fact a black background; all of the
// texture layers include nonfiltering transparency.
// ********************************************************************
background {color rgb <0,0,0>}
// ********************************************************************

// ********************************************************************
// Pigment Declarations
// ********************************************************************
// Milky Way Stars Pigment
// This is a unique band of stars of increased density across the
// horizon. They "shine through" the band of Milky Way Gas.
// You change the color of the Milky Way stars by changing the color in
// the color_map.
// You can change the density of the Milky Way stars; increase or
// decrease the color_map indexes and INVERSELY change the scale.
// NOTE: The overall magnitude/brightness of these stars is controlled
// at another location further down, in the "MilkyStarBand" texture.
// However the final brightness will also be controlled by the
// transparency of the Milky Way Gas pigment.
#declare MilkyStars =
pigment {crackle form <1,0,0>
  color_map {
    [0.000 0.300 color rgbt <1.00,1.00,1.00,0.00> color rgbt
<1.00,1.00,1.00,0.00>]
    [0.300 1.000 color rgbt <0.00,0.00,0.00,1.00> color rgbt
<0.00,0.00,0.00,1.00>]
      }
  scale 0.001
}
// Milky Way Gas Pigment
// You can change the color_map for the Milky Way gas, and you can
// change the transparencies for a different effect. Note that
// decreasing the transparency will increase the overall magnitude
// and brightness. Note that the magnitude is also controlled in the
// "MilkyGasBand" texture below, so if you change either the
// transparency OR the magnitude, you will probably need to change
// the other for the desired effect. Note that changing the
// transparency will also influence the underlying Milky Way Stars
// texture.
// The first scale vector stretches the granite pigment sideways, to
// promote the impression of a disk/spiral of gas seen from the side,
// and the second scale factor controls the overall "cloud
// granularity".
#declare MilkyGas =
pigment {granite turbulence 0.9 scale <3,1,3> scale 0.5
  color_map {
    [0.00 0.10 color rgbt <0.01,0.01,0.01,0.01> color rgbt
<0.01,0.01,0.01,0.01>]
    [0.10 1.00 color rgbt <0.01,0.01,0.01,0.01> color rgbt
<0.75,0.85,1.00,0.99>]
      }
}
// Star Pigments
// You can change the color saturation if desired.
// You can directly change the densities for each individual star tint
// by changing the color_map index falloff and INVERSELY change the
// pigment scale. Note however that the densities and magnitude ranges
// are also controlled in the final star texture layers below via
// obscuration patterns. Overall magnitudes are also controlled in the
// final star texture layers.
// Reddish Star Pigment
#declare StarRed =
pigment {crackle form <1,0,0>
  color_map {
    [0.000 0.075 color rgbt <1.00,0.80,0.70,0.00> color rgbt
<1.00,0.80,0.70,0.00>]
    [0.075 1.000 color rgbt <0.00,0.00,0.00,1.00> color rgbt
<0.00,0.00,0.00,1.00>]
      }
  scale 0.007
}
// Yellowish Star Pigment
#declare StarYellow =
pigment {crackle form <1,0,0>
  color_map {
    [0.000 0.075 color rgbt <1.00,1.00,0.70,0.00> color rgbt
<1.00,1.00,0.70,0.00>]
    [0.075 1.000 color rgbt <0.00,0.00,0.00,1.00> color rgbt
<0.00,0.00,0.00,1.00>]
      }
  scale 0.007
}
// Bluish Star Pigment
#declare StarBlue =
pigment {crackle form <1,0,0>
  color_map {
    [0.000 0.075 color rgbt <0.70,0.80,1.00,0.00> color rgbt
<0.70,0.80,1.00,0.00>]
    [0.075 1.000 color rgbt <0.00,0.00,0.00,1.00> color rgbt
<0.00,0.00,0.00,1.00>]
      }
  scale 0.007
}
// White Star Pigment
#declare StarWhite =
pigment {crackle form <1,0,0>
  color_map {
    [0.000 0.075 color rgbt <1.00,1.00,1.00,0.00> color rgbt
<1.00,1.00,1.00,0.00>]
    [0.075 1.000 color rgbt <0.00,0.00,0.00,1.00> color rgbt
<0.00,0.00,0.00,1.00>]
      }
  scale 0.007
}
// ********************************************************************

// ********************************************************************
// Final Texture Declarations
// ********************************************************************
// Texture for Milky Way Stars.
// This pigment_pattern imposes a unique band of stars of increased
// density across the horizon to depict the Milky Way. These stars are
// meant to "shine through" the Milky Way Gas texture below.
// This MilkyStarBand texture and the MilkyGasBand texture below both
// use the same radial pigment pattern, "flipped over on its side".
// This texture provides a turbulent blending "stripe" or band running
// from the -x direction at its minimum thickness, cresting at the +z
// axis with its maximum amount of thickness, then decreasing in
// general thickness again until it reaches the +x axis. The pattern
// repeats again from +x to -z to -x.
// It seems more logical to use a gradient y or a function{abs(y)} for
// the pigment_pattern, but this pattern responded better to turbulence
// in the way that I wanted and presented a more desired effect. For
// both this texture and the MilkyGasBand texture, you should not alter
// the color_map associated with the pigment_pattern. Rather, you can
// alter the pigment_map if desired. Changing the pigment_map for the
// Milky Way textures will change the "falloff points" and change the
// overall "thickness" and blending ranges of the Milky Way band. You
// can do this individually for the Milky Way Stars and the Milky Way
// Gas.
// For this MilkyStarBand texture, you can change the overall magnitude
// and brightness by changing the ambience. Note however that these
// stars "shine through" the Milky Way Gas and the Gas pigment
// transparency has a strong effect on how bright these stars are.
#declare MilkyStarBand =
texture {
  pigment {
    pigment_pattern {radial turbulence 0.3 rotate <0,-90,90>
      color_map {
        [0.00 0.25 color rgb <1,1,1> color rgb <0,0,0>]
        [0.25 0.50 color rgb <0,0,0> color rgb <1,1,1>]
        [0.50 0.75 color rgb <1,1,1> color rgb <0,0,0>]
        [0.75 1.00 color rgb <0,0,0> color rgb <1,1,1>]
          }
       }
      pigment_map {
        [0.000 color rgbt <0,0,0,1>]
        [0.920 color rgbt <0,0,0,1>]
        [0.990 MilkyStars]
        [1.000 MilkyStars]
          }
    }
  finish {ambient 0.50 diffuse 0}
}
// Texture for Milky Way Gas.
// This pigment_pattern is the same as that used for the Milky Way
// Stars, and the same basically applies concerning modifications
// in order to change its "thickness".
// The overall magnitude/brightness can be altered by changing the
// ambience, but note that the MilkyGas pigment uses transparency.
// Altering either the ambience for this texture or the transparency
// for the MilkyGas pigment will probably mean changing the other also
// in order to achieve the desired effect. As already noted, changing
// this will also change how the Milky Way Stars look.
#declare MilkyGasBand =
texture {
  pigment {
    pigment_pattern {radial turbulence 0.3 rotate <0,-90,90>
      color_map {
        [0.00 0.25 color rgb <1,1,1> color rgb <0,0,0>]
        [0.25 0.50 color rgb <0,0,0> color rgb <1,1,1>]
        [0.50 0.75 color rgb <1,1,1> color rgb <0,0,0>]
        [0.75 1.00 color rgb <0,0,0> color rgb <1,1,1>]
          }
       }
      pigment_map {
        [0.000 color rgbt <0,0,0,1>]
        [0.920 color rgbt <0,0,0,1>]
        [0.990 MilkyGas]
        [1.000 MilkyGas]
          }
    }
  finish {ambient 0.65 diffuse 0}
}
// Star pigment_pattern layers.
// You can directly change the overall magnitude/brightness of each
// individual texture layer if desired by changing the ambience.
// You can indirectly change the density and magnitude ranges by
// changing the scale of the bozo pigment_pattern (used as an
// "obscuration" pattern), and by changing the pigment_map index
// falloff points. Note that you can do this for individual star tint
// layers.
// Note that each layer is rotated along the X and Y axis differently,
// otherwise they would be "sychronized" and only the top layer would
// be displayed.
// Red Star Texture Layer
#declare StarRedPattern =
texture {
  pigment {
    pigment_pattern {bozo cubic_wave noise_generator 3 scale 0.06
      color_map {
        [0.00 1.00 color rgb <0.00,0.00,0.00> color rgb <1.00,1.00,1.00>]
          }
       }
      pigment_map {
        [0.00 color rgbt <0,0,0,1>]
        [0.01 color rgbt <0,0,0,1>]
        [0.80 StarRed]
        [1.00 StarRed]
          }
    }
  finish {ambient 0.9 diffuse 0}
  rotate <0,0,0>
}
// Yellow Star Texture Layer
#declare StarYellowPattern =
texture {
  pigment {
    pigment_pattern {bozo cubic_wave noise_generator 3 scale 0.07
      color_map {
        [0.00 1.00 color rgb <0.00,0.00,0.00> color rgb <1.00,1.00,1.00>]
          }
       }
      pigment_map {
        [0.00 color rgbt <0,0,0,1>]
        [0.01 color rgbt <0,0,0,1>]
        [0.85 StarYellow]
        [1.00 StarYellow]
          }
    }
  finish {ambient 0.7 diffuse 0}
  rotate <7,47,0>
}
// Blue Star Texture Layer
#declare StarBluePattern =
texture {
  pigment {
    pigment_pattern {bozo cubic_wave noise_generator 3 scale 0.04
      color_map {
        [0.00 1.00 color rgb <0.00,0.00,0.00> color rgb <1.00,1.00,1.00>]
          }
       }
      pigment_map {
        [0.00 color rgbt <0,0,0,1>]
        [0.01 color rgbt <0,0,0,1>]
        [0.70 StarBlue]
        [1.00 StarBlue]
          }
    }
  finish {ambient 1 diffuse 0}
  rotate <13,67,0>
}
// White Star Texture Layer
#declare StarWhitePattern =
texture {
  pigment {
    pigment_pattern {bozo cubic_wave noise_generator 3 scale 0.05
      color_map {
        [0.00 1.00 color rgb <0.00,0.00,0.00> color rgb <1.00,1.00,1.00>]
          }
       }
      pigment_map {
        [0.00 color rgbt <0,0,0,1>]
        [0.01 color rgbt <0,0,0,1>]
        [0.75 StarWhite]
        [1.00 StarWhite]
          }
    }
  finish {ambient 1 diffuse 0}
  rotate <21,77,0>
}
// Package the textures together under one identifier. You can
// temporarily and selectively comment out the layers in order to
// analyze and work on the layers individually.
#declare StarSkyTex =
texture {MilkyStarBand}
texture {MilkyGasBand}
texture {StarRedPattern}
texture {StarYellowPattern}
texture {StarBluePattern}
texture {StarWhitePattern}
// ********************************************************************

// ********************************************************************
// Define the Star Sphere
// The PoVRay "limiting distance" for the camera seems to be about
// 9,999,999 units before textures and objects fail to render; this
// radius of 9,900,000 leaves 100,000 units to use for positioning the
// camera.
// If desired, you can comment out the no_reflection keyword.
#declare StarSphere=
sphere {<0,0,0>,1
  hollow
  no_reflection
  texture {StarSkyTex}
  scale 9900000
}
// ********************************************************************

// Display the star sphere, rotating the galactic ecliptic to get the
// desired result.
//object {StarSphere rotate <0,0,30> rotate <-10,0,0>}


