// File: heidi_013en.pov
// Desc: Heidi hut
// Auth: Paolo Gibellini
// Sorry, no time to comment in english! ;-)
//
// Credits 
//
// MakeSnow macro
// by Gilles Tran (c) 2003
//
// Xmas-tree include-file by Remco de Korte 1998 (made for Vic) - Modified by Paolo Gibellini
//
// Stars2.pov from Jeff (news.povray.org)
//
// Better proportional to 320x200

#version 3.5;

#declare final_render=1;
#declare lang="en";

#include "colors.inc"
#include "textures.inc"
#include "woods.inc"
#include "functions.inc"
#include "stars2.inc"

#if (final_render=1)
	#include "makesnow.inc"
	#include "xtree2.inc"
#end
  
#include "alpe_02.inc"


// Makesnow
#declare Particles=500; // number of snow particles
#declare Size=0.2; // size of the largest snow particle
#declare Thickness=0.2; // thickness of the particles      
#declare MinHeight=0; // snow starts falling from this height ( 1 = max height of the object)
#declare MaxHeight=1.3; // snow stops falling from this height  ( 1 = max height of the object)
#declare Direction=-y+x*0.2+z*0.3; // Direction of gravity, wind etc.(-y = vertical, no wind)

// Globals -------------------------------------
#if (final_render=1)
	// radiosity (global illumination) settings
	global_settings {
	  radiosity {
	    pretrace_start 0.08           // start pretrace at this size
	    pretrace_end   0.04           // end pretrace at this size
	    count 35                      // higher -> higher quality (1..1600) [35]
	    nearest_count 5               // higher -> higher quality (1..10) [5]
	    error_bound 1.8               // higher -> smoother, less accurate [1.8]
	    recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
	    low_error_factor .5           // reduce error_bound during last pretrace step
	    gray_threshold 0.0            // increase for weakening colors (0..1) [0]
	    minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
	    brightness 1                  // brightness of radiosity effects (0..1) [1]
	
	    adc_bailout 0.01/2
	    //normal on                   // take surface normals into account [off]
	    //media on                    // take media into account [off]
	    //save_file "file_name"       // save radiosity data
	    //load_file "file_name"       // load saved radiosity data
	    //always_sample off           // turn sampling in final trace off [on]
	    //max_sample 1.0              // maximum brightness of samples
	  }
	}
#else
	global_settings {
	  assumed_gamma 1.0
	}
#end
// ----------------------------------------------------------

// sky ------------------------------------------------------
sky_sphere {
       pigment{ bozo turbulence 0.76
                        color_map { [0.5  rgbf<0.2,0.2,0.2,1.0> ]
                                    [0.6  rgb <0.2,0.2,0.2>     ]
                                    [0.65 rgb <0.4,0.4,0.4>     ]
                                    [1.0  rgb <0.1,0.1,0.1>     ] }
                       }
}
// ----------------------------------------------------------

// Luci -----------------------------------------------------
light_source{ <-200, 300, 200> color rgb <0.8,0.8,1> }
// Lampada a gas
light_source{<0.6, -0.4, -0.6> color rgb <1, 1, 0.8>
     spotlight
     point_at <0.6, -1, -0.6>
     radius 60     falloff 90
     fade_distance 80 fade_power 1
     media_attenuation on
} 
#if (final_render=1)
	// An area light (creates soft shadows)
	light_source {
	  0*x                 // light's position (translated below)
	  color rgb 1.0       // light's color
	  area_light
	  <8, 0, 0> <0, 0, 8> // lights spread out across this distance (x * z)
	  4, 4                // total number of lights in grid (4x*4z = 16 lights)
	  adaptive 0          // 0,1,2,3...
	  jitter              // adds random softening of light
	  circular            // make the shape of the light circular
	  orient              // orient light
	  translate <0, -1, -4>   // <x y z> position of light
	}
#end
// ----------------------------------------------------------

// Camera ---------------------------------------------------
// Dall'alto
#declare c_alto=camera {
  location  <0, 5, 0>
  look_at   <0, 0,  0>
} 
// Di lato
#declare c_lato=camera {
  location  <2, 2.5, -4>
  look_at   <0, 0,  0>
  /*
  focal_point < 0, -1, -0.8>   	// A fuoco la porta
  aperture 0.3     				// grado di sfocatura del resto
  blur_samples 20      			// pi sono i campioni, pi alta  la qualit e pi  lento...
  */
} 
// Davanti
#declare c_fronte=camera {
  location  <0, 1, -4>
  look_at   <0, 0,  0>
} 
// Destra
#declare c_destra=camera {
  location  <4, 1, 0>
  look_at   <0, 0,  0>
} 
// Da dentro
#declare c_dentro=camera { 
    location <-0.6, -0.6, 0.6> 
    look_at <0, 0, 0> 
    angle 120 
}

camera {c_lato}
// ----------------------------------------------------------

// Textures -------------------------------------------------
#declare T_tronchi = texture { 
    T_Wood19 
    //finish { specular 0.50 roughness 0.1 ambient 0.25 }
    rotate  <0, 88, 0>
    scale <1,1,1> 
}

#declare T_tronco = texture {      
     pigment {
        granite
        color_map
        {
           [ 0.0     rgbft <0.780392, 0.607843, 0.211765, 0.0, 0.0> ]
           [ 0.6     rgbft <0.968627, 0.733333, 0.45098, 0.0, 0.0> ]
           [ 0.6     rgbft <0.5, 0.3, 0.2, 0.0, 0.0> ]
           [ 0.65    rgbft <0.5, 0.3, 0.2, 0.0, 0.0> ]
           [ 0.65    rgbft <0.788235, 0.619608, 0.470588, 0.0, 0.0> ]
           [ 1.0     rgbft <0.85, 0.75, 0.35, 0.0, 0.0> ]
        }
     }      
     finish
     {
        ambient 0.1
        specular 0.1
        roughness 0.5
     }
}

#declare T_foglie = texture {      
     pigment {
        leopard
        color_map
        {
           [ 0.0     rgbft <0.3663, 0.5682, 0.0687, 0.82, 0.0> ]
           [ 0.31    rgbft <0.0887, 0.9886, 0.4438, 0.01, 0.0> ]
           [ 0.39    rgbft <0.1308, 0.9083, 0.5524, 0.2, 0.0> ]
           [ 1.0     rgbft <0.1755, 0.5095, 0.448, 0.43, 0.0> ]
        }
        turbulence 0.6
        ramp_wave
     }      
     finish {
        ambient 0.1
        diffuse 0.5
        phong_size 81.0
        //roughness 0.0
     }
}

#declare t_foglie_neve = texture {      
     pigment {
        leopard
        color_map
        {
           [ 0.0     rgbft <0.3, 0.5, 0.3, 0.82, 0.0> ]
           [ 0.31    rgbft <0.5, 0.7, 0.4, 0.01, 0.0> ]
           [ 0.39    rgbft <0.7, 0.9, 0.7, 0.2, 0.0> ]
           [ 1.0     rgbft <1, 1, 1, 0.43, 0.0> ]
        }
        turbulence 0.6
        ramp_wave
     }      
     finish {
        ambient 0.1
        diffuse 0.5
        phong_size 81.0
        //roughness 0.0
     }
}

#declare t_casa=T_tronchi;
//#declare t_calce=texture{pigment{color rgb<0.9,0.9,0.9>} normal {crackle 0.5 scale <.1,.1,.1>} finish {ambient 0.1 diffuse 0.85 specular 0.2 phong 1}};
#declare t_calce= texture {      
         pigment {
            crackle  
            color_map
            {
               [ 0.0     rgbft <0.8125, 0.8125, 0.8125, 0.0, 0.0> ]
               [ 0.199288  rgbft <0.958333, 0.958333, 0.958333, 0.0, 0.0> ]
               [ 1.0     rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
            }
         }
         scale 0.1
         finish {ambient 0.1 diffuse 0.85 specular 0.2 phong 1}
}
//#declare t_tetto=texture{pigment{color rgb<0.8,0.2,0.2>} finish {ambient 0.1 diffuse 0.85 specular 0.2 phong 1}};
#declare t_tetto=texture {      
         pigment {
            wood
            color_map
            {
               [ 0.0     rgbft <0.941176, 0.47451, 0.47451, 0.0, 0.0> ]
               [ 0.1     rgbft <0.933333, 0.482353, 0.458824, 0.0, 0.0> ]
               [ 0.9     rgbft <0.803922, 0.270588, 0.211765, 0.0, 0.0> ]
               [ 1.0     rgbft <0.776471, 0.270588, 0.215686, 0.0, 0.0> ]
            }
            turbulence 0.04
            octaves 3
            ramp_wave
            scale  <0.05, 0.05, 1.0>
         }
         rotate <60,30,40>
         scale 0.4
}
#declare t_camino = texture {pigment {color rgb <1, 1, 1>} normal {bumps 0.5 scale <.1,.1,.1>}};
#declare t_neve = texture {pigment {color rgb <1, 1, 1>} normal {bumps 0.5 scale <.3,.3,.3>}}
#declare t_monte = texture {pigment {color rgb <1, 1, 1>} normal {bumps 0.5 scale <.3,.3,.3>}}
#declare t_testo = texture{pigment{color rgbf<0.8,0.2,0.2,0.8>} finish { specular 0.7 }}
// ----------------------------------------------------------

// Oggetti --------------------------------------------------
// Albero veloce
#declare fast_tree = union {
    cone {
        <0,2,0>, 2, <0,10,0>, 0
        //texture {T_foglie}
        texture {t_foglie_neve}
    }
    cylinder {
        <0,0,0>,<0,2,0>,0.5
        texture {T_tronco}
    }
}

// Piano
//#declare piano =plane { y, -1}
#declare piano = difference{box {<-10,-1.1,-20>, <10,-1,10>} sphere {<-10,-1,8> 10}}
// Finestre
#declare finestre=union {
	box {<0,0,0>, 			<0.48, 0.48, 0.05>	}
	box {<0.52, 0, 0>,		<1, 0.48, 0.05>		}
	box {<0, 0.52, 0>,		<0.48, 1, 0.05>		}
	box {<0.52, 0.52, 0>,	<1, 1, 0.05>		}
}
// Casa
#declare pareti=difference {
	// Scheletro
	isosurface {
	  function{
	    abs(x)-1+y
	  }
	  contained_by { box {-1, 1 } }
	  accuracy 0.05
	  max_gradient 5
	  scale <1,0.8,1>
	  translate <0,-0.2,0> 
	}
	// Vacuum
	object {box {-0.95, 0.95} scale <1,0.8,1> translate <0,-0.15,0>}
	// Vano porta
	//object {box {0,1} scale <0.3,0.5,0.2> translate <0,-0.95,-1.05>}
	object {box {0,1} scale <0.3,0.5,0.2> translate <-0.2,-0.95,-1.05>}
	// Vano finestre lato porta
	object {finestre scale <0.25,0.25,4> translate <0.5,-0.7,-1.05>}
	// Obl Heidi
	cylinder { <0, 0.2, -1.1>, <0, 0.2, -0.8>, 0.1 }
	// Vano finestre destra
	object {finestre scale <0.25,0.25,4> rotate <0,90,0> translate <0.9,-0.7,-0.5>}
}
#declare oblo=difference {cylinder { <0, 0.2, -1.05>, <0, 0.2, -0.95>, 0.1 } cylinder { <0, 0.2, -1.1>, <0, 0.2, -0.8>, 0.09}}
#declare assito_fienile=object {box {-0.95, 0.95} scale <1,0.02,1> translate <0,-0.2,0>}
#declare botola=object {box{0,1} scale <0.3,0.3,0.3> translate <-0.6,-0.3,-0.7>}
#declare pavimento_fienile=difference{
	object{assito_fienile}
	object{botola}
}
#declare legnaia=object {box{0,1} scale <0.3,0.52,1> translate <-1.28,-0.95,-1>}
#declare stalla=object {box{0,1} scale <0.3,0.5,1> translate <0.9,-0.95,0>}
#declare tetto_sn=object {box{0,1} scale <2,0.02,2.4> rotate <0,0,40> translate <-1.52,-0.62,-1.2>}
#declare tetto_dx=object {difference{box{0,1} box{<0.65,-0.1,-0.1>,<1.1,1.1,0.4>}} scale <2,0.02,2.4> rotate <0,0,-40> translate <0,0.65,-1.2>}
#declare tetto=union {
	object{tetto_sn}
	object{tetto_dx}
}
#declare camino=object {difference {box{0,1} box{<0.1,-0.1,0.1>,<0.9,1.1,0.9>}} scale <0.2,0.3,0.2> translate <0.3,0.25,0.5>}
#declare porta_aperta=object {box {0,1} scale <0.3,0.5,0.05> rotate <0,-40,0> translate <-0.19,-0.95,-1.00>}
#declare porta_chiusa=object {box {0,1} scale <0.3,0.5,0.05> translate <-0.2,-0.95,-0.95>}
#declare calce_pareti=object {difference {box{-1,1} box{<-0.99,-1.1,-0.99>,<0.99,1.1,0.99>}} scale <1.001,0.5,1.001> translate <0,-0.7,0>}
#declare calce=difference {
	object {calce_pareti}
	// Vano porta
	object {box {0,1} scale <0.3,0.5,0.2> translate <-0.2,-0.95,-1.05>}
	// Vano finestre lato porta
	object {finestre scale <0.25,0.25,4> translate <0.5,-0.7,-1.05>}
	// Vano finestre destra
	object {finestre scale <0.25,0.25,4> rotate <0,90,0> translate <0.9,-0.7,-0.5>}
}
#declare panchetta=union {
	object {box {0,1} scale <0.4,0.05,0.1> translate <0.4,-0.95,-1.1>}
	object {box {0,1} scale <0.3,0.05,0.08> translate <0.45,-1,-1.1>}
}
    
#declare casa=union {
	object {pareti				texture {t_casa}}
	object {calce 				texture {t_calce}}
	object {pavimento_fienile	texture {t_casa}}
	object {oblo				texture {t_casa}}
	object {legnaia				texture {t_casa}}
	object {stalla				texture {t_casa}}
	object {tetto				texture {t_tetto}}
	object {camino 				texture {t_camino}}
	object {porta_aperta		texture {t_tetto}}
	object {panchetta			texture {t_casa}}
}

// ----------------------------------------------------------

// Assemblaggio scena --------------------------------------- 
#if (final_render=1)
	union {
		object {casa}
	    object {MakeSnow(tetto,Particles,Size,Thickness,MinHeight,MaxHeight,Direction)}
	    object {MakeSnow(panchetta,Particles/40,Size/5,Thickness,MinHeight,MaxHeight/2,Direction)}
	}
#else
	object {casa}
#end

#if (final_render=1)
	object {xtree scale 0.1 translate <-2,-0.5,3>}
	object {xtree scale 0.2 translate <-1,-0.4,3>}
	object {xtree scale 0.3 translate <0.6,-0.3,3>}
#else
	object {fast_tree scale 0.4 translate <-2,-0.5,3>}
	object {fast_tree scale 0.6 translate <-1,-1,3>}
	object {fast_tree scale 0.7 translate <0.6,-0.8,3>}
#end  
// Monti
union {
	object{hama_obj0
		translate <2,-1,4>
		scale <2,1,2>
	
	}
	object {piano}
	texture {t_monte}
	finish{phong 0.1}
}
// Stelle
object {StarSphere rotate <0,0,30> rotate <-10,0,0>}

// Auguri
#if (strcmp(lang,"en")=0)
	#declare natale="Merry Xmas!";
	#declare buonanno="Happy 2005!";
#else
	#declare natale="Buon Natale!";
	#declare buonanno="Felice 2005!";
#end
union {
	text {
	  ttf "tahoma.ttf", natale,
	  0.1, // depth
	  0  // spacing
	}
	text {
	  ttf "tahoma.ttf", buonanno,
	  0.2, // depth
	  0  // spacing
	  translate <0, -1, 0>
	}
	rotate <30,-40,0>
	translate <-4, 2.5, -8>
	scale 0.3
	texture {t_testo}
	no_shadow
}
// ----------------------------------------------------------


