// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.5
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3.5;

#include "colors.inc"

global_settings {
  assumed_gamma 1.0
}

// ----------------------------------------

camera {
  location  <1.0, 1.5, -1.0>
  direction 1.5*z
  right     x*image_width/image_height
  look_at   <0.0, 0.0,  0.0>
}
 

light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 1>  // light's color
  translate <-30, 30, -30>
}

// ----------------------------------------

background { rgb .2 }

#local Cube =
mesh {
    triangle {                        //front
      <0,0,0>, <.5,0,0>, <.5,.5,0>
      uv_vectors <0,0>, <1,0>, <1,1>
    }
    triangle {
      <0,0,0>, <.5,.5,0>, <0,.5,0>
      uv_vectors <0,0>, <1,1>, <0,1>
    }
    
    triangle {                           //top
      <0,.5,0>, <.5,.5,0>, <.5,.5,.5>
      uv_vectors <1,0>, <2,0>, <2,1>
    }
    triangle {
      <0,.5,0>, < .5,.5,.5>, <0,.5,.5>
      uv_vectors <1,0>, <2,1>, <1,1>
    }
        
    triangle {                           //side
      <.5,0,0>, <.5,.5,0>, <.5,.5,.5>
      uv_vectors <2,0>, <3,0>, <3,1>
    }
    triangle {
      <.5,0,0>, < .5,.5,.5>, <.5,0,.5>
      uv_vectors <2,0>, <3,1>, <2,1>
    }
     
    triangle {                           //bottom
      <0,0,0>, <.5,0,0>, <.5,0,.5>
      uv_vectors <3,0>, <4,0>, <4,1>
    }
    triangle {
      <0,0,0>, < .5,0,.5>, <0,0,.5>
      uv_vectors <3,0>, <4,1>, <3,1>
    }
            
    triangle {                            //back
      <0,0,.5>, <.5,0,.5>, <.5,.5,.5>
      uv_vectors <4,0>, <5,0>, <5,1>
    }
    triangle {
      <0,0,.5>, <.5,.5,.5>, <0,.5,.5>
      uv_vectors <4,0>, <5,1>, <4,1>
    }    
        
    triangle {                            //backside
      <0,0,0>, <0,.5,0>, <0,.5,.5>
      uv_vectors <5,0>, <5,1>, <6,1>
    }
    triangle {
      <0,0,0>, < 0,.5,.5>, <0,0,.5>
      uv_vectors <5,0>, <6,1>, <5,1>
    }    
               
    texture {    
      uv_mapping pigment { 
        image_map { 
          png "Image1.png"
          map_type 0
          interpolate 0
        }
        scale <6,1,1> 
      }
    } 
    
     
}

object { Cube translate <-.25,-.25,-.25>}  
object { Cube translate <-.25,-.25,-.25> rotate z*180 rotate y*90 translate x*-.75 }
 