/*
  Persistence of Vision Ray Tracer Scene Description File

  Tierra v1.0 - Water include

  --   
  Jaime Vives Piqueres, Apr-May-Jun 2004.

*/

#if (use_water)

// water surface function: a bunch of cosines
#declare nw=Water_Waves;
#declare iw=0;
#declare f_water=
function{
 pigment{
    average
    pigment_map{
    #while (iw<nw)
     [pigment_pattern{
       function{(cos(x))} 
       turbulence .3+.6*rand(r_water) 
       poly_wave 2+2*rand(r_water)
       color_map{[0 rgb 0][0.5 rgb 1][1 rgb 0]}
       phase clock+rand(r_water)
       scale .5+rand(r_water)
       rotate 360*rand(r_water)
      }
     ]
     #declare iw=iw+1;
    #end
    } 
   scale .01
 }
}

// *** water material ***
#if ((use_water=2) | (use_terrain=3))
 // tests material
 #declare m_water=
 material{texture{pigment{rgb (vnormalize(SunColor)*.25)}}}
#else
 // final material
 #declare t_water=
 texture{
  pigment{rgbt 1}
  #if (Water_Surface=2)
  normal{function{f_water(x,y,z).gray}}
  #end
  finish{
   reflection{.1,1 fresnel} conserve_energy
  }
 }
 #declare i_water=
 interior{
  ior 1.33 
  fade_distance .00009
  fade_color rgb vnormalize(SunColor)
  fade_power 2
 }
 #if (use_terrain>0)
  // if using terrain, make foam
  #declare t_foam=
  texture{
   pigment{
    cells turbulence 1 lambda 3
    color_map{
     [0 rgb ReferenceRGB(White) filter .2]
     [1 rgbt 1]
    }
    scale .01
   }
   #if (Water_Surface=2)
    normal{function{f_water(x,y,z).gray}}
   #end
   finish{
    reflection{.1,1 fresnel} conserve_energy
   }
  }
  #declare terrain_coast=object{terrain_notx translate Foam_Level*y} 
  #declare m_water=
  material{
   texture{
    pigment_pattern{object{terrain_coast rgb 0, rgb 1}}
    texture_map{
      [0 t_water]
      [1 t_foam]   
    }
    scale 100 warp{turbulence .3 lambda 3} scale 1/100
    scale 1000 warp{turbulence .3 lambda 3} scale 1/1000
   }
   interior{i_water}
  }
 #else
  // no terrain, no foam
  #declare m_water=
  material{
   texture{t_water}
   interior{i_water}
  }
 #end
#end

// *** water plane ***
#if (Water_Surface=2 | use_water=2)
#declare water=
plane{y, 0
#else
#declare water=
isosurface{
  function{ 
   y-f_water(x,0,z).red*.001
  }
  max_gradient 1
  contained_by{box{<-200,0,-200>,<200,.002,200>}}
#end
 hollow
 translate Water_Height*y
 material{m_water}
}
object{water}

// underwater
#declare t_underwater=
texture{
 pigment{rgb ReflectiveSpectrum(RS_ConstrStone3)}
 finish{ambient 0}
}
sphere{0,6800 hollow 
 texture{t_underwater}
 translate -6800*y
}
#end // use_water
