/*
  Persistence of Vision Ray Tracer Scene Description File

  Tierra v1.0 - Isosurface Terrain include

  --   
  Jaime Vives Piqueres, Apr-May-Jun 2004.

*/

#if (use_terrain)

// ***********************
// *** terrain texture ***
// ***********************

// select pigments combination :
#declare c_snow=ReflectiveSpectrum(RS_Fine_Snow);
#declare c_ice=ReferenceRGB(White*.9+Turquoise*.1);
#switch (Terrain_Colors)
 #case (0) 
  #declare c_stone1=ReflectiveSpectrum(RS_ConstrStone3);
  #declare c_stone2=ReflectiveSpectrum(RS_ConstrStone2);
  #declare c_green1=ReflectiveSpectrum(RS_UknownLeaf1);
  #declare c_green2=ReflectiveSpectrum(RS_Grass2);
  #declare c_green3=ReflectiveSpectrum(RS_UknownLeaf3);
  #declare c_sand1=ReflectiveSpectrum(RS_ConstrStone4);
  #declare c_sand2=ReflectiveSpectrum(RS_ConstrStone5);
  #declare c_roads=ReflectiveSpectrum(RS_ConstrStone4);
  #declare c_terrain1=ReflectiveSpectrum(RS_ConstrStone1);
  #declare c_terrain2=ReflectiveSpectrum(RS_ConstrStone6);
  #declare c_terrain3=ReflectiveSpectrum(RS_ConstrStone7);
  #break
 #case (1) 
  #declare c_stone1=ReflectiveSpectrum(RS_RiverStone1);
  #declare c_stone2=ReflectiveSpectrum(RS_RiverStone2);
  #declare c_green1=ReflectiveSpectrum(RS_UknownLeaf2);
  #declare c_green2=ReflectiveSpectrum(RS_GreenAchmea4);
  #declare c_green3=ReflectiveSpectrum(RS_UknownLeaf4);
  #declare c_sand1=ReflectiveSpectrum(RS_RiverStone3);
  #declare c_sand2=ReflectiveSpectrum(RS_ConstrStone5);
  #declare c_roads=ReflectiveSpectrum(RS_ConstrStone4);
  #declare c_terrain1=ReflectiveSpectrum(RS_ConstrStone7);
  #declare c_terrain2=ReflectiveSpectrum(RS_ConstrStone3);
  #declare c_terrain3=ReflectiveSpectrum(RS_RiverStone4);
  #break
 #case (2) 
  #declare c_stone1=ReflectiveSpectrum(RS_RiverStone4);
  #declare c_stone2=ReflectiveSpectrum(RS_ConstrStone6);
  #declare c_green1=ReflectiveSpectrum(RS_GreenAchmea1);
  #declare c_green2=ReflectiveSpectrum(RS_GreenAchmea2);
  #declare c_green3=ReflectiveSpectrum(RS_GreenAchmea3);
  #declare c_sand1=ReflectiveSpectrum(RS_ConstrStone6);
  #declare c_sand2=ReflectiveSpectrum(RS_RiverStone2);
  #declare c_roads=ReflectiveSpectrum(RS_ConstrStone4);
  #declare c_terrain1=ReflectiveSpectrum(RS_ConstrStone1);
  #declare c_terrain2=ReflectiveSpectrum(RS_ConstrStone2);
  #declare c_terrain3=ReflectiveSpectrum(RS_ConstrStone3);
  #break
#end

// create tricky sloped texture :
#if (use_terrain=2)

 // simple version for tests 
 #declare t_terrain=texture{pigment{Gray}}

#else

 // final version
 // auxiliar textures:
 #declare t_granite= 
 texture{
  pigment{
   bozo
   warp{turbulence 1 lambda 2.5}
   color_map{
    [0.0 rgb c_stone1]
    [1.0 rgb c_stone2]
   }
  }
  finish{specular .3}
  scale .01
 }
 #declare p_plants=
 pigment{
  marble turbulence 1
  color_map{
   [0.0 rgb c_terrain1]
   [0.6 rgb c_terrain2]
   [0.6 rgb c_green1]
   [1.0 rgb c_green2]
  }
  scale .05
 }
 #declare t_bushes1=
 texture{
 pigment{
  bumps turbulence 1 lambda 3
  color_map{
   [0.0 rgb c_terrain1]
   [0.7 rgb c_terrain2]
   [0.7 rgb c_green1]
   [1.0 rgb c_green2]
  }
  scale .05
 }
 }
 #declare t_bushes2=
 texture{
 pigment{
  bumps turbulence 1 lambda 3
  color_map{
   [0.0 rgb c_terrain1]
   [0.3 rgb c_terrain2]
   [0.3 rgb c_green1]
   [1.0 rgb c_green2]
  }
  scale .05
 }
 }
 #declare t_grass=
 texture{
  pigment{
   granite
   pigment_map{
   [0.0 rgb c_green1]
   [1.0 rgb c_green2]
   }
   scale .025 turbulence .3
  }
 }
 #declare t_sand=
 texture{
  pigment{
   granite turbulence 1
   color_map{
    [0 rgb c_sand1]
    [1 rgb c_sand2]
   }
  }
  scale .01
 }
 #declare t_snow=
 texture{
  pigment{rgb c_snow}
  normal{crackle scale .001}
  finish{reflection .05}
 }
 #declare t_ice=
 texture{
  pigment{rgb c_ice}
  finish{reflection .1}
 }

 // textures for different altitudes, for each terrain style
 #declare t_high_slope=texture{t_granite}
 #switch (Terrain_Style)
  #case (0) // arid
   #declare t_bed=
   texture{
    pigment{
     granite
     pigment_map{
     [0.0 rgb c_sand1]
     [1.0 rgb c_sand2]
     }
     scale .025 turbulence .3
    }
   }
   #declare t_beach=
   texture{
    pigment{
     granite turbulence 1
     color_map{
      [0 rgb c_sand1]
      [1 rgb c_sand2]
     }
    }
    scale .01
   }
   #declare t_low_slope=texture{t_sand}
   #declare t_med_slope=texture{t_bushes1}
   #break
  #case (1) // semi-arid
   #declare t_bed=
   texture{
    pigment{
     granite
     pigment_map{
     [0.0 rgb c_sand1]
     [0.6 rgb c_green1]
     [1.0 rgb c_green2]
     }
     scale .025 turbulence .3
    }
   }
   #declare t_beach=
   texture{
    pigment{
     granite turbulence 1
     color_map{
      [0 rgb c_sand1]
      [1 rgb c_green1]
 
     }
    }
    scale .01
   }
   #declare t_low_slope=texture{t_bushes2}
   #declare t_med_slope=texture{t_bushes1}
   #break
  #case (2) // mostly green 
   #declare t_bed=
   texture{
    pigment{
     granite
     pigment_map{
     [0.0 rgb c_sand1]
     [0.3 rgb c_green1]
     [1.0 rgb c_green2]
     }
     scale .025 turbulence .3
    }
   }
   #declare t_beach=
   texture{
    pigment{
     granite turbulence 1
     color_map{
      [0 rgb c_sand1]
      [1 rgb c_green2]
     }
    }
    scale .01
   }
   #declare t_low_slope=texture{t_grass}
   #declare t_med_slope=texture{t_bushes2}
   #break
  #case (3) // very green, forest
   #declare t_bed=
   texture{
    pigment{
     granite
     pigment_map{
     [0.0 rgb c_green2]
     [1.0 rgb c_green1]
     }
     scale .025 turbulence .3
    }
   }
   #declare t_beach=
   texture{
    pigment{
     granite turbulence 1
     color_map{
      [0 rgb c_green1]
      [1 rgb c_green2]
     }
    }
    scale .01
   }
   #declare t_low_slope=texture{t_grass}
   #declare t_med_slope=texture{t_grass}
   #break
  #case (4) // artic
   #declare t_bed=texture{t_granite}
   #declare t_beach=texture{t_snow}
   #declare t_low_slope=texture{t_snow}
   #declare t_med_slope=texture{t_ice}
   #break
  #case (5) // sand desert
   #declare t_bed=texture{t_sand}
   #declare t_beach=texture{t_sand}
   #declare t_low_slope=texture{t_sand}
   #declare t_med_slope=texture{t_sand}
   #break
 #end
 
 // texture for plain areas
 #if (Terrain_Fields)

  // if using fields
  // create the fileds pigment for different terrain styles
  #switch (Terrain_Style)
   #case (0) // arid
    #declare p_fields=
    pigment{
     crackle solid metric Fields_Metric 
      pigment_map{
       [0 rgb c_terrain1]
       [.2 rgb c_sand1]
       [.5 rgb c_terrain2]
       [1 rgb c_terrain3]
      } 
     frequency pi 
    }
    #break
   #case (1) // semi-arid
    #declare p_fields=
    pigment{
     crackle solid metric Fields_Metric 
      pigment_map{
       [0 rgb c_terrain1]
       [.2 p_plants]
       [.5 rgb c_sand1]
       [.7 p_plants rotate 90*y]
       [1 rgb c_terrain2]
      } 
     frequency pi 
    }
    #break
   #case (2) // mostly green 
    #declare p_fields=
    pigment{
     crackle solid metric Fields_Metric 
      pigment_map{
       [0 rgb c_green1]
       [.2 p_plants]
       [.5 rgb c_green2]
       [.7 p_plants rotate 90*y]
       [1 rgb c_terrain2]
      } 
     frequency pi 
    }
    #break
   #case (3) // very green, forest
    #declare p_fields=
    pigment{
     crackle solid metric Fields_Metric 
      pigment_map{
       [0 rgb c_green1]
       [.2 p_plants]
       [.5 rgb c_green2]
       [.7 p_plants rotate 90*y]
       [1 rgb c_green3]
      } 
     frequency pi 
    }
    #break
   #case (4) // artic
    #declare p_fields=
    pigment{
     crackle solid metric Fields_Metric 
      pigment_map{
       [0 rgb c_snow]
       [.2 rgb c_terrain1]
       [.5 rgb c_snow]
       [1 rgb c_terrain2]
      } 
     frequency pi 
    }
    #break
   #case (5) // sand desert
    #declare p_fields=
    pigment{
     crackle solid metric Fields_Metric 
      pigment_map{
       [0 rgb c_sand1]
       [1 rgb c_sand2]
      } 
     frequency pi 
    }
    #break
  #end
  // create plain zones texture: 
  #declare t_plane=
  texture{
   pigment{
    crackle metric Fields_Metric 
    pigment_map{
    [0.0 rgb c_roads]
    [0.005 rgb c_roads]
    [0.005 p_fields]
    [1.0 p_fields]
    }  
    scale Fields_Scale
   }
  }

 #else

  // without fields
  #switch (Terrain_Style)
   #case (0)
    #declare t_plane=texture{t_beach}
    #break
   #case (1)
    #declare t_plane=texture{t_bushes1}
    #break
   #case (2)
    #declare t_plane=texture{t_bushes2}
    #break
   #case (3)
    #declare t_plane=texture{t_grass}
    #break
   #case (4)
    #declare t_plane=texture{t_snow}
    #break
   #case (5)
    #declare t_plane=texture{t_sand}
    #break
  #end

 #end // if terrain fields

 // create slope textures for different altitudes
 // terrain at coast level
 #declare t_coast=
 texture{
  slope y
  texture_map{
   [0.00 t_high_slope]
   [0.70 t_high_slope]
   [0.70 t_med_slope]
   [0.80 t_beach]
   [1.00 t_beach]
  }
 }
 // terrain at low altitudes
 #declare t_terrain_low=
 texture{
  slope y
  texture_map{
   [0.00 t_high_slope]
   [0.70 t_high_slope]
   [0.70 t_med_slope]
   [0.80 t_low_slope]
   [0.90 t_low_slope]
   [0.90 t_plane]
   [1.00 t_plane]
  }
 }
 // terrain at high altitudes
 #declare t_terrain_high=
 texture{
  slope y
  texture_map{
   [0.00 t_high_slope]
   [0.70 t_high_slope]
   [0.70 t_med_slope]
   [0.80 t_low_slope]
   [0.90 t_low_slope]
   [1.00 t_snow]
  }
 }
 #declare t_snowy_peaks=
 texture{
  function{abs(y)}
  scale 10 warp{ turbulence .33} scale 1/10
  texture_map{
   [0.00 t_terrain_low]
   [Snow_Level*1.5/Terrain_Height t_terrain_high]
   [Snow_Level*1.5/Terrain_Height t_snow]
   [1.00 t_snow]
  }
 }


 // final terrain texture
 #declare t_trans=texture{pigment{rgbt 1} finish{diffuse 0 brilliance 0}}
 #declare t_terrain=
 texture{
  function{abs(y)} 
  texture_map{
   #if (use_water)
    [0.00                          t_bed]
    [(Water_Height+Sand_Level)/Terrain_Height     t_coast]  
    [(Water_Height+Sand_Level*1.5)/Terrain_Height t_terrain_low]
   #else
    [0.00                          t_terrain_low]
   #end
   [Snow_Level/Terrain_Height                     t_terrain_low]
   [Snow_Level/Terrain_Height    t_snowy_peaks]
   [1.00                 t_snowy_peaks]
  }
  scale Terrain_Height*y
 }

#end // if use_terrain=2 


// **************************
// *** isosurface terrain ***
// **************************

// create terrain function from supplied function
#declare nt=.1+.8*rand(r_terrf);
#declare isof=
function{
 pigment{
  Terrain_Pattern
  color_map{
   [0 rgb 0] 
   [nt rgb Terrain_Height*rand(r_terrf)]
   [1 rgb Terrain_Height]
  }
  // succesive scales turbulence
  scale .001 warp{turbulence Terrain_Turb} scale 1000
  scale .01 warp{turbulence Terrain_Turb} scale 100
  scale .1 warp{turbulence Terrain_Turb} scale 10
  scale 10 warp{turbulence Terrain_Turb} scale .1
  scale 100 warp{turbulence Terrain_Turb} scale .01
  scale 1000 warp{turbulence Terrain_Turb} scale .001
  // use the random seed for different terrain "formations"
  translate 1000*nt warp{turbulence Terrain_Turb} translate -100*nt
  // use the random seed for different terrain "locations"
  translate 1000*rand(r_terrl)*x
  translate 1000*rand(r_terrl)*z
 }
}

// create the terrain object
#if (use_terrain=3)

 // test plane
 #declare terrain=
 plane{y,Water_Height+.1 hollow texture{t_plane}}

#else

 // untextured isosurface (for use with the object pattern)
 #declare terrain_notx=
 isosurface{
  #if (Terrain_Detail>0)
   function{ 
    y
    -isof(x,0,z).gray*(1-Terrain_Detail)
    -isof(x/Terrain_Detail_Size,y/Terrain_Detail_Size,z/Terrain_Detail_Size).gray*Terrain_Detail
   }
  #else
   function{ 
    y
    -isof(x,0,z).gray
   }
  #end
  max_gradient Terrain_MG
  contained_by{
   box{
    <-Landscape_Size*.5,-.01,-Landscape_Size*.5>,
    <Landscape_Size*.5,Terrain_Height+.01,Landscape_Size*.5>
   }
  }
 }

 // final textured terrain
 #declare terrain=
 object{terrain_notx
  texture{t_terrain}
 }

#end

// placement
object{terrain}

#end // use_terrain
