/*
  Persistence of Vision Ray Tracer Scene Description File

  Tierra v1.0 - Forest include

  --   
  Jaime Vives Piqueres, Apr-May-Jun 2004.

*/

#if (use_forest>0)

#if (use_forest=2)  // test cylinder

cylinder{<Trees_Area.x,0,Trees_Area.y>,<Trees_Area.x,Trees_MaxAltitude,Trees_Area.y>,Trees_Area.z
 texture{pigment{Red}}
}

#else               // final trees

// faked iso-trees:
#declare g1=c_green1;
#declare g2=c_green2;
#declare g3=c_green3;
#declare p_trees=
pigment{
 granite turbulence 1 lambda 2.5
 color_map{
 [0.0 rgbt 1]
 [0.1 rgbt 1]
 [0.1 rgb g1]
 [0.6 rgb g2 filter .2]
 [1.0 rgb g3]
 }
 scale .005
}
#declare t_tronco=texture{pigment{rgb ReflectiveSpectrum(RS_UknownLeaf4)}};
#declare t_trees=
texture{
 pigment{p_trees} 
}
#declare tree=
isosurface{
 function{f_sphere(x,y,z,1) + f_granite(x*.125,y*.125,z*.125)*.9 - f_granite(x*2,y*2,z*2)*.9}
 max_gradient 1
 contained_by{sphere{0,2}}
}


// place faked trees
#declare p_fields=pigment{crackle scale Fields_Scale}
#declare p_forests=pigment{crackle solid scale Fields_Scale}
#declare nt=Num_Trees;
#declare te=Trees_Area;
#declare i=0;
#while (i<nt)
 #declare kk=true;
 #while (kk) 
  #declare Norm_0=<0,0,0>;
  #declare Start_0=<te.x-te.z+te.z*2*rand(r_trees),Terrain_Height+.1,te.y-te.z+te.z*2*rand(r_trees)>;
  #declare Inter_0=trace(terrain,Start_0,-1*y,Norm_0);
  #declare epf=eval_pigment(p_fields,<Start_0.x,Inter_0.y,Start_0.z>).gray;
  #declare epo=eval_pigment(p_forests,<Start_0.x,Inter_0.y,Start_0.z>).gray;
  #if (Terrain_Fields)
   #if (
        // porper slope?
        (Norm_0.y>Trees_Normal) 
        // at least minimum height and not higher than max altitude
        & (Inter_0.y>(Water_Height+Sand_Level)) 
        & (Inter_0.y<(Trees_MaxAltitude*rand(r_trees))) 
        // follow the crackle cell borders and fill some cells
        & (((epf>.01) & (epf<.2*rand(r_trees))) | ((epo>.55) & (epo<.6))) 
       ) 
       #declare kk=false;
   #end
  #else // not using fields
   #if (
        // porper inclination?
        (Norm_0.y>Trees_Normal) 
        // at least minimum height?
        & (Inter_0.y>(Water_Height+Sand_Level)) 
        & (Inter_0.y<(Trees_MaxAltitude*rand(r_trees))) 
       ) 
       #declare kk=false;
   #end
  #end
 #end
 #declare trr=.75+.25*rand(r_trees);
 union{
  cylinder{0,-2*y,.15 pigment{DarkTan}}
  object{tree hollow 
   rotate 360*rand(r_trees)*x
   rotate 360*rand(r_trees)*z
   texture{t_trees translate 100*rand(r_trees)}  
   double_illuminate
  }
  translate 1.5*y
  scale <trr,1+1*rand(r_trees),trr>
  scale (.002+.004*rand(r_trees))
  rotate 360*rand(r_trees)*y
  translate Inter_0
 }
 #declare i=i+1;
#end

#end // if test cylinder

#end // use_forest
