/*
  Persistence of Vision Ray Tracer Scene Description File

  Tierra v1.0 - Cumulus clouds include

  --   
  Jaime Vives Piqueres, Apr-May-Jun 2004.

*/

#if (use_cumulus>0)

#declare rcloud=rand(r_clouds);       // random rotation value
#declare c_cloud=ReferenceRGB(White); // cloud color
#declare test_clouds=sphere{0,.00001} // initial testing objet for trace()

// cloud loop
#declare nc=Num_Cumulus;        
#declare ic=0;
#while (ic<nc)
 
 // cumulus shape object
 #declare ncc=Cumulus_Comps;
 #declare icc=0;
 #if (Cumulus_Type=1)  
 // spherical shape
 #declare cloud_shape=
 union{
  #while (icc<ncc)
   #declare rcs=.01+.19*rand(r_clouds);
   sphere{0,rcs
    translate (-.5*rand(r_clouds))*z
    rotate 180*rand(r_clouds)*x
    rotate 360*rand(r_clouds)*y
   }
   #declare icc=icc+1;
  #end
 }
 #else                
 // disc-shaped
 #declare cloud_shape=
 union{
  #while (icc<ncc)
   #declare rcs=.01+.19*rand(r_clouds);
   sphere{0,rcs
    translate (-.5*rand(r_clouds))*z
    rotate 360*rand(r_clouds)*y
   }
   #declare icc=icc+1;
  #end
 }
 #end

 // make the cloud with random turbulence
 #declare d_cloud=
 density{
     pigment_pattern{
      object{cloud_shape color rgb 0 color rgb 1}
      scale 4 warp{turbulence .3 lambda 2.5} scale 1/4
      rotate 360*rand(r_clouds)
      scale 8 warp{turbulence .6 lambda 2.5} scale 1/8
      rotate 360*rand(r_clouds)
     }
 }

 // place the clouds to not intersect each other too much
 #declare scloud=4+16*rand(r_clouds);
 #declare cloud_pos=<-Landscape_Size*.5+Landscape_Size*rand(r_clouds),Cumulus_Height*2,-Landscape_Size*.5+Landscape_Size*rand(r_clouds)>;
 #declare Norm=<0,0,0>;
 #declare Inter=trace(test_clouds,cloud_pos,-1*y,Norm);
 #if (Norm.gray=0)
  #if (use_cumulus>1)
   #declare this_cloud=
   union{
    sphere{0,.7 pigment{rgb 1 filter 0.7}}
    object{cloud_shape
     texture{pigment{rgb 1}}
    }
    scale <scloud,scloud*.5,scloud>
    rotate 360*rcloud*y
    translate cloud_pos
   }
  #else
   #declare this_cloud=
   sphere{0,.7
    hollow 
    texture{
     pigment{rgb 0 transmit 1} 
     finish{ambient 0 diffuse 0 }
    }
    interior{
     media{ 
      intervals Clouds_Intervals 
      absorption .33
      density{
        d_cloud
        scale 16 warp{turbulence .6 lambda 2.5} scale 1/16
      }
     }
     media{ 
      intervals Clouds_Intervals 
      scattering{1,c_cloud*.03}
      density{
        d_cloud
        scale 16 warp{turbulence .6 lambda 2.5} scale 1/16
      }
     }
    }
    scale <scloud,scloud*.5,scloud>
    rotate 360*rcloud*y
    translate cloud_pos
   }
  #end
  object{this_cloud}
  #declare ic=ic+1;
  #declare test_cloud=
  sphere{0,1
    scale <scloud,scloud*.5,scloud>
    rotate 360*rcloud*y
    translate cloud_pos
  }
  #declare test_clouds=union{object{test_clouds} object{test_cloud}}
 #end

#end // cloud loop

#end // use_cumulus
