/*
  Persistence of Vision Ray Tracer Scene Description File

  Tierra v1.0 - Cirrus shell include

  --   
  Jaime Vives Piqueres, Apr-May-Jun 2004.

*/

#if (use_cirrus)

// basic cloud pigment maped spherically
#declare d_base=
density{
   Cirrus_Density
   color_map{
     [0.00 rgb 0]
     [(1-Cirrus_Level) rgb 0]
     [(1-Cirrus_Level)+Cirrus_Border rgb 1]
     [1.00 rgb 1]
   }
   warp{spherical}
   // changing default orientation to match scene orientation
   rotate 90*x
   rotate 360*rand(r_clouds)*z
}

// density with a tiny layer of clouds
#declare d_clouds=
density{
 spherical
 density_map{
  [0.0 d_base]
  [Cirrus_Flatness d_base]
  [Cirrus_Flatness rgb 0]
  [1.0 rgb 0]
 }
}

// shell sphere with media cirrus
difference{
 sphere{0,1}
 sphere{0,1-Cirrus_Flatness}
 hollow
 texture{pigment{rgbt 1}}
 interior{  
  media{
   intervals Clouds_Intervals
   absorption .04*5
   scattering{1,.04}
   density{d_clouds}
  }
 }
 // scale somewhat like earth in km
 scale 6800 
 translate (-6800+Cirrus_Height)*y
}

#end
