/*
  Persistence of Vision Ray Tracer Scene Description File

  Tierra v1.0 - buildings include (town-like houses)

  --   
  Jaime Vives Piqueres, Apr-May-Jun 2004.

*/

// place houses randomly based on slope and a crackle pattern
#if (use_buildings)

// mesh houses (my first wings3d objetc!)
#include "i_house1.inc"

// fields "guide" patterns
#declare p_fields=pigment{crackle scale Fields_Scale}
#declare p_towns=pigment{crackle solid scale Fields_Scale}

// houses placement loop
#declare nt=Num_Houses;
#declare te=Houses_Area;
#declare hd=.01;
#declare i=0;
#while (i<nt)
 #declare kk=true;
 #while (kk) // keep trying until a valid position is found
  // test terrain slope at a random point and 4 surrounding it
  #declare Norm_0=<0,0,0>;
  #declare Start_0=<te.x-te.z+te.z*2*rand(r_houses),Terrain_Height+.1,te.y-te.z+te.z*2*rand(r_houses)>;
  #declare Inter_0=trace(terrain,Start_0,-1*y,Norm_0);
  #declare epf=eval_pigment(p_fields,Inter_0).gray;
  #declare ept=eval_pigment(p_towns,Inter_0).gray;
  #if (
   // proper slope?
   (Norm_0.y>Houses_Normal) 
   // at least minimum height
   & (Inter_0.y>(Water_Height+Sand_Level)) 
   // fill into the fields, not the roads
   & ((Terrain_Fields)<1 | ((ept>.7)))
   ) 
   #declare Norm_1=<0,0,0>;
   #declare Norm_2=<0,0,0>;
   #declare Norm_3=<0,0,0>;
   #declare Norm_4=<0,0,0>;
   #declare Inter_1=trace(terrain,Start_0+hd*x,-1*y,Norm_1);
   #declare Inter_2=trace(terrain,Start_0-hd*x,-1*y,Norm_2);
   #declare Inter_3=trace(terrain,Start_0+hd*z,-1*y,Norm_3);
   #declare Inter_4=trace(terrain,Start_0-hd*z,-1*y,Norm_4);
   #if ((Norm_1.y>Houses_Normal) & (Norm_2.y>Houses_Normal) & (Norm_3.y>Houses_Normal) & (Norm_4.y>Houses_Normal)) 
    #declare kk=false;
   #end
  #end
 #end
 #declare trr=(.75+.25*rand(r_houses))*.0025;
 object{house1
  scale <1,1,1+rand(r_houses)+rand(r_houses)+rand(r_houses)>
  scale trr*2
  rotate 360*rand(r_houses)*y
  translate Inter_0
 }
 #declare i=i+1;
#end

#end // use_forest
