// Persistence of Vision Ray Tracer Scene Description File
// File: lmundo3.pov
// Vers: 3.5
// Desc: Reflective sphere on a checkered plane (one more)
// Date:14/06/2004
// Auth: Txemi Jendrix
// Website: www.txemijendrix.com

global_settings {
   adc_bailout 0.00392157
   assumed_gamma 1.5
   noise_generator 2
	photons {
      spacing 0.0025
//		save_file "fotones1.fot"
 		load_file "fotones1.fot"   
	} 
}

camera {
   perspective
   location <2.2, 1.2, -2.2333>
   sky <0, 1, 0>
   direction <0, 0, 1>
   right <1.33333, 0, 0>
   up <0, 1, 0>
   look_at <0.066667, -0.26667, 0>
}

light_source {
	<-2.3333, 2, -0.86667>, rgb <1.5, 1.5, 1.5>
   fade_distance 3
   fade_power 3
   
   photons {
      refraction on
      reflection on
   }
}

// 1st some declarations for the checkered plane
#declare baldosa= 
 superellipsoid {<0.2, 0.2> scale <1, 0.1, 1>
           }

#declare baldosas_blancas=
union { 
	object {baldosa}
	object {baldosa translate x*4.1}
	object {baldosa translate x*(-4.1)}	
	object {baldosa translate x*(-8.2)}	
	object {baldosa translate x*8.2}	
pigment {color rgb 1}
}

#declare baldosas_naranjas=
union { 
	object {baldosa}
	object {baldosa translate x*4.1}
	object {baldosa translate x*(-4.1)}	
	object {baldosa translate x*(-8.2)}	
	object {baldosa translate x*8.2}	
translate x*2.05
     pigment {color rgb <1, 0.8, 0>}
}
	
#declare linea_baldosa=
union{
	object {baldosas_blancas}
	object {baldosas_naranjas}	
}

#declare suelo_baldosas=
union {
	object {linea_baldosa }
	object {linea_baldosa translate <-2.05, 0, 2.05>}	
	object {linea_baldosa translate <-2.05, 0, -2.05>}	
	object {linea_baldosa translate z*4.1}
	object {linea_baldosa translate z*(-4.1)}
}
// end of declarations

// The scene

box { // a hollow box to surround everything
   <-4, -1.2, -8>, <4, 4, 8>
   
   pigment {
      gradient <0, 1, 0>
      
      color_map {
         [ 0 color rgb <0.5, 0.5, 1>
         ]
         [ 1 color rgb <0.9, 0.5, 0.9>
         ]
      }
      scale <1, 5, 1>
      translate y*(-1.1)
   }
   rotate y*45
	hollow
   no_shadow
}

sphere { // the reflective sphere
   <0, 0, 0>, 1
   material {
      texture { // the one with earth image map
         pigment {
            image_map {
               png
               "tierra.png"
               map_type 1
               interpolate 2
            }
            scale 2
            rotate y*(-190)
         }
         finish {
            ambient 0
            diffuse 0
            specular 0.3
            roughness 0.005
         }
      }
      
      texture { // the blue cristal
         pigment {
            color rgbft <0, 0, 0.9, 1, 0.5>
         }
         
         finish {
            ambient rgb <0, 0, 0>
            diffuse 0
            specular 0.3
            roughness 0.005
         }
      }
      
      interior {
         ior 1.2
         dispersion 8
         dispersion_samples 40
         fade_distance 0.2
         fade_distance 0.2
      }
   }
   
   photons {
      target
      refraction on
      reflection on
   }
}

object {suelo_baldosas // the checkered plane
   finish {
      ambient rgb <0.1, 0.1, 0.1>
      diffuse 0.6
      specular 0.3
      roughness 0.005
		reflection {
         rgb <0.5, 0.5, 0.5>, rgb <0.5, 0.5, 0.5>
         metallic 0.4
      }
   }
	photons {
      target
      refraction on
      reflection on
   }
translate <1.05,-1.12,-1.05>
rotate y*(-45)
}

plane { 
   <0, 1, 0>, -1.05
   
   finish {
      ambient 0
      diffuse 0.4
   }
   
   pigment {
      color rgb <1, 1, 1>
   }
   
   photons {
      target
      refraction on
      reflection on
   }
}