#macro SSS_AddSharpData(arrayS)
  #if(dimensions(arrayS)!=2)
    #error "Array for sharp data must be two-dimensional.\n"
  #end
  #if(dimension_size(arrayS,2)!=3)
    #error "Array for sharp data must have three elements in second dimension.\n"
  #end

  #declare sssaES=array[ssscE]

  #local iI=0;#while(iI<ssscE)
    #declare sssaES[iI]=0; // smooth by default
  #local iI=iI+1;#end
  
  #local iI=0;#while(iI<dimension_size(arrayS,1))
    #local iA=arrayS[iI][0];
    #local iB=arrayS[iI][1];
    #local iE=0;#while(iE<ssscE)
      #if((sssaEV[iE][0]=iA & sssaEV[iE][1]=iB) | (sssaEV[iE][1]=iA & sssaEV[iE][0]=iB))
        #declare sssaES[iE]=arrayS[iI][2];
      #end
    #local iE=iE+1;#end        
  #local iI=iI+1;#end

// border edges are infinitely sharp, even if user wishes otherwise
  #local iI=0;#while(iI<ssscE)
    #if(sssaEF[iI][1]=-1) #declare sssaES[iI]=-1; #end
  #local iI=iI+1;#end
  SSS_BuildNormals()
#end

#macro SSS_DefaultSharpData()
  #declare sssaES=array[ssscE]
  #local iI=0;#while(iI<ssscE)
    #declare sssaES[iI]=-2;
  #local iI=iI+1;#end

  #local iI=0;#while(iI<ssscF)
    #local iE=sssaFE[iI][0];
    #declare sssaES[iE]=sssaES[iE]+1;
    #local iE=sssaFE[iI][1];
    #declare sssaES[iE]=sssaES[iE]+1;
    #local iE=sssaFE[iI][2];
    #declare sssaES[iE]=sssaES[iE]+1;
    #local iE=sssaFE[iI][3];
    #if(iE>-1)
      #declare sssaES[iE]=sssaES[iE]+1;
    #end
  #local iI=iI+1;#end
  
  SSS_BuildNormals()
#end
