#macro SSS_ImportBasicMesh(arrayV,arrayF)

// destroying old data, if any
#while(defined(ssscV)) #undef ssscV #end
#while(defined(sssaV)) #undef sssaV #end

#while(defined(ssscE)) #undef ssscE #end
#while(defined(sssaEV)) #undef sssaEV #end
#while(defined(sssaEF)) #undef sssaEF #end
#while(defined(sssaES)) #undef sssaES #end

#while(defined(ssscF)) #undef ssscF #end
#while(defined(sssaFV)) #undef sssaFV #end
#while(defined(sssaFE)) #undef sssaFE #end
#while(defined(sssaFM)) #undef sssaFM #end
#while(defined(sssaFN)) #undef sssaFN #end
#while(defined(sssaFT)) #undef sssaFT #end

// validate input data
#if(dimensions(arrayV)>1)
  #error "Vertex array is supposed to be one-dimensional.\n"
#end
#if(dimensions(arrayF)!=2)
  #error "Face array is supposed to be two-dimensional.\n"
#end
#local cV=dimension_size(arrayF,2);
#if(cV<3 | cV>4)
  #error "Faces must have at least three vertices but no more than four.\n"
#end

#if(sssfProgressReports)
  #debug "Copying vertex data.\n"
#end  
// copy vertex data over
#declare ssscV=dimension_size(arrayV,1);
#declare sssaV=array[ssscV]
#local iI=0;#while(iI<ssscV)
  #declare sssaV[iI]=arrayV[iI];
#local iI=iI+1;#end

#if(sssfProgressReports)
  #debug "Copying face data.\n"
#end  
// copy face data over
#declare ssscF=dimension_size(arrayF,1);
#declare sssaFV=array[ssscF][4]

#local qcE=0;
#local iI=0;#while(iI<ssscF)
  #declare sssaFV[iI][0]=arrayF[iI][0];
  #declare sssaFV[iI][1]=arrayF[iI][1];
  #declare sssaFV[iI][2]=arrayF[iI][2];
  #if(cV=4)
    #declare sssaFV[iI][3]=arrayF[iI][3];
  #else
    #declare sssaFV[iI][3]=-1;
  #end
  #if(sssaFV[iI][3]=-1)
    #local qcE=qcE+3;
  #else
    #local qcE=qcE+4;
  #end
#local iI=iI+1;#end
  
#if(sssfProgressReports)
  #debug "Creating temporary edge data.\n"
#end  
// create temporary edge array and face-edge arrays
#declare sssaFE=array[ssscF][4]
#local qaE0=array[qcE] // start, end, face, original index
#local qaE1=array[qcE] // start, end, face, original index
#local qaE2=array[qcE] // start, end, face, original index
#local qaE3=array[qcE] // start, end, face, original index
#local qaX=array[qcE] // cross-reference
#local iI=0;#while(iI<qcE) #local qaE3[iI]=iI; #local iI=iI+1;#end
#local iE=0;
#local iI=0;#while(iI<ssscF)
  #local qaE0[iE]=sssaFV[iI][0];
  #local qaE1[iE]=sssaFV[iI][1];
  #local qaE2[iE]=iI;
  #declare sssaFE[iI][0]=iE;
  #local iE=iE+1;
  #local qaE0[iE]=sssaFV[iI][1];
  #local qaE1[iE]=sssaFV[iI][2];
  #local qaE2[iE]=iI;
  #declare sssaFE[iI][1]=iE;
  #local iE=iE+1;
  #if(sssaFV[iI][3]=-1)
    #local qaE0[iE]=sssaFV[iI][2];
    #local qaE1[iE]=sssaFV[iI][0];
    #local qaE2[iE]=iI;
    #declare sssaFE[iI][2]=iE;
    #declare sssaFE[iI][3]=-1;
  #else
    #local qaE0[iE]=sssaFV[iI][2];
    #local qaE1[iE]=sssaFV[iI][3];
    #local qaE2[iE]=iI;
    #declare sssaFE[iI][2]=iE;
    #local iE=iE+1;
    #local qaE0[iE]=sssaFV[iI][3];
    #local qaE1[iE]=sssaFV[iI][0];
    #local qaE2[iE]=iI;
    #declare sssaFE[iI][3]=iE;
  #end
  #local iE=iE+1;
#local iI=iI+1;#end    

#if(sssfProgressReports)
  #debug "Sorting temporary edge data.\n"
#end  

// put lower index first in each ordered pair
#local iI=0;#while(iI<qcE)
  #if(qaE0[iI]>qaE1[iI])
    #local qS=qaE0[iI];
    #local qaE0[iI]=qaE1[iI];
    #local qaE1[iI]=qS;
  #end
#local iI=iI+1;#end

// sort temporary edge array -- uses quicksort
#local qaS=array[qcE][2]
#local qaS[0][0]=0;
#local qaS[0][1]=qcE-1;
#local iP=1;
#while(iP>0)
  #local iP=iP-1;
  #local iA=qaS[iP][0];
  #local iC=qaS[iP][1];
  #local iM=floor((iA+iC)/2);
  #local iB=iM+1;
  #local iI=iM-1;#while(iI>=iA)
    #if(qaE0[iI]>qaE0[iM] | (qaE0[iI]=qaE0[iM] & qaE1[iI]>qaE1[iM]) )
      #local qS=qaE0[iI]; #local qaE0[iI]=qaE0[iM-1];
      #local qaE0[iM-1]=qaE0[iM]; #local qaE0[iM]=qS;
      #local qS=qaE1[iI]; #local qaE1[iI]=qaE1[iM-1];
      #local qaE1[iM-1]=qaE1[iM]; #local qaE1[iM]=qS;
      #local qS=qaE2[iI]; #local qaE2[iI]=qaE2[iM-1];
      #local qaE2[iM-1]=qaE2[iM]; #local qaE2[iM]=qS;
      #local qS=qaE3[iI]; #local qaE3[iI]=qaE3[iM-1];
      #local qaE3[iM-1]=qaE3[iM]; #local qaE3[iM]=qS;
      #local iM=iM-1;
    #end
  #local iI=iI-1;#end
  #local iI=iB;#while(iI<=iC)
    #if(qaE0[iI]<qaE0[iM] | (qaE0[iI]=qaE0[iM] & qaE1[iI]<qaE1[iM]) )
      #local qS=qaE0[iI]; #local qaE0[iI]=qaE0[iM+1];
      #local qaE0[iM+1]=qaE0[iM]; #local qaE0[iM]=qS;
      #local qS=qaE1[iI]; #local qaE1[iI]=qaE1[iM+1];
      #local qaE1[iM+1]=qaE1[iM]; #local qaE1[iM]=qS;
      #local qS=qaE2[iI]; #local qaE2[iI]=qaE2[iM+1];
      #local qaE2[iM+1]=qaE2[iM]; #local qaE2[iM]=qS;
      #local qS=qaE3[iI]; #local qaE3[iI]=qaE3[iM+1];
      #local qaE3[iM+1]=qaE3[iM]; #local qaE3[iM]=qS;
      #local iM=iM+1;
    #end
  #local iI=iI+1;#end
  #if(iM-1>iA)
    #local qaS[iP][0]=iA;
    #local qaS[iP][1]=iM-1;
    #local iP=iP+1;
  #end
  #if(iM+1<iC)
    #local qaS[iP][0]=iM+1;
    #local qaS[iP][1]=iC;
    #local iP=iP+1;
  #end
#end

// done sorting, delete stack
#undef qaS

// count unique edges
#declare ssscE=1;
#local iI=1;#while(iI<qcE)
  #if(qaE0[iI]!=qaE0[iI-1] | qaE1[iI]!=qaE1[iI-1])
    #declare ssscE=ssscE+1;
  #end
#local iI=iI+1;#end

#if(sssfProgressReports)
  #debug "Validating edge data.\n"
#end  
// ensure that maximum of two faces meet at any edge
#local iI=2;#while(iI<qcE)
  #if(qaE0[iI]=qaE0[iI-2] & qaE1[iI]=qaE1[iI-2])
    #error concat("Three or more faces meet at edge running from vertex ",
      str(qaE0[iI],0,0)," to vertex ",str(qaE1[iI],0,0),"\n")
  #end
#local iI=iI+1;#end

#if(sssfProgressReports)
  #debug "Building face-edge cross-reference.\n"
#end  
// build sssEV, sssEF, and sssFE from temporary edge array
#declare sssaEV=array[ssscE][2]
#declare sssaEF=array[ssscE][2]

#declare sssaEV[0][0]=qaE0[0];
#declare sssaEV[0][1]=qaE1[0];
#declare sssaEF[0][0]=qaE2[0];
#declare sssaEF[0][1]=-1;
#local qaE2[0]=0;
#local iE=0;
#local iI=1;#while(iI<qcE)
  #if(qaE0[iI]=qaE0[iI-1] & qaE1[iI]=qaE1[iI-1])
    #declare sssaEF[iE][1]=qaE2[iI];
  #else
    #local iE=iE+1;
    #declare sssaEV[iE][0]=qaE0[iI];
    #declare sssaEV[iE][1]=qaE1[iI];
    #declare sssaEF[iE][0]=qaE2[iI];
    #declare sssaEF[iE][1]=-1;
  #end
  #local qaE2[iI]=iE; // edge will have this number in final array
#local iI=iI+1;#end

#local iI=0;#while(iI<qcE)
  #local qaX[qaE3[iI]]=qaE2[iI];
#local iI=iI+1;#end

// update face-edge cross-references
#local iI=0;#while(iI<ssscF)
  #declare sssaFE[iI][0]=qaX[sssaFE[iI][0]];
  #declare sssaFE[iI][1]=qaX[sssaFE[iI][1]];
  #declare sssaFE[iI][2]=qaX[sssaFE[iI][2]];
  #if(sssaFE[iI][3]>-1)
    #declare sssaFE[iI][3]=qaX[sssaFE[iI][3]];
  #end
#local iI=iI+1;#end

// delete temporary edge array
#undef qaE0
#undef qaE1
#undef qaE2
#undef qaE3
#undef qaX

#declare sssfO=false; // faces are not oriented

#end

#macro SSS_OrientFaces()
// now orient all faces in the same direction

#local qaM=array[ssscF]
#local iI=0;#while(iI<ssscF)
  #local qaM[iI]=0;
#local iI=iI+1;#end

#local qaM[0]=1;
#local iP=0;
#local cS0=ssscF-1;
#local cS1=1;
#local iW=1; // process

#while (iW!=0) // until all clear
  #switch(iW)
    #case(1) // process
      #local iI=iP;#while(iI<ssscF)
        #if(qaM[iI]=1)
          #local qaM[iI]=2;
          #local cS1=cS1-1;
          #local iS=0;#while(iS<4)
            #local iE=sssaFE[iI][iS];
            #if(iE>-1)
              #local iO=SSS_OtherSide(iI,iE);
              #if(iO>-1)
                #if(qaM[iO]=0)
                  #local qaM[iO]=1;
                  #local cS0=cS0-1;
                  #local cS1=cS1+1;
                  #if(SSS_EdgeDir(iI,iE)=SSS_EdgeDir(iO,iE))
                    #if(sssaFV[iO][3]=-1) // three-sider
                      #local qS=sssaFV[iO][1];
                      #declare sssaFV[iO][1]=sssaFV[iO][2];
                      #declare sssaFV[iO][2]=qS;
                      #local qS=sssaFE[iO][0];
                      #declare sssaFE[iO][0]=sssaFE[iO][2];
                      #declare sssaFE[iO][2]=qS;
                      // swap uv-mapping data, if any
                      #ifdef(sssaFM)
                        #local qU=sssaFM[iO][1];
                        #declare sssaFM[iO][1]=sssaFM[iO][2];
                        #declare sssaFM[iO][2]=qU;
                      #end
                    #else // four-sider
                      #local qS=sssaFV[iO][1];
                      #declare sssaFV[iO][1]=sssaFV[iO][3];
                      #declare sssaFV[iO][3]=qS;
                      #local qS=sssaFE[iO][0];
                      #declare sssaFE[iO][0]=sssaFE[iO][3];
                      #declare sssaFE[iO][3]=qS;
                      #local qS=sssaFE[iO][1];
                      #declare sssaFE[iO][1]=sssaFE[iO][2];
                      #declare sssaFE[iO][2]=qS;
                      // swap uv-mapping data, if any
                      #ifdef(sssaFM)
                        #local qU=sssaFM[iO][1];
                        #declare sssaFM[iO][1]=sssaFM[iO][3];
                        #declare sssaFM[iO][3]=qU;
                      #end
                    #end
                  #end
                #end
              #end
            #end
          #local iS=iS+1;#end
        #end
      #local iI=iI+1;#end
    #break
    #case(2) // set first zero to one
      #local iI=iP;#while(iI<ssscF)
        #if(qaM[iI]=0)
          #local iP=iI;
          #local qaM[iI]=1;
          #local iI=ssscF;
          #local cS0=cS0-1;
          #local cS1=cS1+1;
        #end  
      #local iI=iI+1;#end  
    #break
  #end // switch(iW)
  #local iW=0;
  #if(cS0>0)
    #local iW=2;
  #end
  #if(cS1>0)
    #local iW=1;
  #end    
#end // while(iW!=0)

#declare sssfO=true; // faces now oriented

#end // done with macro

#macro SSS_EdgeDir(iF,iE)
  #local iV=sssaEV[iE][0];
  #local fR=0;
  #if (iE=sssaFE[iF][0]) #local fR=((iV=sssaFV[iF][0])?false:true); #end
  #if (iE=sssaFE[iF][1]) #local fR=((iV=sssaFV[iF][1])?false:true); #end
  #if (iE=sssaFE[iF][2]) #local fR=((iV=sssaFV[iF][2])?false:true); #end
  #if (iE=sssaFE[iF][3]) #local fR=((iV=sssaFV[iF][3])?false:true); #end
  (fR)
#end

#macro SSS_OtherSide(iF,iE)
  #local iO=sssaEF[iE][0];
  #if(iO=iF)
    #local iO=sssaEF[iE][1];
  #end
  (iO)
#end

#macro SSS_AddTextures(aiT)
  #while(defined(sssaFT)) #undef sssaFT #end
  
  #declare sssaFT=array[ssscF]
  
  #local iF=0;#while(iF<ssscF)
    #declare sssaFT[iF]=-1;
  #local iF=iF+1;#end  

  #local iF=0;#while(iF<ssscF & iF<dimension_size(aiT,1))
    #declare sssaFT[iF]=aiT[iF];
  #local iF=iF+1;#end  
#end

#macro SSS_AddUVMapping(auM)
#if(dimensions(auM)!=2)
  #error "UV-mapping array must be two-dimensional.\n"
#end
#local cD=dimension_size(auM,2);

#if(cD<3 | cD>4)
  #error "Second dimension of UV-mapping array must have three or four elements.\n"
#end

#declare sssaFM=array[ssscF][4]
  #local iF=0;#while(iF<ssscF)
    #declare sssaFM[iF][0]=<0,0>;
    #declare sssaFM[iF][1]=<0,1>;
    #if(sssaFV[iF][3]=-1)
      #declare sssaFM[iF][2]=<1,0>;
    #else
      #declare sssaFM[iF][2]=<1,1>;
    #end  
    #declare sssaFM[iF][3]=<1,0>;
  #local iF=iF+1;#end
  
  #local iF=0;#while(iF<dimension_size(auM,1) & iF<ssscF)
    #declare sssaFM[iF][0]=auM[iF][0];
    #declare sssaFM[iF][1]=auM[iF][1];
    #declare sssaFM[iF][2]=auM[iF][2];
    #if(cD=4)
      #declare sssaFM[iF][3]=auM[iF][3];
    #else
      #if(sssaFV[iF][3]>-1)
        #debug "Supplied UV-mapping data has three dimensions, but one or more faces\n"
        #debug "has four vertices.\n"
      #end
    #end
  #local iF=iF+1;#end       
#end // end of macro    