#macro SSS_Subdivide()
#if(sssfO=false) SSS_OrientFaces() #end

#if(sssfProgressReports)
  #debug "Performing subdivision.\n"
#end

#ifndef(sssaES)
  SSS_DefaultSharpData()
#end

#ifndef(sssaFN)
  SSS_BuildNormals()
#end

// count the four-siders
#local cF4=0;
#local iI=0;#while(iI<ssscF)
  #if(sssaFV[iI][3]>-1) #local cF4=cF4+1; #end
#local iI=iI+1;#end

// count the edges that are sharp, but not borders
#local qaES=array[ssscE]
#local cES=0;
#local iI=0;#while(iI<ssscE)
  #if(sssaES[iI]!=0 & sssaEF[iI][1]!=-1)
    #local qaES[iI]=cES;
    #local cES=cES+1;
  #else
    #local qaES[iI]=0;
  #end
#local iI=iI+1;#end

// new edge count=
// two for each old edge
// three for each old face
// one more for each old four-sider

#local ncE=ssscE*2+ssscF*3+cF4;

// new vertex count=
// one for each old vertex
// one for each old edge
// one for each old four-sider

#local ncV=ssscV+ssscE+cF4;

// new face count=
// four for each old face

#local ncF=ssscF*4;

// new normal count=
// one for each old normal
// one for each old edge
// one for each old sharp edge
// one for each old four-sider

#local ncN=ssscN+ssscE+cES+cF4;

// make temp space for new vertices
#local naVS=array[ncV] // weighted sums
#local naVW=array[ncV] // sum of weights

#local iI=0;#while(iI<ncV)
  #local naVS[iI]=<0,0,0>;
  #local naVW[iI]=0;
#local iI=iI+1;#end

// make space for new edges
#local naEV0=array[ncE]
#local naEV1=array[ncE]
#local naEF=array[ncE][2]
#local naES=array[ncE]

// make space for new faces
#local naFV=array[ncF][4]
#local naFE=array[ncF][4]
#local naFN=array[ncF][4]

// if there is uv-mapping defined, make space for it
#ifdef(sssaFM)
  #local naUM=array[ncF][4]
#end

// type old vertices
#local qaT=array[ssscV][2] // [][0]=valence,[][1]=sharp count
#local iI=0;#while(iI<ssscV)
  #local qaT[iI][0]=0;
  #local qaT[iI][1]=0;
#local iI=iI+1;#end

#local iI=0;#while(iI<ssscE)
  #local iA=sssaEV[iI][0];
  #local iB=sssaEV[iI][1];
  #local qaT[iA][0]=qaT[iA][0]+1;
  #local qaT[iB][0]=qaT[iB][0]+1;
  #if(sssaES[iI]!=0)
    #local qaT[iA][1]=qaT[iA][1]+1;
    #local qaT[iB][1]=qaT[iB][1]+1;
  #end
#local iI=iI+1;#end

// do some weighting
#local iI=0;#while(iI<ssscE)
  #local iA=sssaEV[iI][0];
  #local iB=sssaEV[iI][1];
  #local iN=ssscV+iI; // edge point
  #local iEN0=iI;
  #local iEN1=iI+ssscE;
  #local pA=sssaV[iA];
  #local pB=sssaV[iB];
// weight vertex points  
// if edge is sharp or vertex iA smooth or dart
  #if(sssaES[iI]!=0 | qaT[iA][1]<2)
    #local naVS[iA]=naVS[iA]+pB;
    #local naVW[iA]=naVW[iA]+1;
  #end
// if edge is sharp or vertex iB smooth or dart
  #if(sssaES[iI]!=0 | qaT[iB][1]<2)
    #local naVS[iB]=naVS[iB]+pA;
    #local naVW[iB]=naVW[iB]+1;
  #end
// weight edge points  
  #local naVS[iN]=naVS[iN]+(pA+pB)*3;
  #local naVW[iN]=naVW[iN]+6;
// build new edge data for edge splits
  #local naEV0[iEN0]=iA;
  #local naEV1[iEN0]=iN;
  #local naEV0[iEN1]=iB;
  #local naEV1[iEN1]=iN;
  #local naEF[iEN0][0]=-1;
  #local naEF[iEN0][1]=-1;
  #local naEF[iEN1][0]=-1;
  #local naEF[iEN1][1]=-1;
  #local iS=sssaES[iI];
  #local iS=iS-((iS>0)?1:0);
  #local naES[iEN0]=iS;
  #local naES[iEN1]=iS;
#local iI=iI+1;#end

#undef iI

#local iF4=0;
#local iF=0;#while(iF<ssscF)
  #local iV0=sssaFV[iF][0];
  #local iV1=sssaFV[iF][1];
  #local iV2=sssaFV[iF][2];
  #local iV3=sssaFV[iF][3];
  #local iE0=sssaFE[iF][0];
  #local iE1=sssaFE[iF][1];
  #local iE2=sssaFE[iF][2];
  #local iE3=sssaFE[iF][3];
  #local iEN0=ssscE*2+iF;
  #local iEN1=ssscE*2+ssscF+iF;
  #local iEN2=ssscE*2+ssscF*2+iF;
  #local iFN0=iF;
  #local iFN1=ssscF+iF;
  #local iFN2=ssscF*2+iF;
  #local iFN3=ssscF*3+iF;

  #local iN0=sssaFN[iF][0];
  #local iN1=sssaFN[iF][1];
  #local iN2=sssaFN[iF][2];
  #local iNN0=ssscN+iE0;
  #if(sssaES[iE0]!=0 & sssaEF[iE0][1]=iF)
    #local iNN0=ssscN+ssscE+qaES[iE0];
  #end
  #local iNN1=ssscN+iE1;
  #if(sssaES[iE1]!=0 & sssaEF[iE1][1]=iF)
    #local iNN1=ssscN+ssscE+qaES[iE1];
  #end
  #local iNN2=ssscN+iE2;
  #if(sssaES[iE2]!=0 & sssaEF[iE2][1]=iF)
    #local iNN2=ssscN+ssscE+qaES[iE2];
  #end
// see which edges match order of vertices
  #local fR0=((iV0=sssaEV[iE0][0])?0:1);
  #local fR1=((iV1=sssaEV[iE1][0])?0:1);
  #local fR2=((iV2=sssaEV[iE2][0])?0:1);
  #if(iV3=-1) // triangle behavior
// weight the smooth edge points  
    #if(sssaES[iE0]=0)
      #local naVS[ssscV+iE0]=naVS[ssscV+iE0]+sssaV[iV2];
      #local naVW[ssscV+iE0]=naVW[ssscV+iE0]+1;
    #end  
    #if(sssaES[iE1]=0)
      #local naVS[ssscV+iE1]=naVS[ssscV+iE1]+sssaV[iV0];
      #local naVW[ssscV+iE1]=naVW[ssscV+iE1]+1;
    #end  
    #if(sssaES[iE2]=0)
      #local naVS[ssscV+iE2]=naVS[ssscV+iE2]+sssaV[iV1];
      #local naVW[ssscV+iE2]=naVW[ssscV+iE2]+1;
    #end  
// build interior edges
    #local naEV0[iEN0]=ssscV+iE0;
    #local naEV1[iEN0]=ssscV+iE2;
    #local naEV0[iEN1]=ssscV+iE1;
    #local naEV1[iEN1]=ssscV+iE0;
    #local naEV0[iEN2]=ssscV+iE2;
    #local naEV1[iEN2]=ssscV+iE1;
    #local naEF[iEN0][0]=iFN0;
    #local naEF[iEN0][1]=iFN3;
    #local naEF[iEN1][0]=iFN1;
    #local naEF[iEN1][1]=iFN3;
    #local naEF[iEN2][0]=iFN2;
    #local naEF[iEN2][1]=iFN3;
    #local naES[iEN0]=0;
    #local naES[iEN1]=0;
    #local naES[iEN2]=0;
// adjust exterior edges and build face-edge array
    #local iEE=iE0+fR0*ssscE;
    #if(naEF[iEE][0]=-1) #local naEF[iEE][0]=iFN0; #else #local naEF[iEE][1]=iFN0; #end    
    #local naFE[iFN0][0]=iEE;

    #local iEE=iE0+(1-fR0)*ssscE;
    #if(naEF[iEE][0]=-1) #local naEF[iEE][0]=iFN1; #else #local naEF[iEE][1]=iFN1; #end    
    #local naFE[iFN1][2]=iEE;

    #local iEE=iE1+fR1*ssscE;
    #if(naEF[iEE][0]=-1) #local naEF[iEE][0]=iFN1; #else #local naEF[iEE][1]=iFN1; #end    
    #local naFE[iFN1][0]=iEE;

    #local iEE=iE1+(1-fR1)*ssscE;
    #if(naEF[iEE][0]=-1) #local naEF[iEE][0]=iFN2; #else #local naEF[iEE][1]=iFN2; #end    
    #local naFE[iFN2][2]=iEE;

    #local iEE=iE2+fR2*ssscE;
    #if(naEF[iEE][0]=-1) #local naEF[iEE][0]=iFN2; #else #local naEF[iEE][1]=iFN2; #end    
    #local naFE[iFN2][0]=iEE;

    #local iEE=iE2+(1-fR2)*ssscE;
    #if(naEF[iEE][0]=-1) #local naEF[iEE][0]=iFN0; #else #local naEF[iEE][1]=iFN0; #end    
    #local naFE[iFN0][2]=iEE;

// build new faces
    #local naFV[iFN0][0]=iV0; 
    #local naFV[iFN0][1]=iE0+ssscV; 
    #local naFV[iFN0][2]=iE2+ssscV; 
    #local naFV[iFN0][3]=-1; 
    #local naFE[iFN0][1]=iEN0;
    #local naFE[iFN0][3]=-1;
    #local naFN[iFN0][0]=iN0;
    #local naFN[iFN0][1]=iNN0;
    #local naFN[iFN0][2]=iNN2;
    #local naFN[iFN0][3]=-1;

    #local naFV[iFN1][0]=iV1; 
    #local naFV[iFN1][1]=iE1+ssscV; 
    #local naFV[iFN1][2]=iE0+ssscV; 
    #local naFV[iFN1][3]=-1; 
    #local naFE[iFN1][1]=iEN1;
    #local naFE[iFN1][3]=-1;
    #local naFN[iFN1][0]=iN1;
    #local naFN[iFN1][1]=iNN1;
    #local naFN[iFN1][2]=iNN0;
    #local naFN[iFN1][3]=-1;

    #local naFV[iFN2][0]=iV2; 
    #local naFV[iFN2][1]=iE2+ssscV; 
    #local naFV[iFN2][2]=iE1+ssscV; 
    #local naFV[iFN2][3]=-1; 
    #local naFE[iFN2][1]=iEN2;
    #local naFE[iFN2][3]=-1;
    #local naFN[iFN2][0]=iN2;
    #local naFN[iFN2][1]=iNN2;
    #local naFN[iFN2][2]=iNN1;
    #local naFN[iFN2][3]=-1;

    #local naFV[iFN3][0]=iE0+ssscV; 
    #local naFV[iFN3][1]=iE1+ssscV; 
    #local naFV[iFN3][2]=iE2+ssscV; 
    #local naFV[iFN3][3]=-1; 
    #local naFE[iFN3][0]=iEN1;
    #local naFE[iFN3][1]=iEN2;
    #local naFE[iFN3][2]=iEN0;
    #local naFE[iFN3][3]=-1;
    #local naFN[iFN3][0]=iNN0;
    #local naFN[iFN3][1]=iNN1;
    #local naFN[iFN3][2]=iNN2;
    #local naFN[iFN3][3]=-1;

    #ifdef(sssaFM)
      #local uvM01=(sssaFM[iF][0]+sssaFM[iF][1])/2;
      #local uvM12=(sssaFM[iF][1]+sssaFM[iF][2])/2;
      #local uvM02=(sssaFM[iF][0]+sssaFM[iF][2])/2;
      
      #local naUM[iFN0][0]=sssaFM[iF][0];
      #local naUM[iFN0][1]=uvM01;
      #local naUM[iFN0][2]=uvM02;
      #local naUM[iFN0][3]=<0,0>;
    
      #local naUM[iFN1][0]=sssaFM[iF][1];
      #local naUM[iFN1][1]=uvM12;
      #local naUM[iFN1][2]=uvM01;
      #local naUM[iFN1][3]=<0,0>;
    
      #local naUM[iFN2][0]=sssaFM[iF][2];
      #local naUM[iFN2][1]=uvM02;
      #local naUM[iFN2][2]=uvM12;
      #local naUM[iFN2][3]=<0,0>;
    
      #local naUM[iFN3][0]=uvM01;
      #local naUM[iFN3][1]=uvM12;
      #local naUM[iFN3][2]=uvM02;
      #local naUM[iFN3][3]=<0,0>;
    #end
  #else // quad behavior
// indices peculiar to quads
    #local iVM=ssscV+ssscE+iF4;
    #local iEN3=ssscE*2+ssscF*3+iF4;
    #local iN3=sssaFN[iF][3];
    #local iNN3=ssscN+iE3;
    #if(sssaES[iE3]!=0 & sssaEF[iE3][1]=iF)
      #local iNN3=ssscN+ssscE+qaES[iE3];
    #end
    #local iNNC=ssscN+ssscE+cES+iF4;

// get order of vertices on final edge
    #local fR3=((iV3=sssaEV[iE3][0])?0:1);
// add up face point
    #local naVS[iVM]=sssaV[iV0]+sssaV[iV1]+sssaV[iV2]+sssaV[iV3];
    #local naVW[iVM]=4;
// weight the smooth edge points  
    #if(sssaES[iE0]=0)
      #local naVS[ssscV+iE0]=naVS[ssscV+iE0]+(sssaV[iV2]+sssaV[iV3])/2;
      #local naVW[ssscV+iE0]=naVW[ssscV+iE0]+1;
    #end  
    #if(sssaES[iE1]=0)
      #local naVS[ssscV+iE1]=naVS[ssscV+iE1]+(sssaV[iV3]+sssaV[iV0])/2;
      #local naVW[ssscV+iE1]=naVW[ssscV+iE1]+1;
    #end  
    #if(sssaES[iE2]=0)
      #local naVS[ssscV+iE2]=naVS[ssscV+iE2]+(sssaV[iV0]+sssaV[iV1])/2;
      #local naVW[ssscV+iE2]=naVW[ssscV+iE2]+1;
    #end  
    #if(sssaES[iE3]=0)
      #local naVS[ssscV+iE3]=naVS[ssscV+iE3]+(sssaV[iV1]+sssaV[iV2])/2;
      #local naVW[ssscV+iE3]=naVW[ssscV+iE3]+1;
    #end  
// weight the corners where smooth or dart
  #if(qaT[iV0][1]<2)
    #local naVS[iV0]=naVS[iV0]+sssaV[iV2]*.5;
    #local naVW[iV0]=naVW[iV0]+.5;
  #end  
  #if(qaT[iV1][1]<2)
    #local naVS[iV1]=naVS[iV1]+sssaV[iV3]*.5;
    #local naVW[iV1]=naVW[iV1]+.5;
  #end  
  #if(qaT[iV2][1]<2)
    #local naVS[iV2]=naVS[iV2]+sssaV[iV0]*.5;
    #local naVW[iV2]=naVW[iV2]+.5;
  #end  
  #if(qaT[iV3][1]<2)
    #local naVS[iV3]=naVS[iV3]+sssaV[iV1]*.5;
    #local naVW[iV3]=naVW[iV3]+.5;
  #end  

// build interior edges
    #local naEV0[iEN0]=ssscV+iE0;
    #local naEV1[iEN0]=iVM;
    #local naEV0[iEN1]=ssscV+iE1;
    #local naEV1[iEN1]=iVM;
    #local naEV0[iEN2]=ssscV+iE2;
    #local naEV1[iEN2]=iVM;
    #local naEV0[iEN3]=ssscV+iE3;
    #local naEV1[iEN3]=iVM;
    #local naEF[iEN0][0]=iFN0;
    #local naEF[iEN0][1]=iFN1;
    #local naEF[iEN1][0]=iFN1;
    #local naEF[iEN1][1]=iFN2;
    #local naEF[iEN2][0]=iFN2;
    #local naEF[iEN2][1]=iFN3;
    #local naEF[iEN3][0]=iFN3;
    #local naEF[iEN3][1]=iFN0;
    #local naES[iEN0]=0;
    #local naES[iEN1]=0;
    #local naES[iEN2]=0;
    #local naES[iEN3]=0;

// build new faces
// adjust exterior edges and build face-edge array
    #local iEE=iE0+fR0*ssscE;
    #if(naEF[iEE][0]=-1) #local naEF[iEE][0]=iFN0; #else #local naEF[iEE][1]=iFN0; #end    
    #local naFE[iFN0][0]=iEE;

    #local iEE=iE0+(1-fR0)*ssscE;
    #if(naEF[iEE][0]=-1) #local naEF[iEE][0]=iFN1; #else #local naEF[iEE][1]=iFN1; #end    
    #local naFE[iFN1][3]=iEE;

    #local iEE=iE1+fR1*ssscE;
    #if(naEF[iEE][0]=-1) #local naEF[iEE][0]=iFN1; #else #local naEF[iEE][1]=iFN1; #end    
    #local naFE[iFN1][0]=iEE;

    #local iEE=iE1+(1-fR1)*ssscE;
    #if(naEF[iEE][0]=-1) #local naEF[iEE][0]=iFN2; #else #local naEF[iEE][1]=iFN2; #end    
    #local naFE[iFN2][3]=iEE;

    #local iEE=iE2+fR2*ssscE;
    #if(naEF[iEE][0]=-1) #local naEF[iEE][0]=iFN2; #else #local naEF[iEE][1]=iFN2; #end    
    #local naFE[iFN2][0]=iEE;

    #local iEE=iE2+(1-fR2)*ssscE;
    #if(naEF[iEE][0]=-1) #local naEF[iEE][0]=iFN3; #else #local naEF[iEE][1]=iFN3; #end    
    #local naFE[iFN3][3]=iEE;

    #local iEE=iE3+fR3*ssscE;
    #if(naEF[iEE][0]=-1) #local naEF[iEE][0]=iFN3; #else #local naEF[iEE][1]=iFN3; #end    
    #local naFE[iFN3][0]=iEE;

    #local iEE=iE3+(1-fR3)*ssscE;
    #if(naEF[iEE][0]=-1) #local naEF[iEE][0]=iFN0; #else #local naEF[iEE][1]=iFN0; #end    
    #local naFE[iFN0][3]=iEE;

// build new faces
    #local naFV[iFN0][0]=iV0; 
    #local naFV[iFN0][1]=iE0+ssscV; 
    #local naFV[iFN0][2]=iVM; 
    #local naFV[iFN0][3]=iE3+ssscV; 
    #local naFE[iFN0][1]=iEN0;
    #local naFE[iFN0][2]=iEN3;
    #local naFN[iFN0][0]=iN0;
    #local naFN[iFN0][1]=iNN0;
    #local naFN[iFN0][2]=iNNC;
    #local naFN[iFN0][3]=iNN3;

    #local naFV[iFN1][0]=iV1; 
    #local naFV[iFN1][1]=iE1+ssscV; 
    #local naFV[iFN1][2]=iVM; 
    #local naFV[iFN1][3]=iE0+ssscV; 
    #local naFE[iFN1][1]=iEN1;
    #local naFE[iFN1][2]=iEN0;
    #local naFN[iFN1][0]=iN1;
    #local naFN[iFN1][1]=iNN1;
    #local naFN[iFN1][2]=iNNC;
    #local naFN[iFN1][3]=iNN0;

    #local naFV[iFN2][0]=iV2; 
    #local naFV[iFN2][1]=iE2+ssscV; 
    #local naFV[iFN2][2]=iVM; 
    #local naFV[iFN2][3]=iE1+ssscV; 
    #local naFE[iFN2][1]=iEN2;
    #local naFE[iFN2][2]=iEN1;
    #local naFN[iFN2][0]=iN2;
    #local naFN[iFN2][1]=iNN2;
    #local naFN[iFN2][2]=iNNC;
    #local naFN[iFN2][3]=iNN1;

    #local naFV[iFN3][0]=iV3; 
    #local naFV[iFN3][1]=iE3+ssscV; 
    #local naFV[iFN3][2]=iVM; 
    #local naFV[iFN3][3]=iE2+ssscV; 
    #local naFE[iFN3][1]=iEN3;
    #local naFE[iFN3][2]=iEN2;
    #local naFN[iFN3][0]=iN3;
    #local naFN[iFN3][1]=iNN3;
    #local naFN[iFN3][2]=iNNC;
    #local naFN[iFN3][3]=iNN2;

    // uv-mapping
    #ifdef(sssaFM)
      #local uvM01=(sssaFM[iF][0]+sssaFM[iF][1])/2;
      #local uvM12=(sssaFM[iF][1]+sssaFM[iF][2])/2;
      #local uvM23=(sssaFM[iF][2]+sssaFM[iF][3])/2;
      #local uvM03=(sssaFM[iF][0]+sssaFM[iF][3])/2;
      #local uvM4=(uvM01+uvM23)/2;
      
      #local naUM[iFN0][0]=sssaFM[iF][0];
      #local naUM[iFN0][1]=uvM01;
      #local naUM[iFN0][2]=uvM4;
      #local naUM[iFN0][3]=uvM03;
    
      #local naUM[iFN1][0]=sssaFM[iF][1];
      #local naUM[iFN1][1]=uvM12;
      #local naUM[iFN1][2]=uvM4;
      #local naUM[iFN1][3]=uvM01;
    
      #local naUM[iFN2][0]=sssaFM[iF][2];
      #local naUM[iFN2][1]=uvM23;
      #local naUM[iFN2][2]=uvM4;
      #local naUM[iFN2][3]=uvM12;
    
      #local naUM[iFN3][0]=sssaFM[iF][3];
      #local naUM[iFN3][1]=uvM03;
      #local naUM[iFN3][2]=uvM4;
      #local naUM[iFN3][3]=uvM23;
    #end

// done dividing quad
// update number of four-siders encountered
    #local iF4=iF4+1;
  #end
#local iF=iF+1;#end

#undef qaES

// do 
#local iI=0;#while(iI<ssscV)
  #switch(qaT[iI][1]) // by sharps
    #case(0) #case(1) // smooth or dart
      #local sN=naVW[iI];
      #local sA=cos(2*pi/sN);
      #local sA=5/8-(sA/4+3/8)*(sA/4+3/8);
      #local sW=sN*(1-sA)/sA;
      #local naVS[iI]=naVS[iI]+sssaV[iI]*sW;
      #local naVW[iI]=naVW[iI]+sW;
    #break
    #case(2)
      #local naVS[iI]=naVS[iI]+sssaV[iI]*6;
      #local naVW[iI]=naVW[iI]+6;
    #break
  #else
    #local naVS[iI]=sssaV[iI];
    #local naVW[iI]=1;
  #end
#local iI=iI+1;#end
  
// build new vertex array
#undef sssaV
#declare sssaV=array[ncV]
#local iI=0;#while(iI<ncV)
  #declare sssaV[iI]=naVS[iI]/naVW[iI];
#local iI=iI+1;#end
#declare ssscV=ncV;
#undef naVW
#undef naVS
#undef qaT

// build new edge array
#undef sssaEV
#undef sssaEF
#undef sssaES
#declare sssaEV=array[ncE][2]
#declare sssaEF=array[ncE][2]
#declare sssaES=array[ncE]
#local iI=0;#while(iI<ncE)
  #declare sssaEV[iI][0]=naEV0[iI];
  #declare sssaEV[iI][1]=naEV1[iI];
  #declare sssaEF[iI][0]=naEF[iI][0];
  #declare sssaEF[iI][1]=naEF[iI][1];
  #declare sssaES[iI]=naES[iI];
#local iI=iI+1;#end
#declare ssscE=ncE;
#undef naEF
#undef naEV0
#undef naEV1
#undef naES

// build new face array
#undef sssaFV
#undef sssaFE
#undef sssaFN
#declare sssaFE=array[ncF][4]
#declare sssaFV=array[ncF][4]
#declare sssaFN=array[ncF][4]
#local iI=0;#while(iI<ncF)
  #declare sssaFV[iI][0]=naFV[iI][0];
  #declare sssaFV[iI][1]=naFV[iI][1];
  #declare sssaFV[iI][2]=naFV[iI][2];
  #declare sssaFV[iI][3]=naFV[iI][3];
  #declare sssaFE[iI][0]=naFE[iI][0];
  #declare sssaFE[iI][1]=naFE[iI][1];
  #declare sssaFE[iI][2]=naFE[iI][2];
  #declare sssaFE[iI][3]=naFE[iI][3];
  #declare sssaFN[iI][0]=naFN[iI][0];
  #declare sssaFN[iI][1]=naFN[iI][1];
  #declare sssaFN[iI][2]=naFN[iI][2];
  #declare sssaFN[iI][3]=naFN[iI][3];
#local iI=iI+1;#end
#undef naFE
#undef naFV
#undef naFN

// if individual texturing defined
#ifdef(sssaFT)
  #local qiT=array[ncF];
  #local iF=0;#while(iF<ssscF)
    #local qiT[iF]=sssaFT[iF];
    #local qiT[iF+ssscF]=sssaFT[iF];
    #local qiT[iF+ssscF*2]=sssaFT[iF];
    #local qiT[iF+ssscF*3]=sssaFT[iF];
  #local iF=iF+1;#end

  #undef sssaFT
  #declare sssaFT=array[ncF]
  #local iF=0;#while(iF<ncF)
    #declare sssaFT[iF]=qiT[iF];
  #local iF=iF+1;#end
  #undef qiT
#end

#ifdef(sssaFM) // if uv-mapping defined

  #undef sssaFM
  #declare sssaFM=array[ncF][4]

  #local qaM=array[ncF][4]
    #local iF=0;#while(iF<ncF)
      #declare sssaFM[iF][0]=naUM[iF][0];
      #declare sssaFM[iF][1]=naUM[iF][1];
      #declare sssaFM[iF][2]=naUM[iF][2];
      #declare sssaFM[iF][3]=naUM[iF][3];
    #local iF=iF+1;#end
  #undef naUM
#end // end of that

#declare ssscF=ncF;
#declare ssscN=ncN;
#while(defined(sssaN)) #undef sssaN #end
#end // done with macro
  