#macro SSS_BuildFlatMesh()
  mesh {
  #local iI=0;#while(iI<ssscF)
    #local iA=sssaFV[iI][0];
    #local iB=sssaFV[iI][1];
    #local iC=sssaFV[iI][2];
    #local iD=sssaFV[iI][3];
    #if(iD=-1)
      triangle { sssaV[iA],sssaV[iB],sssaV[iC] }
    #else
      #local vN=vnormalize(vcross(sssaV[iC]-sssaV[iA],sssaV[iD]-sssaV[iB]));
      smooth_triangle { sssaV[iA],nV,sssaV[iB],nV,sssaV[iC]nV+.001 }
      smooth_triangle { sssaV[iA],nV,sssaV[iC],nV+.001,sssaV[iD]nV+.001 }
    #end
  #local iI=iI+1;#end
  }
#end

#macro SSS_BuildSmoothMesh()
  #ifndef(sssaFN) SSS_BuildNormals() #end
  #ifndef(sssaN) SSS_CalculateNormals() #end
  mesh {
  #local iI=0;#while(iI<ssscF)
    #local iA=sssaFV[iI][0];
    #local iB=sssaFV[iI][1];
    #local iC=sssaFV[iI][2];
    #local iD=sssaFV[iI][3];
    #local iNA=sssaFN[iI][0];
    #local iNB=sssaFN[iI][1];
    #local iNC=sssaFN[iI][2];
    #if(sssaFV[iI][3]=-1) // three-sider
      smooth_triangle { sssaV[iA],sssaN[iNA],sssaV[iB],sssaN[iNB],sssaV[iC],sssaN[iNC]
#ifdef(sssaFM)
        uv_mapping sssaFM[iI][0],sssaFM[iI][1],sssaFM[iI][2]
#end        
      }
    #else // four-sider
    #local iND=sssaFN[iI][3];
      smooth_triangle { sssaV[iA],sssaN[iNA],sssaV[iB],sssaN[iNB],sssaV[iC],sssaN[iNC] }
      smooth_triangle { sssaV[iA],sssaN[iNA],sssaV[iC],sssaN[iNC],sssaV[iD],sssaN[iND] }
    #end

  #local iI=iI+1;#end
  }
#end

#macro SSS_BuildTexturedSmoothMesh(aText)
  #ifndef(sssaFN) SSS_BuildNormals() #end
  #ifndef(sssaN) SSS_CalculateNormals() #end
  mesh {
  #local iI=0;#while(iI<ssscF)
    #local iA=sssaFV[iI][0];
    #local iB=sssaFV[iI][1];
    #local iC=sssaFV[iI][2];
    #local iD=sssaFV[iI][3];
    #local iNA=sssaFN[iI][0];
    #local iNB=sssaFN[iI][1];
    #local iNC=sssaFN[iI][2];
    #local iT=sssaFT[iI];
    #if(iD=-1) // three-sider
      smooth_triangle { sssaV[iA],sssaN[iNA],sssaV[iB],sssaN[iNB],sssaV[iC],sssaN[iNC]
#ifdef(sssaFM)
        uv_vectors sssaFM[iI][0],sssaFM[iI][1],sssaFM[iI][2]
#end        
      #if(iT>-1 & iT<dimension_size(aText,1))
        texture { aText[iT] }
      #end
      }
    #else // four-sider
    #local iND=sssaFN[iI][3];
      smooth_triangle { sssaV[iA],sssaN[iNA],sssaV[iB],sssaN[iNB],sssaV[iC],sssaN[iNC]
#ifdef(sssaFM)
        uv_vectors sssaFM[iI][0],sssaFM[iI][1],sssaFM[iI][2]
#end        
      #if(iT>-1 & iT<dimension_size(aText,1))
        texture { aText[iT] }
      #end
      }
      smooth_triangle { sssaV[iA],sssaN[iNA],sssaV[iC],sssaN[iNC],sssaV[iD],sssaN[iND]
#ifdef(sssaFM)
        uv_vectors sssaFM[iI][0],sssaFM[iI][2],sssaFM[iI][3]
#end        
      #if(iT>-1 & iT<dimension_size(aText,1))
        texture { aText[iT] }
      #end
      }
    #end
  #local iI=iI+1;#end
  }
#end

#macro SSS_BuildTexturedFlatMesh(aText)
  mesh {
  #local iI=0;#while(iI<ssscF)
    #local iA=sssaFV[iI][0];
    #local iB=sssaFV[iI][1];
    #local iC=sssaFV[iI][2];
    #local iD=sssaFV[iI][3];
    #local iT=sssaFT[iI];
    #if(iD=-1) // three-sider
      triangle { sssaV[iA],sssaV[iB],sssaV[iC]
#ifdef(sssaFM)
        uv_vectors sssaFM[iI][0],sssaFM[iI][1],sssaFM[iI][2]
#end        
      #if(iT>-1 & iT<dimension_size(aText,1))
        texture { aText[iT] }
      #end
      }
    #else // four-sider
    #local vN=vnormalize(vcross(sssaV[iC]-sssaV[iA],sssaV[iD]-sssaV[iB]));
    smooth_triangle { sssaV[iA],vN+.001,sssaV[iB],vN+.001,sssaV[iC],vN
#ifdef(sssaFM)
        uv_vectors sssaFM[iI][0],sssaFM[iI][1],sssaFM[iI][2]
#end        
      #if(iT>-1 & iT<dimension_size(aText,1))
        texture { aText[iT] }
      #end
      }
    smooth_triangle { sssaV[iA],vN+.001,sssaV[iC],vN,sssaV[iD],vN
#ifdef(sssaFM)
        uv_vectors sssaFM[iI][0],sssaFM[iI][2],sssaFM[iI][3]
#end        
      #if(iT>-1 & iT<dimension_size(aText,1))
        texture { aText[iT] }
      #end
      }
    #end
  #local iI=iI+1;#end
  }
#end


#macro SSS_BuildFrame(rR,iP)
  #ifndef(sssaES) SSS_DefaultSharpData() #end
  #local iI=0;#while(iI<ssscE)
    #local iA=sssaEV[iI][0];
    #local iB=sssaEV[iI][1];
    cylinder { sssaV[iA],sssaV[iB],rR
      #if(iI=iP) pigment { rgb <.75,0,.75> }
      #else
        #if(sssaES[iI]) pigment { rgb <.75,.65,.7> } #end
      #end
    }
  #local iI=iI+1;#end
  #local iI=0;#while(iI<ssscV)
    sphere { sssaV[iI],rR }
  #local iI=iI+1;#end
#end

#macro SSS_DumpData()
  #debug "Faces:\n"
  #local iI=0;#while(iI<ssscF)
    #debug concat(
      str(iI,3,0)," V:",
      str(sssaFV[iI][0],0,0),",",
      str(sssaFV[iI][1],0,0),",",
      str(sssaFV[iI][2],0,0),",",
      str(sssaFV[iI][3],0,0)," E: ",
      str(sssaFE[iI][0],0,0),",",
      str(sssaFE[iI][1],0,0),",",
      str(sssaFE[iI][2],0,0),",",
      str(sssaFE[iI][3],0,0),"\n"
    )
  #local iI=iI+1;#end
  #debug "Edges:\n"
  #local iI=0;#while(iI<ssscE)
    #debug concat(
      str(iI,3,0),":",
      str(sssaEV[iI][0],0,0),",",
      str(sssaEV[iI][1],0,0),"\n"
    )
  #local iI=iI+1;#end
#end

#macro SSS_ColorVerts(rR,iP)
  #local iI=0;#while(iI<ssscV)
    sphere { sssaV[iI],rR pigment { rgb ((iP=iI)?1:.5) } }
  #local iI=iI+1;#end
#end

#macro SSS_Porcupine(rR,iF)
  #if (sssfO=false) SSS_OrientFaces #end
  #local iI=0;#while(iI<ssscF)
    #local iA=sssaFV[iI][0];
    #local iB=sssaFV[iI][1];
    #local iC=sssaFV[iI][2];
    #local iD=sssaFV[iI][3];
    #local pA=sssaV[iA];
    #local pB=sssaV[iB];
    #local pC=sssaV[iC];
    #if(sssaFV[iI][3]=-1) // three-sider
      cone { (pA+pB+pC)/3,rR,(pA+pB+pC)/3+vnormalize(vcross((pB-pA),(pC-pA))),0
        #if (iF=iI) pigment { rgb .75 } #end
      }
    #else // four-sider
      #local pD=sssaV[iD];
      cone { (pA+pB+pC+pD)/4,rR,(pA+pB+pC+pD)/4+vnormalize(vcross((pC-pA),(pD-pB))),0
        #if (iF=iI) pigment { rgb .75 } #end
      }
    #end
  #local iI=iI+1;#end
#end
      