//.pov file used to make db.png

#declare t_wire=texture {T_Brass_4A}
#declare wirerad=0.0015;

#declare corksurface=box {<-1, 0, -1>, <1, 0.011, 1>}

#declare innerwedge=
intersection {
	difference {
		cylinder {0, y, 0.32}
		cylinder {y*-1, y, 0.04}
		object {Wedge(18) inverse}
	}
	object {corksurface}
}

#declare innerring=
intersection {
	difference {
		cylinder {0, y, 0.36}
		cylinder {y*-1, y, 0.32}
		object {Wedge(18) inverse}
	}
	object {corksurface}
}

#declare outerwedge=
intersection {
	difference {
		cylinder {0, y, 0.46}
		cylinder {y*-1, y, 0.36}
		object {Wedge(18) inverse}
	}
	object {corksurface}
}

#declare outerring=
intersection {
	difference {
		cylinder {0, y, 0.50}
		cylinder {y*-1, y, 0.46}
		object {Wedge(18) inverse}
	}
	object {corksurface}
}

#declare f_cork=
finish {
	specular 0.05
	roughness 0.6
}

#declare n_cork=normal {granite 0.3 scale 0.015 poly_wave 2}

#declare t_blackcork=
texture {
	pigment {rgb 0.15}
	finish {f_cork}
	normal {n_cork}
}
#declare t_redcork=
texture {
	pigment {red 1}
	finish {f_cork}
	normal {n_cork}
}
#declare t_tancork=
texture {
	pigment {rgb <0.8, 0.75, 0.6>}
	finish {f_cork}
	normal {n_cork}
}
#declare t_greencork=
texture {
	pigment {rgb <0, 1, 0>}
	finish {f_cork}
	normal {n_cork}
}

#declare dartboard=
union {
	// inner bullseye
	intersection {
		cylinder {0, y, 0.02}
		object {corksurface}
		texture {t_blackcork}
	}
	
	//outer bullseye
	intersection {
		difference {
			cylinder {0, y, 0.04}
			cylinder {y*-1, y, 0.02}
		}
		object {corksurface}
		texture {t_redcork}
	}
	
	//inner wedges
	#local c=0;
	#while (c<20)
		object {
			innerwedge
			#if (odd(c))
				texture {t_tancork}
			#else
				texture {t_blackcork}
			#end
			rotate y*c*18
		}
		#local c=c+1;
	#end
	
	//inner ring
	#local c=0;
	#while (c<20)
		object {
			innerring
			#if (odd(c))
				texture {t_greencork}
			#else
				texture {t_redcork}
			#end
			rotate y*c*18
		}
		#local c=c+1;
	#end
	
	//outer wedges
	#local c=0;
	#while (c<20)
		object {
			outerwedge
			#if (odd(c))
				texture {t_tancork}
			#else
				texture {t_blackcork}
			#end
			rotate y*c*18
		}
		#local c=c+1;
	#end
	
	//outer ring
	#local c=0;
	#while (c<20)
		object {
			outerring
			#if (odd(c))
				texture {t_greencork}
			#else
				texture {t_redcork}
			#end
			rotate y*c*18
		}
		#local c=c+1;
	#end
	
	//rim
	intersection {
		difference {
			cylinder {0, y, 0.6}
			cylinder {y*-1, y, 0.5}
		}
		object {corksurface}
		texture {t_blackcork}
	}

	// wires
	union {
		torus {0.02, wirerad translate y*0.011}
		torus {wirerad*2, wirerad rotate x*90 translate <-0.02, 0.011, 0>}
		torus {wirerad*2, wirerad rotate x*90 translate <0.02, 0.011, 0>}
		torus {0.04, wirerad translate y*0.011}
		torus {0.32, wirerad translate y*0.011}
		torus {0.36, wirerad translate y*0.011}
		torus {0.46, wirerad translate y*0.011}
		torus {0.5, wirerad translate y*0.011}
		#local c=0;
		#while (c<360)
			torus {wirerad*2, wirerad rotate x*90 translate <-0.04, 0.011, 0> rotate y*c}
			torus {wirerad*2, wirerad rotate x*90 translate <-0.32, 0.011, 0> rotate y*c}
			torus {wirerad*2, wirerad rotate x*90 translate <-0.36, 0.011, 0> rotate y*c}
			torus {wirerad*2, wirerad rotate x*90 translate <-0.46, 0.011, 0> rotate y*c}
			torus {wirerad*2, wirerad rotate x*90 translate <-0.5, 0.011, 0> rotate y*c}
			torus {wirerad*2, wirerad rotate z*90 translate <-0.28, 0.011, 0> rotate y*c}
			torus {wirerad*2, wirerad rotate z*90 translate <-0.42, 0.011, 0> rotate y*c}
			
			cylinder {<wirerad*2-0.32, 0.011, 0>, <wirerad*2-0.04, 0.011, 0>, wirerad rotate y*c}
			cylinder {<-wirerad*2-0.32, 0.011, 0>, <wirerad*2-0.36, 0.011, 0>, wirerad rotate y*c}
			cylinder {<-wirerad*2-0.36, 0.011, 0>, <wirerad*2-0.46, 0.011, 0>, wirerad rotate y*c}
			cylinder {<-wirerad*2-0.46, 0.011, 0>, <wirerad*2-0.5, 0.011, 0>, wirerad rotate y*c}
			#local c=c+18;
		#end
		texture {t_wire}
	}
	
	union {
		difference {
			cylinder {y*-0.05, y*0.015, 0.605}
			cylinder {0, y, 0.6}
		}
		torus {0.6025, 0.005 translate y*0.015}
		texture {t_wire}
	}
	translate y*0.05
}

object {dartboard}