// Persistence of Vision Ray Tracer Scene Description File
// File: dart.pov
// Vers: 3.5
// Desc:
// Date:
// Auth: J Moore
//--------------------------------------------------------
//--------------------------------------------------------

#include "rad_def.inc"
#include "colors.inc"
#include "stones.inc"
#include "metals.inc"
#include "shapes.inc"

#declare hq=no;
global_settings {
	radiosity {Rad_Settings(Radiosity_IndoorLQ, on, on)}
	//max_trace_level 25
}

//--------------------------------------------------------

camera {
	up y
	right image_width/image_height*x
	angle 10
	location <-3, -0.5, -1.5>
	look_at z*-0.15
	aperture 0.08 blur_samples 25 focal_point y*0.12
	rotate x*-15
}

//--------------------------------------------------------

light_source {<-6, 4, -4> rgb 1.5
	area_light <1, 0, 0>, <0, 0, 1>, 10, 10
}

//--------------------------------------------------------
// dart

#declare n_gran=normal {granite scale 0.2}
#declare n_box=
normal {
	boxed poly_wave 0.3
	warp {repeat x}
	warp {repeat y}
	warp {repeat z}
}

#declare t_tip=texture {T_Chrome_4E}
#declare t_shaft=texture {T_Chrome_4E}

#declare m_grip=
material {
	texture {
		pigment {rgb <0.25, 0.25, 1>}
		finish {
 			ambient 0.25
		    brilliance 4
    		diffuse 0.5
	    	metallic
	    	specular 0.80
		    roughness 1/80
    		reflection 0.5
	    	irid {0.35 thickness 30 turbulence 0.1}
		}
		normal {
			average
			normal_map {
				[1 gradient y bump_size 0.3 poly_wave 0.3 frequency 5 scale 0.05 rotate x*30]
				[1 gradient y bump_size 0.3 poly_wave 0.3 frequency 5 scale 0.05 rotate x*-30]
			}
		}
	}
	interior {ior 1.4 dispersion 2.5}
}

#declare m_flight=
material {
	texture {
		//pigment {rgb <0.25, 0.25, 1>}
		pigment {
			planar
			scale 8
			rotate x*45
			color_map {
				[0 rgb <0.25, 0.25, 1>]
				[0.15 rgb <0.25, 0.25, 1>]
				[0.2 rgb 1]
				[0.35 rgb 1]
				[0.4 rgb <0.25, 0.25, 1>]
				[0.55 rgb <0.25, 0.25, 1>]
				[0.6 rgb 1]
				[0.75 rgb 1]
				[0.8 rgb <0.25, 0.25, 1>]
			}
		}
		normal {
			average
			normal_map {
				[1 n_box]
				[0.1 n_gran]
			}
		}
		finish {
			specular 0.5
			roughness 0.01
			reflection {0.1, 0.3 fresnel}
			conserve_energy
			irid {0.35 thickness 30 turbulence 0.1}
		}
		scale 0.006
	}
	interior {ior 1.4 dispersion 2.5}
}

#declare dart=
union {
	//tip
	lathe {
		quadratic_spline
		5
		<0.0001, 0.02>
		<0.0001, 0.021>
		<0.0011, 0.03>
		<0.002, 0.05>
		<0.005, 0.08>
		
		
		sturm
		texture {t_tip}
	}
	//grip
	superellipsoid {<1, 0.2>
		rotate x*90
		scale <0.0072, 0.068, 0.0072>
		translate y*0.15
		material {m_grip}
	}
	//shaft
	union {
		cylinder {<0, 0.079, 0>, <0, 0.219, 0>, 0.005}
		cone {<0, 0.219, 0>, 0.005, <0, 0.245, 0>, 0.003}
		cylinder {<0, 0.245, 0>, <0, 0.3, 0>, 0.003}
		cone {<0, 0.3, 0>, 0.003, <0, 0.32, 0>, 0.002}
		texture {t_shaft}
	}
	//flight
	#local flct=
	union {
		cone {0, 0, y*0.06, 0.06}
		cylinder {y*0.06, y*0.08, 0.06}
		cone {y*0.08, 0.06, y*0.1, 0}
	}
	#local flsec=
	intersection {
		box {<-0.0001, 0, -0.035>, <0.0001, 0.1, 0>}
		object {flct}
		material {m_flight}
	}
	union {
		object {flsec}
		object {flsec rotate y*90}
		object {flsec rotate y*180}
		object {flsec rotate y*270}
		translate y*0.3
	}
	translate y*-0.02
}

//--------------------------------------------------------
// dartboard

#declare dartboard=
union {
	// wires
	union {
		torus {0.02, 0.0015 translate y*0.015}
		torus {0.003, 0.0015 rotate x*90 translate <-0.02, 0.015, 0>}
		torus {0.003, 0.0015 rotate x*90 translate <0.02, 0.015, 0>}
		torus {0.04, 0.0015 translate y*0.015}
		torus {0.32, 0.0015 translate y*0.015}
		torus {0.36, 0.0015 translate y*0.015}
		torus {0.46, 0.0015 translate y*0.015}
		torus {0.5, 0.0015 translate y*0.015}
		#local c=0;
		#while (c<360)
			torus {0.003, 0.0015 rotate x*90 translate <-0.04, 0.015, 0> rotate y*c}
			torus {0.003, 0.0015 rotate x*90 translate <-0.32, 0.015, 0> rotate y*c}
			torus {0.003, 0.0015 rotate x*90 translate <-0.36, 0.015, 0> rotate y*c}
			torus {0.003, 0.0015 rotate x*90 translate <-0.46, 0.015, 0> rotate y*c}
			torus {0.003, 0.0015 rotate x*90 translate <-0.5, 0.015, 0> rotate y*c}
			torus {0.003, 0.0015 rotate z*90 translate <-0.28, 0.015, 0> rotate y*c}
			torus {0.003, 0.0015 rotate z*90 translate <-0.42, 0.015, 0> rotate y*c}
			
			cylinder {<-0.317, 0.015, 0>, <-0.037, 0.015, 0>, 0.0015 rotate y*c}
			cylinder {<-0.323, 0.015, 0>, <-0.357, 0.015, 0>, 0.0015 rotate y*c}
			cylinder {<-0.363, 0.015, 0>, <-0.457, 0.015, 0>, 0.0015 rotate y*c}
			cylinder {<-0.463, 0.015, 0>, <-0.497, 0.015, 0>, 0.0015 rotate y*c}
			#local c=c+18;
		#end
		difference {
			cylinder {y*-0.03, y*0.015, 0.605}
			cylinder {y*-1, y, 0.6}
		}
		torus {0.6025, 0.005 translate y*0.015}
		rotate y*9
		texture {T_Brass_4A}
	}
	cylinder {y*-0.03, y*0.015, 0.6
		texture {
			pigment {
				image_map {png "temp.png" interpolate 2 map_type 0 once}
				rotate x*90 translate <-0.5, 0, -0.5> scale 1.2
			}
			normal {
				average
				normal_map {
					[1 granite 0.3 scale 0.015 poly_wave 2]
					[1 dents 0.3 scale 0.015 poly_wave 2]
				}
			}
			finish {specular 0.05 roughness 0.6}
		}
		texture {T_Crack2 scale 0.1}
	}
}

//---------------------------------------------------------------
//---------------------------------------------------------------

union {
	union {
		object {dartboard rotate y*90}
		//object {dart rotate x*10 translate z*0.0015 rotate y*-30}
		//object {dart rotate y*35 rotate x*12 translate z*0.002 rotate y*90}
		//object {dart rotate y*-15 rotate x*25 translate z*0.003 rotate y*210}
		object {dart rotate y*75 rotate x*10 translate <0, 0.001, 0.0015> rotate y*-30}
		object {dart rotate y*35 rotate x*15 translate <0, 0.001, 0.0015> rotate y*-120}
		object {dart rotate y*-20 rotate x*8 translate <0, 0.001, 0.0015> rotate y*50}
		rotate y*-90
		rotate x*-90
	}
	plane {z, 0.03
		texture {
			T_Stone5
			normal {bumps scale <0.8, 0.05, 0.1> turbulence 0.1 sine_wave rotate y*30}
			finish {specular 0.8 roughness 0.005 reflection 0.3}
			rotate y*30
			scale 0.2
		}
	}
}

