// Persistence of Vision Ray Tracer Scene Description File
// File: atalanta.pov
// Vers: 3.5
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3.5;

#include "colors.inc"

global_settings {
  assumed_gamma 1.0
}

// ----------------------------------------

camera {
  location  <0.0, 0.5, -1.5>
  direction 1.5*z
  right     x*image_width/image_height
  look_at   <0.0, 0.0,  0.0>
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.7 rgb <0.0,0.1,0.8>]
    }
  }
}

light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 1>  // light's color
  translate <-30, 30, -30>
}

light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 1>*.5  // light's color
  translate <30, 30, -30>
}

// ----------------------------------------

plane {
  y, -1
  pigment { color rgb <0.7,0.9,0.3> }
}

#include "Atalanta.inc"

object{Atalanta(clock)  
   texture {
      uv_mapping pigment {
        image_map {
          jpeg "atalanta.jpg"
          map_type 0
          interpolate 0
        }
      }  
    }        
  rotate x*60
  translate <-450,-250,0>                
  scale <-1,-1,-1>/800
  translate <.1,-.15,.1>  
  rotate y*30
}

