// hf (right) is okay, iso-surface using pigment function (left) is shite


#version 3.5;

#include "colors.inc"

global_settings {
  assumed_gamma 1.0
}

// ----------------------------------------

camera {
  location  <0.0, 1.0, -2.0>
  look_at   <0.0, 0.5,  0.0>
}

light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 1>  // light's color
  translate <-30, 30, -30>
}

// ----------------------------------------

height_field {
  tga
  "mount1.tga"
  pigment{Gray}
  translate x*-1.25
}

#declare F_Img = function{
  pigment{
    image_map{
      tga "mount1.tga"
      map_type 0
      interpolate 2
      once
    }
    rotate x*90
  }
}

#declare F_Test = function(x,y,z){
  y - (F_Img(x,0,z).gray/5)
}

isosurface {
  function { F_Test(x,y,z)}
  contained_by {box{0,<1,2,1>}}
  accuracy 0.001
  max_gradient 10
  scale 1
  texture{pigment{Gray}}
  translate x*0.25
}
