#ifndef(floor_level)
    #declare floor_level = 1;
#end
#ifndef(camera_angle)
    #declare camera_angle = 25;
#end
#ifndef(camera_target)
    #declare camera_target = 0;
#end

global_settings
{
#ifdef(use_radiosity)
    #if(use_radiosity)
            radiosity { brightness 1.0 } // Just use the defaults    
    #end
#end

#ifdef(use_photons)
    #if(use_photons)
            photons
            {
                spacing 0.01
                media 100
            }
    #end
#end
}
    

camera
{
    #ifdef(camera_location)
        location camera_location
    #else
        location <0, 0, -10>
    #end
    
    right image_width/image_height*x
    
    angle camera_angle
    
    look_at camera_target   
    
}

#declare plane_trans = 0.0;

#ifdef(semitrans_plane)
    #if(semitrans_plane)
        #declare plane_trans = 0.5;
    #end
#end

// The floor 
plane { y, -floor_level
    
        pigment {   // Gray/White checkered floor
            checker color rgb 0.3 transmit plane_trans color rgb 1.0 transmit plane_trans
        }
        
        finish {
            diffuse 0.8
            brilliance 0.5
        }
        
        #ifdef(advanced_studio)
            #if(advanced_studio)
            
            finish {
                reflection 0.22
                brilliance 1.0
                diffuse 0.6
                specular 0.9
                roughness 0.001
            }
            
            normal
            {
                crackle 0.5 form <-1, 1, 0> turbulence 0.5 scale 0.1    
            }
            
            #end
        #end
        
}

// backdrop
plane { -z, -10 
    pigment {
        color rgb <0.3, 0.3, 1.0>
    }

    #ifdef(advanced_studio)
       #if(advanced_studio)
       
       pigment {
            spotted
            color_map
            {
                [0.0 color rgb 0.0]
                [0.3 color rgb <0.3, 0.2, 0.1>]
                [0.7 color rgb <0.8, 0.7, 0.5>]
                [1.0 color rgb <0.8, 0.8, 0.8>]   
            }
            
            turbulence 1.0
            scale 4.0
       }
       
       #end
    #end
    
    finish {
        diffuse 0.8
        brilliance 0.5
    }
        
}

#macro studio_light(level, loc)

    light_source {
        loc, color rgb <1.0, 0.97, 0.93>*level
        
        //spotlight 
        //point_at 0
        //radius 45
        //falloff 90
        //tightness 0
        
        #ifdef(use_area_lights)
            #if(use_area_lights)
                area_light <1, 0, 0>, <0, 1, 0>, 5, 5
                adaptive 3
                circular
                orient
             #end
        #end
    }

#end

studio_light(1, <2, 1.5, -2>)   // Key
studio_light(0.5, <-3, 0.5, -5>)  // Fill
studio_light(1, <1.5, 8, 9.9>)  // back