///////////////////////////////////////////////////////////////////////////////
// Object Studio File
//
// This file is intended to be used when modelling individual objects. 
// It's a relatively simple "studio" environment for the objects. Consisting
// of a simple backdrop and a checkered floor. 
///////////////////////////////////////////////////////////////////////////////

// The following variables can be used to adjust the environment a bit 
// These control the relative realism of the scene to an extent. 

#include "consts.inc"
#include "functions.inc"
#include "colors.inc"

global_settings
{
    max_trace_level 100
    
}


#declare advanced_studio = no;
#declare use_photons = yes;
#declare use_radiosity = no;
#declare use_focal_blur = no;
#declare use_area_lights = no;
#declare semitrans_plane = yes;
#declare camera_location = <0, 8, -10>;
#declare camera_angle = 25;
#declare camera_target = <0, 0, 0>;

#declare floor_level = 1;        // how far below the origin the floor should be

#include "studio_defs.inc"
#include "glassware.inc"
#include "mjr_textures.inc"

union
{
    object {
        CylindricalGlass2(1.0, 0.1, 2.5)
        hollow
        ClearGlassMaterial(rgb 1.0)
    }
    
    object {
        CylindricalGlass2_Liquid(1.0, 0.1, 2.5, 0.5)
        hollow
        pigment {
                color rgbf <1.0, 0.725, 0.0, 1.0>
        }
        finish {
            //ambient 0
            conserve_energy
            specular 0.1 roughness 0.0001
            reflection {0.1, 0.005 fresnel on}
        }
        interior
        {
            ior 1.34            
            
            media
            {
                absorption  1.0 - <1.0, 0.725, 0.0>    
                scattering { 4, 6.0 extinction 2.0 }
                //density {rgb 0.9}
                method 3
            }
        }
        photons
        {
            target
            reflection on
            refraction on
        }
        
    }

    translate (-1-epsilon)*y    
}

    

    