/*
   a system for self-reseeding randomness in povray.  This enables a povray
   file have a different random number seed each time it is run.
   
   To use, simply include this file, then call "get_seed()" once.  Then use
   rseed as your seed troughout your render.  The last atatement in your .pov
   file should be a call to "update_seed()".

   The random seed will be stored in "randseed.pov"
*/


#macro get_seed()
  #if (file_exists("randseed.pov") = 1)
    #include "randseed.pov"
    // what if the file was bad or incomplete?
    #ifndef (rseed) // was this defined?
      // no.  It was not.  Fake it and hope better for next time around
      #debug "bad randseed.pov file ... making a new one\n")
      #declare rseed = seed(83963179);
    #end
  #else
    // The file was not found.  Fake it and hope better for next time around
    #debug "no randseed.pov file found ... making a new one\n")
    #declare rseed = seed(74747285);
  #end
  #ifndef (rseed)
    #debug "\nWTF!  rseed STILL not defined!  That's impossible!!\n"
    #debug "\g YOU HAVE A PROBLEM!!!!!\n"
  #end
#end


// update the random seed now that we are done with it.
#macro update_seed()
  #ifdef (rseed)
    #local new_seed = 99999999 * rand(rseed);
    #local new_seed = int(new_seed);
    #fopen F1 "randseed.pov" write
    #write (F1, "#declare rseed = seed(", str(new_seed, 0, 0), ");\n")
    #write (F1, "#debug \"Seed used is: seed(", str(new_seed, 0, 0), ") \"\n")
    #write (F1, "#debug \"\"\n")
    #fclose F1
  #end
#end


/* actual end of this_file */
