/* inspired by the random picture colloge feature that Gilles Trans
   added to his web site.  It will actually interactivly let you control
   the generation of new random pictures and display them on your web
   browser.  That is so cool!  Anwyay, this POV program tries to emulate
   what Gilles has done.

   Peter Capasso
*/
#declare txtr_output_file = "try.pov" 
#declare a_ratio = 4/3;
#ifndef (use_pics)  // skip next line if called from a master random file that already defined use_pics for us
  // no.  must define use_pics here.
  #declare use_pics = false; // set to true to use image maps, false to use random pov pigments
#end


/*
Important note: if you want to use your pictures instead of just the random
pigments, you have to do two things.

1) Create a file called "pic_list.inc".  This will contain a list of pictures
   that you have in your POV path.  Here are some examples to show the syntax
   that must be used in that file:
   
 add_pic("blue_things_01.bmp", 1024, 768, 1, 1)
 add_pic("bubbles.gif", 1152, 864, 1, 1)
 add_pic("farble.tga", 640, 480, 1, 1)
 add_pic("old_legacy_picture.iff", 320, 200, 10, 11)

   For this particular version of this program the numbers are ignored, so
   you can just place ones.
   
2) Edit the "use_pics = false;" line to say "use_pics = true;".

*/


#fopen _txtr_file txtr_output_file write


#macro lazy_map(lm_filename)
  #local lz_sl = strlen(lm_filename);
  #local lz_ext = strlwr(substr(lm_filename, lz_sl - 2, 3)) // get file type
  #if (strcmp(lz_ext, "tga") = 0)
    tga lm_filename
  #else
    #if (strcmp(lz_ext, "png") = 0)
      png lm_filename
    #else
      #if (strcmp(lz_ext, "gif") = 0)
        gif lm_filename
      #else
        #if (strcmp(lz_ext, "iff") = 0)
          iff lm_filename
        #else
          #if (strcmp(lz_ext, "jpg") = 0)
            jpeg lm_filename
          #else
            #if (strcmp(lz_ext, ".jp") = 0)
              jpeg lm_filename
            #else
              sys lm_filename
            #end
          #end
        #end
      #end
    #end
  #end
#end


#write(_txtr_file, "#version 3.5;\n\n\n")
#write(_txtr_file, "global_settings {\n")
#write(_txtr_file, "  assumed_gamma 2.2 // make same as your display_gamma number\n")
#write(_txtr_file, "  noise_generator 1\n")
#write(_txtr_file, "  max_trace_level 6\n")
#write(_txtr_file, "}\n\n\n")


#include "random.inc"  // random seed will be different each time
get_seed()  // read randseed.pov and set seed from it


#macro rnd(n)
  #local rr = int(rand(rseed) * n);
  rr
#end


#macro rrand(lo, hi)
  #local rlo = min(lo, hi);
  #local rhi = max(lo, hi);
  #local rr = rlo + ((rhi - rlo) * rand(rseed));
  rr
#end


#macro f_rnd_rotate()
  #write(_txtr_file, "  rotate z*", 16 - 32 * rand(rseed), "\n")
  #write(_txtr_file, "  rotate x*", 15 - 30 * rand(rseed), "\n")
  #write(_txtr_file, "  rotate y*", 16 - 32 * rand(rseed), "\n")
#end


#macro f_rnd_translate()
  #write(_txtr_file, "  translate ",
  <8 - 16 * rand(rseed), 6 - 12 * rand(rseed), 8 * rand(rseed)>, "\n")
#end


#macro do_random_pure_color()   // returns an RGB vector
  #local xx = int(6 * rand(rseed));
  #switch (xx)
    #case (0)
      #local rcolor = <1, rand(rseed), 0>;
      #break
    #case (1)
      #local rcolor = <1, 0, rand(rseed)>;
      #break
    #case (2)
      #local rcolor = <rand(rseed), 1, 0>;
      #break
    #case (3)
      #local rcolor = <rand(rseed), 0, 1>;
      #break
    #case (4)
      #local rcolor = <0, 1, rand(rseed)>;
      #break
    #else
      #local rcolor = <0, rand(rseed), 1>;
  #end
  rcolor // return color
#end


#macro make_rnd_color()
  <rand(rseed), rand(rseed), rand(rseed)>
#end


#macro rnd_color_map()
  #write(_txtr_file, "  color_map {\n")
  #local cm = 0.1 * rand(rseed);
  #while (cm < 1.0)
    #write(
      _txtr_file, "    [ ", cm,
      " color rgb ", make_rnd_color(), " ]\n"
    )
    #local cm = cm + 0.1 + 0.2 * rand(rseed);
  #end
  #write(_txtr_file, "  }\n")
#end


#macro rand_pic_pigment()
  #local wp = int(rand(rseed) * 5);
  #switch(wp)
    #case (0)
      #write(_txtr_file, "  bozo\n")
      #break
    #case (1)
      #write(_txtr_file, "  crackle\n")
      #break
    #case (2)
      #write(_txtr_file, "  leopard\n")
      #break
    #case (3)
      #write(_txtr_file, "  marble\n")
      #break
    #else
      #write(_txtr_file, "  quilted\n")
  #end
  #local wp = int(rand(rseed) * 5);
  #switch(wp)
    #case (0)
      #write(_txtr_file, "  sine_wave\n")
      #break
    #case (1)
      #write(_txtr_file, "  triangle_wave\n")
      #break
    #case (2)
      #write(_txtr_file, "  cubic_wave\n")
      #break
    #case (3)
      #write(_txtr_file, "  scallop_wave\n")
      #break
    #else
      #write(_txtr_file, "  ramp_wave\n")
  #end
  #write(_txtr_file, "  frequency ", 1 + int(3 * rand(rseed)), "\n")
  rnd_color_map()
  #write(_txtr_file, "  warp {\n")
  #write(_txtr_file, "    turbulence ", 3 * rand(rseed), "\n")
  #write(_txtr_file, "    octaves ", 1 + int(10 * rand(rseed)), "\n")
  #write(_txtr_file, "    lambda ", 1 + 3 * rand(rseed), "\n")
  #write(_txtr_file, "    omega ", 0.25 + 0.75 * rand(rseed), "\n")
  #write(_txtr_file, "  }\n")
  #write(
    _txtr_file, "  translate ",
    <4 - 8*rand(rseed), 4 - 8*rand(rseed), 4 - 8*rand(rseed)>, "\n"
  )
  #write(
    _txtr_file, "  rotate ",
    <360*rand(rseed), 360*rand(rseed), 360*rand(rseed)>, "\n"
  )
  #write(_txtr_file, "  scale ", 0.5 + 2.5 + rand(rseed), "\n")
#end


#declare diff_pics = rnd(3);  // how many pictures to use at the same time


#if (use_pics = true)
  #declare max_pics = 500;
  #declare pname = array[max_pics]
  #declare num_pics = 0;


  #macro add_pic(
    full_file_name,
    picture_width, // in pixels
    picture_hieght, // in pixels
    pixel_width_ratio,  // relative pixel aspect
    pixel_height_ratio  // relative pixel aspect
    )
    #declare pname[num_pics] = full_file_name
    #declare num_pics = num_pics + 1;
  #end


  #include "pic_list.inc"
#end


#write(_txtr_file, "camera {\n")
#write(_txtr_file, "  orthographic\n")
#write(_txtr_file, "  location 0\n")
#write(_txtr_file, "  right <(image_width / image_height), 0, 0>\n")
#write(_txtr_file, "  direction <0, 0, 1>\n")
#write(_txtr_file, "  up <0, 1, 0>\n")
#write(_txtr_file, "  translate <0, 0, -10>\n")
#write(_txtr_file, "}\n\n\n")


#write(_txtr_file, "#macro lazy_map(lm_filename)\n")
#write(_txtr_file, "  #local lz_sl = strlen(lm_filename);\n")
#write(_txtr_file, "  #local lz_ext = strlwr(substr(lm_filename, lz_sl - 2, 3)) // get file type\n")
#write(_txtr_file, "  #if (strcmp(lz_ext, \"tga\") = 0)\n")
#write(_txtr_file, "    tga lm_filename\n")
#write(_txtr_file, "  #else\n")
#write(_txtr_file, "    #if (strcmp(lz_ext, \"png\") = 0)\n")
#write(_txtr_file, "      png lm_filename\n")
#write(_txtr_file, "    #else\n")
#write(_txtr_file, "      #if (strcmp(lz_ext, \"gif\") = 0)\n")
#write(_txtr_file, "        gif lm_filename\n")
#write(_txtr_file, "      #else\n")
#write(_txtr_file, "        #if (strcmp(lz_ext, \"iff\") = 0)\n")
#write(_txtr_file, "          iff lm_filename\n")
#write(_txtr_file, "        #else\n")
#write(_txtr_file, "          #if (strcmp(lz_ext, \"jpg\") = 0)\n")
#write(_txtr_file, "            jpeg lm_filename\n")
#write(_txtr_file, "          #else\n")
#write(_txtr_file, "            #if (strcmp(lz_ext, \".jp\") = 0)\n")
#write(_txtr_file, "              jpeg lm_filename\n")
#write(_txtr_file, "            #else\n")
#write(_txtr_file, "              sys lm_filename\n")
#write(_txtr_file, "            #end\n")
#write(_txtr_file, "          #end\n")
#write(_txtr_file, "        #end\n")
#write(_txtr_file, "      #end\n")
#write(_txtr_file, "    #end\n")
#write(_txtr_file, "  #end\n")
#write(_txtr_file, "#end\n\n\n")


#if (use_pics = true)
  #write(_txtr_file, "#declare main_pig = pigment {\n")
  #write(_txtr_file, "  image_map {\n")
  #declare temp = rnd(num_pics);
  #write(_txtr_file, "    lazy_map(\"", pname[temp], "\")\n")
  #write(_txtr_file, "    interpolate 2\n")
  #write(_txtr_file, "  }\n")
  #write(_txtr_file, "  scale <", a_ratio, ", 1, 1>\n")
  #write(_txtr_file, "}\n\n\n")

  #if (diff_pics > 0) // pick a second picture
    #write(_txtr_file, "#declare second_pig = pigment {\n")
    #write(_txtr_file, "  image_map {\n")
    #declare temp_p2 = rnd(num_pics);
    #write(_txtr_file, "    lazy_map(\"", pname[temp_p2], "\")\n")
    #write(_txtr_file, "    interpolate 2\n")
    #write(_txtr_file, "  }\n")
    #write(_txtr_file, "  scale <", a_ratio, ", 1, 1>\n")
    #write(_txtr_file, "}\n\n\n")
  #end

  #if (diff_pics > 1) // pick a third picture
    #write(_txtr_file, "#declare third_pig = pigment {\n")
    #write(_txtr_file, "  image_map {\n")
    #declare temp_p3 = rnd(num_pics);
    #write(_txtr_file, "    lazy_map(\"", pname[temp_p3], "\")\n")
    #write(_txtr_file, "    interpolate 2\n")
    #write(_txtr_file, "  }\n")
    #write(_txtr_file, "  scale <", a_ratio, ", 1, 1>\n")
    #write(_txtr_file, "}\n\n\n")
  #end
#else // no pics - make rnd pigment
  #write(_txtr_file, "#declare main_pig = pigment {\n")
  rand_pic_pigment() // regular
  #write(_txtr_file, "}\n\n\n")

  #if (diff_pics > 0) // pick a second pigment
    #write(_txtr_file, "#declare second_pig = pigment {\n")
    rand_pic_pigment() // regular
    #write(_txtr_file, "}\n\n\n")
  #end

  #if (diff_pics > 1) // pick a third pigment
    #write(_txtr_file, "#declare third_pig = pigment {\n")
    rand_pic_pigment() // regular
    #write(_txtr_file, "}\n\n\n")
  #end
#end
    

#if (use_pics = true)    
  #declare temp_pic = pigment { // use this to pic a color from the input pic
    image_map { lazy_map(pname[temp]) interpolate 2 }
  }

  #declare temp_f = function {
    pigment { temp_pic }
  }


  #declare picker = <rrand(0, 1), rrand(0, 1)>;
#else // use_pics is false
  #switch (rnd(5))
    #case (0) #declare picker = <0, 0, 0>;  #break
    #case (1) #declare picker = <1, 1, 1>;  #break
    #case (2) #declare picker = <0.6, 0.6, 0.6>;  #break
    #else
      #declare picker = <rand(rseed), rand(rseed), rand(rseed)>;
  #end
#end


#if (rnd(4) = 2)
  #write(_txtr_file, "background { color rgb 1 - <") // negative color
#else
  #write(_txtr_file, "background { color rgb <")
#end
#if (use_pics = true)
  #if (rnd(7) > 0)
    #write(_txtr_file, temp_f(picker.u, picker.v, 0).red, ", ")
    #write(_txtr_file, temp_f(picker.u, picker.v, 0).green, ", ")
    #write(_txtr_file, temp_f(picker.u, picker.v, 0).blue, "> }\n\n\n")
  #else
    #undef picker
    #switch (rnd(3))
      #case (0) #declare picker = <0, 0, 0>;  #break
      #case (1) #declare picker = <1, 1, 1>;  #break
      #else
        #declare picker = <0.6, 0.6, 0.6>;
    #end
    #write(_txtr_file, picker.x, ", ", picker.y, ", ", picker.z, "> }\n\n\n")
  #end
#else
  #write(_txtr_file, picker.x, ", ", picker.y, ", ", picker.z, "> }\n\n\n")
#end


#write(_txtr_file, "#macro a_alpha(pig_in, new_alpha)\n")
#write(_txtr_file, "  #local f1 = function { pigment { pig_in } }\n")
#write(_txtr_file, "  #local R = pigment {\n")
#write(_txtr_file, "    function { f1(x,y,z).red }\n")
#write(_txtr_file, "    color_map {\n")
#write(_txtr_file, "      [ 0.0 color rgbt <0, 0, 0, new_alpha> ]\n")
#write(_txtr_file, "      [ 1.0 color rgbt <3, 0, 0, new_alpha> ]\n")
#write(_txtr_file, "    }\n")
#write(_txtr_file, "  }\n")
#write(_txtr_file, "  #local G = pigment {\n")
#write(_txtr_file, "    function { f1(x,y,z).green }\n")
#write(_txtr_file, "    color_map {\n")
#write(_txtr_file, "      [ 0.0 color rgbt <0, 0, 0, new_alpha> ]\n")
#write(_txtr_file, "      [ 1.0 color rgbt <0, 3, 0, new_alpha> ]\n")
#write(_txtr_file, "    }\n")
#write(_txtr_file, "  }\n")
#write(_txtr_file, "  #local B = pigment {\n")
#write(_txtr_file, "    function { f1(x,y,z).blue }\n")
#write(_txtr_file, "    color_map {\n")
#write(_txtr_file, "      [ 0.0 color rgbt <0, 0, 0, new_alpha> ]\n")
#write(_txtr_file, "      [ 1.0 color rgbt <0, 0, 3, new_alpha> ]\n")
#write(_txtr_file, "    }\n")
#write(_txtr_file, "  }\n")
#write(_txtr_file, "  #local rr = pigment {\n")
#write(_txtr_file, "    average\n")
#write(_txtr_file, "    pigment_map { [ 1 R ] [ 1 G ] [ 1 B ] }\n")
#write(_txtr_file, "  };\n")
#write(_txtr_file, "  rr\n")
#write(_txtr_file, "#end\n\n\n")


#macro size_and_place0() // no random
  #declare pic_sizeH = rrand((25 / 480), (155 / 480));
  #declare pic_sizeV = pic_sizeH;
  #declare pic_top_left = <a_ratio * rand(rseed), rand(rseed), cc / -200>;
  #declare tex_top_left = <(a_ratio - pic_sizeH) * rand(rseed), (1 - pic_sizeV) * rand(rseed), cc / -200>;
#end


#macro size_and_place1() // even random
  #if (V = 0)
    #declare pic_sizeH = rrand((30 / 480), (160 / 480));
    #declare pic_sizeV = rrand((30 / 480), (160 / 480)) / p_rect_r;
  #else
    #declare pic_sizeH = rrand((30 / 480), (160 / 480)) / p_rect_r;
    #declare pic_sizeV = rrand((30 / 480), (160 / 480));
  #end
  #declare pic_top_left = <a_ratio * rand(rseed), rand(rseed), cc / -200>;
  #declare tex_top_left = <(a_ratio - pic_sizeH) * rand(rseed), (1 - pic_sizeV) * rand(rseed), cc / -200>;
#end


#macro size_and_place2() // random clumped at a column
  #if (V = 0)
    #declare pic_sizeH = rrand((30 / 480), (160 / 480));
    #declare pic_sizeV = rrand((30 / 480) / (p_rect_r * 2), (160 / 480)) / (p_rect_r * 2);
  #else
    #declare pic_sizeH = rrand((30 / 480)  / (p_rect_r * 1.5), (160 / 480)) / (p_rect_r * 1.5);
    #declare pic_sizeV = rrand((30 / 480), (160 / 480));
  #end
  #declare pic_top_left = <a_ratio * rand(rseed), rand(rseed), cc / -200>;
  #declare tex_top_left = <(a_ratio - pic_sizeH) * rand(rseed), (1 - pic_sizeV) * rand(rseed), cc / -200>;
  #local Hsize_scale = pic_top_left.x;
  #if (Hsize_scale > 1)
    #local Hsize_scale = 1;
  #end
  // 0 at left 1 for rest
  #local Hsize_scale = 1 - Hsize_scale; // 1 for left, 0 for rest
  #local Hsize_scale = Hsize_scale * 2.1 + 0.4; // 0.4 to 2.5
  #declare pic_sizeH = pic_sizeH * Hsize_scale;
  #declare pic_sizeV = pic_sizeV * Hsize_scale;
  #declare tex_top_left = <(a_ratio - pic_sizeH) * rand(rseed), (1 - pic_sizeV) * rand(rseed), cc / -200>;
  #if (sm2_1 = 1) // flip arrangement of boxes left right
    //#declare pic_top_left = (<-1, 1, 1> * pic_top_left) + <a_ratio, 0, 0>;
    #declare pic_top_left = <
      ((0 - pic_top_left.x) + a_ratio),
      pic_top_left.y,
      pic_top_left.z
    >;
  #end
#end


#declare p_rect_r = 1 + rnd(10);  /* global picture rectangle ratio */
#declare num_rects = 120 + rnd(200);
#declare sizing_method = rnd(3);
#if (rnd(2) = 1) // flip arrangement of sizing_method 2boxes left right
  #declare sm2_1 = 0;
#else
  #declare sm2_1 = 1;
#end


#declare cc = 0;
#while (cc < num_rects)
  #declare V = rnd(2);  // this pic - vertical or horizontal
  #switch (sizing_method)
    #case (0)
      size_and_place0()
      #break
    #case (1)
      size_and_place1()
      #break
    #else
      size_and_place2()
  #end // end switch
  #write(_txtr_file, "box {\n")
  #write(_txtr_file, "  <", -0.5 * pic_sizeH, ", ", -0.5 * pic_sizeV, ", 0>\n")
  #write(_txtr_file, "  <", 0.5 * pic_sizeH, ", ", 0.5 * pic_sizeV, ", 0>\n")
  #write(_txtr_file, "  pigment {\n")
  #write(_txtr_file, "    a_alpha (\n")
  #switch (rnd(diff_pics + 1))
    #case (1)
      #write(_txtr_file, "      pigment { second_pig translate ", -tex_top_left, " },\n")
      #break
    #case (2)
      #write(_txtr_file, "      pigment { third_pig translate ", -tex_top_left, " },\n")
      #break
    #else
      #write(_txtr_file, "      pigment { main_pig translate ", -tex_top_left, " },\n")
  #end // end switch
  #write(_txtr_file, "      ", rrand(0.1, 1), "\n")
  #write(_txtr_file, "    )\n")
  #write(_txtr_file, "  }\n")
  #write(_txtr_file, "  finish { ambient 1 diffuse 0 }\n")
  #write(_txtr_file, "  translate ", pic_top_left + <-0.5 * a_ratio, -0.5, 0>, "\n")
  #write(_txtr_file, "}\n\n\n")
  #declare cc = cc + 1;
#end


#write(_txtr_file, "/* actual end of this file */\n")
/* done creating try.pov file */
#fclose _txtr_file
#include "try.pov"


/* very last step: */
// update the random seed now that we are done with it.
update_seed()  // put new seed into randseed.pov


/* actual end of this file */
