
#version 3.5;

global_settings {assumed_gamma 1.0}

camera {location  <5,-10,-10> look_at <1,2.5,0> angle 33}

background {rgb 1}

light_source {<30, 0, -30> color rgb 1}

// ----------------------------------------


// This spline describes the path along the object
// From control points 0 to 1
#declare USpline = 
  spline {
    natural_spline
    -1, <0,12,0>,
    0,  <0,10,0>,
    0.5 <2,5,2>,    
    1, <0,0,0>,
    2, <0,-1,0>
  }

// This spline describes the cross section of the object
// For a closed shape the spline should have the same values at control points 0 and 1 
// The z coordinate is not used
#declare VSpline =
  spline {
    cubic_spline
   -0.125, <0.25,-0.25,0>,
    0,     <1,0,0>,
    0.125, <0.25,0.25,0>,
    0.25,  <0,1,0>,
    0.375, <-0.25,0.25,0>,
    0.5,   <-1,0,0>,
    0.625, <-0.25,-0.25,0>,
    0.75,  <0,-1,0>,
    0.875, <0.25,-0.25,0>,
    1,     <1,0,0>
    1.125, <0.25,0.25,0>,
  }

// This spline describes how the width varies 
#declare WSpline = spline {
  cubic_spline
    -1, 0,
    0.0, 0.001, // Note: shouldn't let it become zero
    0.8, 1
    1.0, 1.5
    2.0, 2.5
 }

#declare Upoints = 20;  // Number of points along
#declare Vpoints = 50;  // Number of points around
#declare Filename = ""

#include "SweepSpline.inc"
object {
  SweepSpline(USpline, VSpline, WSpline, Upoints, Vpoints, Filename)
  uv_mapping pigment {checker scale 0.05}
  finish {phong 0.2 phong_size 10}
}

