// Persistence of Vision Ray Tracer Include File
// File: SweepMesh.inc
// Vers: 3.5
// Desc: Macro for approximating a sphereswwp by a mesh
// Date: 15-Nov-2003
// Auth: Mike Williams
// Based on an idea by Greg M. Johnson


// Release 1.1 : Kluge added to try to avoid the thing flipping inside out

// Requires makemesh.inc by Ingo Janssen <http://members.home.nl/seedseven/>
//
// Parameters
// Track        A spline that specifies the path of the spheresweep
//              The secion of the spline between control points 0 and 1 will be used
// Waist        A spline with x coordinates that specify the radius of the spheresweep
//              The secion of the spline between control points 0 and 1 will be used
// U            The number of vertices along the path
// V            The number of vertices around the circumpherence
// FileName     The name of the file to whitch the mesh will be written. 
//              If is an empty string (""), no file will be written.
//              If the file extension is 'obj' a Wavefront objectfile will be written.
//              If the extension is 'pcm' a compressed mesh file is written.
//              If a file name is given, the macro will first check if it already exists.
//              If that is so, it will try to parse the existing file unless it's a '*.obj',
//               '*.pcm' or '*.arr' file as POV-Ray can not read them directly. In this case a new
//                mesh will be generated, but the existing files will _not_ be over-written.
// Debug        Set non-zero to display calculated normals - the value specifies the length
//              Also displays three "seams"
//              Note that the macro returns a mesh2 if Debug is zero and a union if non-zero
  
#include "makemesh.inc"

#macro SweepMesh(Track,Waist,U,V,Filename,Debug)
#local Verts = array[U*(V+1)]
#local Norms = array[U*(V+1)]
#local UV    = array[U*(V+1)]
                           
#if (Debug)
  union {
#end                           
                           
// Calculate the Vertexes, Normals and UV arrays
#local DRY = y; // Arbitrary initial vector that X will be perpendicular to
#local uu=0;
#while (uu<U)
  #local vv=0;
  #while (vv<=V)
     // UV information
     #local su = uu/U;
     #local sv = vv/V;
     #local UV[uu*(V+1)+vv] = <su,sv>;
     
     // Spline point and radius 
     #local P = Track(su);
     #local W = vlength(Waist(su).x);

     // Direction the spline is pointing
     #local DR = Track(su+0.001)-Track(su-0.001); 

     // Vertex position
     // To prevent flipping, calculate from the previous DRY vector 
     #local DRX = W*vnormalize(vcross(DR,DRY));
     #local DRY = W*vnormalize(vcross(DRX,DR));
     #local Verts[uu*(V+1)+vv] = P + cos(sv*2*pi)*DRX + sin(sv*2*pi)*DRY;

     // Normal
     #local Norms[uu*(V+1)+vv] = cos(sv*2*pi)*DRX + sin(sv*2*pi)*DRY;

     #local vv=vv+1;
  #end
  #local uu=uu+1;
#end

BuildWriteMesh2(Verts, Norms, UV, V, U-1, Filename)

// Debugging
#if (Debug)
  #local uu=0;
  #while (uu<U)

    // Track some seams
    sphere {Verts[uu*(V+1)],Debug/2 pigment {rgb x} }
    sphere {Verts[uu*(V+1)+V/3],Debug/2 pigment {rgb y} }
    sphere {Verts[uu*(V+1)+2*V/3],Debug/2 pigment {rgb z} }


    #local vv=0;
    #while (vv<=V)
      // display Normals
      cylinder {0,vnormalize(Norms[uu*(V+1)+vv])*Debug,Debug/10
        translate Verts[uu*(V+1)+vv]
        pigment {rgb x}
      }
     
      #local vv=vv+1;
    #end
    #local uu=uu+1;
  #end
  }
#end

#end
