// Copyright (C) 2003
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// ========================================
//  Notes
// ========================================
//  Author: Tim Nikias Wenclawiak
//            aka "Tim Nikias v2.0"
//
// Homepage:
//  www.nolights.de
// Email:
//  Tim.Nikias(@)gmx.de


// ==============================================
//  Subsurface-Scattering Ball (Spherical Candle)
// ==============================================

//These two define density and color of subsurface-effect
#declare SSS_Density=2;
#declare SSS_Color=x;
//Rotation of candlelight on candle
#declare CandleLight_Rotation=<-35,-15,0>;

union{
 //Lightsource for the candlelight
 light_source{
  vrotate(y*.5,CandleLight_Rotation)+y*.1 rgb 1 fade_power 2 fade_distance 1.5
  //Tiny area-light for smooth shadows, but not too excessive
  area_light x*.1,y*.1,5,5 orient circular
  }
 //Candle-Stick
 cylinder{y*.25,y*.5,.02 pigment{rgb 0} no_shadow rotate CandleLight_Rotation}
 //Candlelight
 sphere{0,1 hollow
  //A rather simple media for the colors of the tiny flame
  pigment{rgbt <0,0,0,1>}
  interior{media{emission 10 method 3 intervals 1 samples 20,30
   density{gradient y color_map{[0 rgb z][.1 rgb x][.4 rgb <1,.6,0>][1 rgb <1,1,.3>]}scale 2 translate -1}
   density{spherical poly_wave 2 color_map{[0 rgb 0][1 rgb 3]}}
   }}
  scale <.1,.3,.1> //Proper scaling
  //Position it, but don't reorient it
  translate vrotate(y*.5,CandleLight_Rotation)+y*.15
  no_shadow //We don't want it throwing shadows anywhere
  }
 //Candle-wax
 blob{threshold .5
  //Different textures for solid and liquid wax (different specular-levels)
  sphere{0,2,1
   texture{pigment{rgbft <SSS_Color.x,SSS_Color.y,SSS_Color.z,.2,.6>}finish{specular .2 roughness .1 metallic .75}}
   }
  sphere{0,.75,-1
   texture{pigment{rgbft <SSS_Color.x,SSS_Color.y,SSS_Color.z,.2,.6>}finish{specular 1 roughness .001 metallic .25}}
   //The "molten" section has to be placed correctly
   scale <1,2,1> translate y rotate CandleLight_Rotation
   }
  //Subsurface-Scattering in action:
  hollow
  interior{ior 1.6 //fade_power 2 fade_distance .05 fade_color x
   media{
    //The scattering part
    scattering{5,SSS_Color eccentricity .2 extinction 1.5}
    //Retaining the original color by absorbing the negative color
    absorption <1,1,1>-SSS_Color   
    method 2 intervals 5 samples 5,5
    //Adjusting the intensity
    density{rgb SSS_Density}
    }
   }
   double_illuminate
  }
 
 //Translate to proper position
  ball_at(1,2)
 }
