// Copyright (C) 2003
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// ========================================
//  Notes
// ========================================
//  Author: ?
//
//  From POV-Ray Questions and Tips
//   http://tag.povray.org/povQandT/

// ========================================
//  Ball
// ========================================
sphere {
  0, 1
  rgb 1
  ball_at (0,3)

#declare BlurAmount = .2; // Amount of blurring 
#declare BlurSamples = 20; // How many rays to shoot 
  texture {
    average texture_map {
      #declare Ind = 0; 
      #declare S = seed(0); 
      #while(Ind < BlurSamples) 
        [1 // The pigment of the object: 
           pigment {color rgb<0.83,0.82,0.84>*1.2} 
           // The surface finish: 
           finish {
             specular 0.9
             roughness 0.03
             phong 1.0
             brilliance 7.3
             phong_size 80
             metallic .5
             reflection{0.6,1.0 metallic}
           } 
           // This is the actual trick:
           normal {
             bumps BlurAmount 
             translate <rand(S),rand(S),rand(S)>*10 
             scale 1000 
           } 
        ] 
        #declare Ind = Ind+1; 
      #end 
    } 
  } 
} 




