// Persistence of Vision Ray Tracer Scene Description File
// File: ex4.pov
// Vers: POV-Ray 3.5
// Desc: Scatter_multiple macro sample scene
// Date: 
// Auth: Jonathan Rafael Ghiglia
//


#include "transforms.inc"


#declare scatter_land = plane {y,0}
#declare total_objects =50;
#declare x_accuracy=20;   // letters need much more precision
#declare z_accuracy=20;
#declare file_name = "ex4.inc"   
#declare RS=seed(0); 

#macro scatter_object_macro (N)
#switch (N)
#case (1)
text { ttf "arial.ttf" "A" 0.1,1 rotate 90*x pigment {rgb 0.5+0.5*<rand(RS),rand(RS),rand(RS)>} scale 0.5}
#break
#case (2)
text { ttf "arial.ttf" "B" 0.1,1 rotate 90*x pigment {rgb 0.5+0.5*<rand(RS),rand(RS),rand(RS)>} scale 0.5}
#break
#case (3)
text { ttf "arial.ttf" "C" 0.1,1 rotate 90*x pigment {rgb 0.5+0.5*<rand(RS),rand(RS),rand(RS)>} scale 0.5}
#break
#case (4)
text { ttf "arial.ttf" "D" 0.1,1 rotate 90*x pigment {rgb 0.5+0.5*<rand(RS),rand(RS),rand(RS)>} scale 0.5}
#break
#case (5)
text { ttf "arial.ttf" "E" 0.1,1 rotate 90*x pigment {rgb 0.5+0.5*<rand(RS),rand(RS),rand(RS)>} scale 0.5}
#break
#case (6)
text { ttf "arial.ttf" "F" 0.1,1 rotate 90*x pigment {rgb 0.5+0.5*<rand(RS),rand(RS),rand(RS)>} scale 0.5}
#break
#case (7)
text { ttf "arial.ttf" "G" 0.1,1 rotate 90*x pigment {rgb 0.5+0.5*<rand(RS),rand(RS),rand(RS)>} scale 0.5}
#break
#case (8)
text { ttf "arial.ttf" "H" 0.1,1 rotate 90*x pigment {rgb 0.5+0.5*<rand(RS),rand(RS),rand(RS)>} scale 0.5}
#break
#end   
#end


#macro position_macro()
vtransform (3*rand(RS)*x, transform {rotate 360*rand(RS)*y})
#end  

#declare height_accuracy= 0.005;
#declare max_height=0.5;
     
//#include "scatter.mcr"

//scatter_multiple (8,file_name)  

#include "ex4.inc"
// ----------------------------------------

#declare Location = <-2, 3, -4>;
#declare Look_at = <0, 0, 0>;

camera
{
  location  Location
  look_at   Look_at
}

sky_sphere { pigment { rgb <0.6, 0.8, 1> } }

light_source
{ <4, 5, -5>
  rgb <1, 1, 1>*2.5	
  fade_power 2
  fade_distance 5
 }

// ----------------------------------------
plane { y, 0 
	pigment {color rgb <1, 1, 1>}
	finish { ambient 0 diffuse 0.5 specular 0.2 roughness 0.015 reflection 0.2 }
	}
