// Persistence of Vision Ray Tracer Scene Description File
// File: ex1.pov
// Vers: POV-Ray 3.5
// Desc: Scatter macro sample scene
// Date: 
// Auth: Jonathan Rafael Ghiglia
//


#include "logo.inc"
#include "transforms.inc"

#declare coin=
union {
object {
    Povray_Logo_Prism
    rotate 90*x  
    scale <0.7,0.9,0.7>
} 

difference {
superellipsoid {
    <1,0.3>
    rotate 90*x
    scale <1,0.1,1>
}

cylinder {0.07*y,0.15*y,0.9}
}
}


#declare scatter_land = plane {y,0}
#declare total_objects =100;
#declare scatter_object = object {coin}
#declare x_accuracy=15;
#declare z_accuracy=15;
#declare file_name = "ex1.inc"   
#declare RS=seed(0);

#macro position_macro()
vtransform (3*rand(RS)*x, transform {rotate 360*rand(RS)*y})
#end  

#declare height_accuracy= 0.005;
#declare max_height=0.7;
     
//#include "scatter.mcr"

//scatter (file_name)  

#macro scatter_object_macro ()
object {coin
    pigment { rgb 0.5+<rand(RS),rand(RS),rand(RS)>*0.5}
    finish {diffuse 0.6 specular 1 roughness 0.005}
}
#end

object {
#include "ex1.inc"
scale 0.25}

#declare Location = <-2, 3, -4>;
#declare Look_at = <0, 0, 0>;

camera
{
  location  Location
  look_at   Look_at
}

sky_sphere { pigment { rgb <0.6, 0.8, 1> } }

light_source
{ <4, 5, -5>
  rgb <1, 1, 1>*2.5	
  fade_power 2
  fade_distance 5
 }

// ----------------------------------------
plane { y, 0 
	pigment {color rgb <1, 1, 1>}
	finish { ambient 0 diffuse 0.5 specular 0.2 roughness 0.015 reflection 0.2 }
}  


