// Persistence of Vision Ray Tracer Scene Description File
// File: demo2_voronoi.pov
// Vers: 3.5
// Desc: Demo scene for Voronoi diagrams showing how nice it can be. :-)
//       This was actually my first post on povray.binaries.images
// Date: 29/04/2003
// Auth: Jean-Charles Marteau
//

#version 3.5;

#include "math_geom.inc"
#include "hl_geom.inc"

#include "debug.inc"
Set_Debug(false)

#include "voronoi.inc"

#declare Create_File=on;
#declare With_Spheres=on;
#declare With_Main_Light=on;

// Sorry but you don't have my wonderfull photo lighting system.
// (actually it's too crap for me show ;-)
#declare With_Lighting=off;

global_settings {
  assumed_gamma 1.0
}

#default {
  texture {
    pigment {rgb 1}
    finish {
      ambient 0.0
      diffuse 0.6
      specular 0.3
    }
  }
}

// ----------------------------------------

#local Cam_Pos=<50.0,20.0,-40.0>*3;
#local Subject_Pos=<3,0,-4>;

camera {
  location Cam_Pos
  look_at  Subject_Pos
  angle 11
}

#default {
  texture {
    pigment {rgb 1}
    finish {
      ambient 0.3
      diffuse 0.6
      specular 0.3
    }
  }
}

#if (With_Lighting)
  #include "lighting.inc"
  Photo_3Lights (Cam_Pos, Subject_Pos, -45, 25, 195, <1,1,1>, 2, 1, 5)
#else
light_source {
  <30, 70, -40>
  color rgb 1.0
  area_light
  <8, 0, 0> <0, 0, 8>
  4, 4
  adaptive 0
  jitter
  circular
  orient
}
#end

#declare Pig1=pigment {
  marble
  turbulence 5.0
  octaves 6.0
  omega 0.6
  scale 35.0
  sine_wave
  pigment_map {
    [0.0000 rgb 1.0]
    [0.9990 rgb 1.0]
    [0.9995 rgb 0.1]
    [1.0000 rgb 0.0]
  }
}
       
#declare Pig2=pigment {
  granite
  turbulence 1.0
  scale 0.08
}
   
#declare Pig3=pigment {
  average
  pigment_map {
    [1.0 Pig1]
    [0.5 Pig2]
  }
}

// -----------------------------------------------
//  Partie principale
// -----------------------------------------------
#local TheBase=6;
#declare MySeed1=seed(TheBase);
#declare MySeed2=seed(TheBase*3);

// Voronoi creation stuff, have a look at demo1_voronoi.pov for explanations.
#if (Create_File)
  Init_Voronoi (250, <-40.0,-40.0>, < 40.0, 40.0>, MySeed1)
  Tamis_initial_rectangulaire ()
  Repartition_Aleatoire (1.8)
  Delaunay_Triangulation ()
  Save_Voronoi ("vorofield_0250.inc")
#else
  #include "vorofield_0250.inc"
#end

#local index=Start_index;
#while (index < Nb_Points)
  // This is the main macro for accessing valuable Voronoi data, see voronoi.inc header
  // for more details.
  Polygone_Voronoi (index)
  #local hauteur=3.0*rand(MySeed2);
  #if (rand(MySeed2) > 0.5)
    object {
      Round_Prism (Point_Polygone, 10.0, 0.15, 3)
      texture {
	pigment { rgb <1.0, 1.0, 1.0> }
	finish {
	  ambient 0.3
	  specular 0.1
	}
	normal { pigment_pattern { Pig3 } translate <Points[index].u, Points[index].v, 0.0> * 100.0 }
      }
      translate <0.0,0.0,hauteur>
      rotate <90,0,0>
    }
    #if (With_Spheres)
      sphere {
	<Points[index].u, Points[index].v, -5.75>, 0.75
	texture {
	  pigment { rgb <0.15, 0.0, 0.0> }
	  finish {
	    reflection {
	      0.8
	      metallic 0.8
	    }
	    conserve_energy
	    phong 2.0
	    phong_size 500
	  }
	}
	translate <0.0,0.0,hauteur>
	rotate <90,0,0>
      }
    #end
  #else
    object {
      Round_Prism (Point_Polygone, 10.0, 0.2, 0)
      texture {
	pigment { rgb 0.0 }
	finish {
	  ambient 0.0
	  specular 0.1
	  reflection 0.06
	}
	normal {
	  granite
	  scale <0.3, 0.3, 20.0>
	}
      }
      translate <0.0,0.0,hauteur>
      rotate <90,0,0>
    }
    // Prisme qui occupe juste la surface pour qu'elle soit lisse.
    object {
      Round_Prism (Point_Polygone, 0.0001, 0.2, 0)
      texture {
	pigment { rgb 0.0 }
	finish {
	  ambient 0.0
	  specular 0.1
	  reflection 0.06
	}
      }
      translate <0.0,0.0,hauteur-5-0.0001/2>
      rotate <90,0,0>
    }
    
    #if (With_Spheres)
      sphere {
	<Points[index].u, Points[index].v, -5.75>, 0.75
	texture {
	  pigment { rgb <1.0, 0.8, 0.8> }
	  finish {
	    reflection {
	      0.8
	      metallic 0.8
	    }
	    conserve_energy
	    phong 2.0
	    phong_size 500
	  }
	}
	translate <0.0,0.0,hauteur>
	rotate <90,0,0>
      }
    #end
  #end
  #local index=index+1;
#end

Finalisation ()
