// Persistence of Vision Ray Tracer Scene Description File
// File: demo1_voronoi.pov
// Vers: 3.5
// Desc: Demo scene for Voronoi diagrams showing a geometric view of the problem.
// Date: 28/08/2003
// Auth: Jean-Charles Marteau
//

#version 3.5;

#include "math_geom.inc"
#include "hl_geom.inc"
#include "voronoi.inc"

#include "debug.inc"
Set_Debug(false)

#declare Create_File=on;

global_settings {
  assumed_gamma 1.0
}

#local taille=240;

// ----------------------------------------
camera {
  orthographic
  location <0,0,-70.0>     // position & direction of view
  look_at  <0,0,0>
  right taille*x            // horizontal size of view  \___ to be rendered at square size
  up taille*3/4*y               // vertical size of view    /
}

#default {
  texture {
    pigment {rgb 1}
    finish {
      ambient 1.0
      diffuse 0.6
      specular 0.3
    }
  }
}

// -----------------------------------------------
//  Partie principale : exemple d'utilisation.
// -----------------------------------------------
#local TheBase=5;
#declare MySeed=seed(TheBase);

#if (Create_File)
  // Here is the Voronoi field creation, you should always follow these steps.
  // each steps sets up some global variables with the appropriate values.
  
  // Initialisation provides :
  //  - The number of points for the diagram (= number of polygons after computation)
  //  - Two (x,z) planar points defining the limits in which the points will be.
  //  - A initialized random seed
  Init_Voronoi (50, <-40.0,-40.0>, < 40.0, 40.0>, MySeed)
  
  // This macro is just another initialisation macro. It is separated from the
  // previous init because various further initialisation could be choosen.
  Tamis_initial_rectangulaire ()
  
  // This macro is again another initialisation that will put the points at
  // random within the area defined at init. The parameter is the minimum
  // distance allowed between two points. You should be very carefull that
  // You should be carefull that the total number of points, the surface of
  // the area and the minimum distance can't be choosen independantly (it's
  // question of fitting disks in a given area).
  Repartition_Aleatoire (5.0)
  
  // This is the main algorithm, it is potentially very long.
  Delaunay_Triangulation ()
  
  // The Voronoi library has a great save functionality. It might be pointless with
  // 50 points, but will save a lot of time when doing 6000. If you have a look at
  // the saved file you will see that it is an include file for POV-Ray containing
  // only data.
  Save_Voronoi ("vorofield_0050.inc")
#else
  // Include a Voronoi lib generated file puts exactly in the same situation than
  // after the Delaunay_Triangulation call.
  #include "vorofield_0050.inc"
#end

// We display the various geometrical elements. If it's too messy, you can try
// commenting them one by one.
// This stuff is not very exciting, so the demo2 example will show you how you
// can handle these polygons to make your own way through Voronoi's world.
Dessiner_cercles ()
Dessiner_aretes ()
Dessiner_points ()
Dessiner_polygones ()

// That is just to work cleanly, or in case we want to do several triangulation
// in a raw.
Finalisation ()
