#include "colors.inc"
#include "stones.inc"
#include "textures.inc" 
#include "finish.inc"
#include "shapes.inc"
 
 
 
global_settings {
 adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>*1
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 150
  number_of_waves 10
}  
 
#declare sunlight=White*.9+Gold*.5+SkyBlue*.25;
#declare sunlight=sunlight*1.1;
#include "lightarray.inc"
#declare Yellow_Pine = texture {
   pigment {
      wood
      turbulence 0.02
      color_map {
         [0.000, 0.222  color red  0.808  green  0.671  blue  0.251  filter  0.000
                        color red  0.808  green  0.671  blue  0.251  filter  0.000]
         [0.222, 0.342  color red  0.808  green  0.671  blue  0.251  filter  0.000
                        color red  0.600  green  0.349  blue  0.043  filter  0.000]
         [0.342, 0.393  color red  0.600  green  0.349  blue  0.043  filter  0.000
                        color red  0.808  green  0.671  blue  0.251  filter  0.000]
         [0.393, 0.709  color red  0.808  green  0.671  blue  0.251  filter  0.000
                        color red  0.808  green  0.671  blue  0.251  filter  0.000]
         [0.709, 0.821  color red  0.808  green  0.671  blue  0.251  filter  0.000
                        color red  0.533  green  0.298  blue  0.027  filter  0.000]
         [0.821, 1      color red  0.533  green  0.298  blue  0.027  filter  0.000
                        color red  0.808  green  0.671  blue  0.251  filter  0.000]
      }
      scale 0.1
      translate 10*x
   }
}
 
// Yellow_Pine layer 2
texture {
   pigment {
      wood
      turbulence 0.01
      color_map {
         [0.000, 0.120   color red  1.000  green  1.000  blue  1.000  filter  1.000
                         color red  0.702  green  0.412  blue  0.118  filter  0.608]
         [0.120, 0.231   color red  0.702  green  0.412  blue  0.118  filter  0.608
                         color red  0.702  green  0.467  blue  0.118  filter  0.608]
         [0.231, 0.496   color red  0.702  green  0.467  blue  0.118  filter  0.608
                         color red  1.000  green  1.000  blue  1.000  filter  1.000]
         [0.496, 0.701   color red  1.000  green  1.000  blue  1.000  filter  1.000
                         color red  1.000  green  1.000  blue  1.000  filter  1.000]
         [0.701, 0.829   color red  1.000  green  1.000  blue  1.000  filter  1.000
                         color red  0.702  green  0.467  blue  0.118  filter  0.608]
         [0.829, 1       color red  0.702  green  0.467  blue  0.118  filter  0.608
                         color red  1.000  green  1.000  blue  1.000  filter  1.000]
      }
      scale 0.5 
      translate 10*x
   }
}
#declare Rosewood = texture {
   pigment {
      bozo
      turbulence 0.04
      color_map {
         [0.000, 0.256   color red  0.204  green  0.110  blue  0.078  filter  0.000
                         color red  0.231  green  0.125  blue  0.090  filter  0.000]
         [0.256, 0.393   color red  0.231  green  0.125  blue  0.090  filter  0.000
                         color red  0.247  green  0.133  blue  0.090  filter  0.000]
         [0.393, 0.581   color red  0.247  green  0.133  blue  0.090  filter  0.000
                         color red  0.204  green  0.110  blue  0.075  filter  0.000]
         [0.581, 0.726   color red  0.204  green  0.110  blue  0.075  filter  0.000
                         color red  0.259  green  0.122  blue  0.102  filter  0.000]
         [0.726, 0.983   color red  0.259  green  0.122  blue  0.102  filter  0.000
                         color red  0.231  green  0.125  blue  0.086  filter  0.000]
         [0.983, 1       color red  0.231  green  0.125  blue  0.086  filter  0.000
                         color red  0.204  green  0.110  blue  0.078  filter  0.000]
      }
      scale <0.5, 0.5, 1>
      translate 10*x
   }
   finish {
      ambient 0.5
      diffuse 0.8
   }
}
 
// Rosewood layer 2
texture {
   pigment {
      wood
      turbulence 0.04
      color_map {
         [0.000, 0.139   color red  0.545  green  0.349  blue  0.247  filter  1.000
                         color red  0.000  green  0.000  blue  0.000  filter  0.004]
         [0.139, 0.148   color red  0.000  green  0.000  blue  0.000  filter  0.004
                         color red  0.000  green  0.000  blue  0.000  filter  0.004]
         [0.148, 0.287   color red  0.000  green  0.000  blue  0.000  filter  0.004
                         color red  0.545  green  0.349  blue  0.247  filter  1.000]
         [0.287, 0.443   color red  0.545  green  0.349  blue  0.247  filter  1.000
                         color red  0.545  green  0.349  blue  0.247  filter  1.000]
         [0.443, 0.626   color red  0.545  green  0.349  blue  0.247  filter  1.000
                         color red  0.000  green  0.000  blue  0.000  filter  0.004]
         [0.626, 0.635   color red  0.000  green  0.000  blue  0.000  filter  0.004
                         color red  0.000  green  0.000  blue  0.000  filter  0.004]
         [0.635, 0.843   color red  0.000  green  0.000  blue  0.000  filter  0.004
                         color red  0.545  green  0.349  blue  0.247  filter  1.000]
         [0.843, 1       color red  0.545  green  0.349  blue  0.247  filter  1.000
                         color red  0.545  green  0.349  blue  0.247  filter  1.000]
      }
      scale <0.5, 0.5, 1>
      translate <10, 0, 0>
   }
   finish {
      ambient 0.5
      diffuse 0.8
   }
}
 
//
//   Sandalwood ( makes a great burled maple, too)
//
#declare Sandalwood = texture {
   pigment {
      bozo
      turbulence 0.2
      color_map {
         [0.000, 0.171   color red  0.725  green  0.659  blue  0.455  filter  0.000
                         color red  0.682  green  0.549  blue  0.420  filter  0.000]
         [0.171, 0.274   color red  0.682  green  0.549  blue  0.420  filter  0.000
                         color red  0.557  green  0.451  blue  0.322  filter  0.000]
         [0.274, 0.393   color red  0.557  green  0.451  blue  0.322  filter  0.000
                         color red  0.725  green  0.659  blue  0.455  filter  0.000]
         [0.393, 0.564   color red  0.725  green  0.659  blue  0.455  filter  0.000
                         color red  0.682  green  0.549  blue  0.420  filter  0.000]
         [0.564, 0.701   color red  0.682  green  0.549  blue  0.420  filter  0.000
                         color red  0.482  green  0.392  blue  0.278  filter  0.000]
         [0.701, 1       color red  0.482  green  0.392  blue  0.278  filter  0.000
                         color red  0.725  green  0.659  blue  0.455  filter  0.000]
      }
      scale <0.2, 0.2, 1>
      scale 2
   }
}
// Sandalwood layer 2
texture {
   pigment {
      bozo
      turbulence 0.8
      color_map {
         [0.000, 0.087   color red  0.682  green  0.604  blue  0.380  filter  1.000
                         color red  0.761  green  0.694  blue  0.600  filter  0.020]
         [0.087, 0.226   color red  0.761  green  0.694  blue  0.600  filter  0.020
                         color red  0.635  green  0.553  blue  0.325  filter  1.000]
         [0.226, 0.348   color red  0.635  green  0.553  blue  0.325  filter  1.000
                         color red  0.761  green  0.694  blue  0.600  filter  0.020]
         [0.348, 0.496   color red  0.761  green  0.694  blue  0.600  filter  0.020
                         color red  0.682  green  0.604  blue  0.380  filter  1.000]
         [0.496, 0.565   color red  0.682  green  0.604  blue  0.380  filter  1.000
                         color red  0.761  green  0.694  blue  0.600  filter  0.020]
         [0.565, 0.661   color red  0.761  green  0.694  blue  0.600  filter  0.020
                         color red  0.682  green  0.604  blue  0.380  filter  1.000]
         [0.661, 0.835   color red  0.682  green  0.604  blue  0.380  filter  1.000
                         color red  0.761  green  0.694  blue  0.600  filter  0.020]
         [0.835, 1       color red  0.761  green  0.694  blue  0.600  filter  0.020
                         color red  0.682  green  0.604  blue  0.380  filter  1.000]
      }
      scale 0.2
      scale 2
   }
}
//#macro object_mesh() wire_mesh(0.01) #end //spike_mesh_test(0,0)  #end
//object{ read_mesh("cow.pcm") translate<62,-34.5,14> scale 0.025 texture{Aluminum}}
 
//parse_mesh3("cow.pcm",2.809)
 
#macro DomeArray(Longitudinal_Segments, Latitudinal_Segments, Radius, fp_seed, min_dim, max_dim, light_color, DomeFileName)
   #fopen NewFile DomeFileName write 
   #local num_lights=Longitudinal_Segments*Latitudinal_Segments+1;
   #local light_cnt=1;
   #local neg_chance=0.1;
   #local fp=seed(fp_seed);
   #local lb=1;
   #while (light_cnt < num_lights)
      #local latitude=int(((light_cnt-1)/Latitudinal_Segments)+1);
      #local longitude=light_cnt-(Latitudinal_Segments*int((light_cnt-1)/Latitudinal_Segments));
      #local long_light_adj=min_dim+(max_dim-min_dim)*abs((0.5-(longitude/Latitudinal_Segments)));
      #local theta=(360/Longitudinal_Segments)*(light_cnt-1);
      #local thetaone=(90/Latitudinal_Segments)*int((light_cnt-1)/Longitudinal_Segments);
      #local X=(Radius*cos(radians(thetaone)))*cos(radians(theta));
      #local Y=Radius*sin(radians(thetaone));
      #local Z=(Radius*cos(radians(thetaone)))*sin(radians(theta));
      #debug concat(str(latitude,4,4), " ", str(longitude,4,4), "\n")
      #write (NewFile, "light_source{<", X, ", ", Y, ",", Z, "> color ", light_color, "*", #if (rand(fp) <= neg_chance) -long_light_adj #else long_light_adj #end, " shadowless fade_distance ", Radius/(Radius*0.7+rand(fp)), " fade_power 2}", "\n")
      #local light_cnt=light_cnt+1; 
   #end
   #write (NewFile, "light_source{<0, ", Radius, ", 0> color ", light_color, "*", max_dim, " shadowless fade_distance ", Radius/(Radius*0.7+rand(fp)), " fade_power 2}", "\n")
#end
 
//DomeArray(16,12,10,692874,0, 1.75, "sunlight", "LightArray.inc")
 
#declare pawn = union {
   difference {
      object { Disk_Y scale <8, 12.7468, 8> }
      quartic {
         < 1.0,  0.0,  0.0,   0.0,    2.0,  0.0,  0.0,  2.0,  0.0,-738.0,
         0.0,  0.0,  0.0,   0.0,    0.0,  0.0,  0.0,  0.0,  0.0,   0.0,
         1.0,  0.0,  0.0,   2.0,    0.0, 162.0,  0.0,  0.0,  0.0,   0.0,
         1.0,   0.0, -738.0,   0.0,   6561.0>
         sturm
      }
   }
 
   quartic {
      < 1.0,  0.0,  0.0,   0.0,    2.0,  0.0,  0.0,  2.0,  0.0, -132.5,
      0.0,  0.0,  0.0,   0.0,    0.0,  0.0,  0.0,  0.0,  0.0,   0.0,
      1.0,  0.0,  0.0,   2.0,    0.0, 123.5,  0.0,  0.0,  0.0,   0.0,
      1.0,  0.0, -132.5,  0.0,  3813.0625 >
      sturm
      translate -11.2468*y
   }
 
   quartic {
      < 1.0,  0.0,  0.0,   0.0,    2.0,  0.0,  0.0,  2.0,  0.0, -132.5,
      0.0,  0.0,  0.0,   0.0,    0.0,  0.0,  0.0,  0.0,  0.0,   0.0,
      1.0,  0.0,  0.0,   2.0,    0.0, 123.5,  0.0,  0.0,  0.0,   0.0,
      1.0,  0.0, -132.5,  0.0,  3813.0625>
      sturm
      translate 11.2468*y
   }
 
   //   Base
   intersection {
      object { Disk_Y
         scale <12, 3, 12>
         translate -15.7468*y
      }
      object { QCone_Y
         translate -2*y
      }
   }
 
   //   Ball on top
   sphere { <0, 17.7468, 0>, 7 }
 
   bounded_by { object { Disk_Y scale <14, 26, 14> } }
 
   translate 18.7468*y
   scale 0.06
}
 

object { pawn
   texture {
      Yellow_Pine 
      normal{ granite 0.3 scale <0.3, 2, 0.3> }
      finish { phong 0.8 }
   }
 
   rotate 60*y rotate 20*x
   translate <0,0,0>
}            
 
object{da1 scale 1 rotate<70,0,0> rotate<0,-80,0>} 
           
 
// create a box that extends between the 2 specified points
box
{
  <-5, -1, -5>  // one corner position <X1 Y1 Z1>
  < 5,  0,  5>  // other corner position <X2 Y2 Z2>
     texture {
      Rosewood 
      finish { phong 0.8 reflection 0.35}
   }
   rotate 60*y rotate 20*x
   translate <0,0,0>   
}
 
 
 
camera { location <0,.2,5>
         look_at  <0,1,0>   
         aperture 0.15
         focal_point <0,1,0>
         blur_samples 100
}
 
 
 
/*
light_source{
 <-4000,9000,5000>
 sunlight*0.75
 fade_distance 10000
 fade_power 2
}  */          