// *****************************************
// **   3-Point-Lighting for POV-Ray3.5   **
// **        Non-Radiosity Version        **
// **                                     **
// **            2003 Hugo Asm            **
// **                                     **
// **     feel free to use and modify     **
// *****************************************

// *****************************************
// **   file contains an internal macro   **
// **                                     **
// **     it sets up an area of light     **
// ** mixing area_lights with real lights **
// **     and makes the area visible,     **
// **       at least in reflections       **
// *****************************************


#macro Light_Panel( Panel_Size, Light_Strength ) 


	// Default user settings
		#ifndef (Reflections_Only)	#local Reflections_Only=     false;	#end

		#ifndef (Panel_Ambience)	#local Panel_Ambience=     <1,1,1>;	#end
		#ifndef (Bulb_Amount)		#local Bulb_Amount=          <2,2>;	#end
		#ifndef (Panel_GlowSize)	#local Panel_GlowSize=Panel_Size/3;	#end

		#ifndef (Test_Condition)	#local Test_Condition=       false;	#end
	

	// Check for bad user data
		// Bulb_Amount
			#local Bulb_Amount=	<0,0,0>+Bulb_Amount; // Ensures variable is a vector type
			#local Bulb_Amount= <int(Bulb_Amount.x), int(Bulb_Amount.y),0>; // Prevent floats
	
			#if   (Bulb_Amount.x<2)	 #local Bulb_Amount= <2,Bulb_Amount.y,0>;  #end // Prevent too..
			#if   (Bulb_Amount.y<2)	 #local Bulb_Amount= <Bulb_Amount.x,2,0>;  #end // ..small values
                                                                          
		// Glow_Size
			#local Glow_Size= <0,0,0>+Panel_GlowSize; // Ensures variable is a vector type
			#local Glow_Size=
				<abs(Glow_Size.x),
				 abs(Glow_Size.y), 0>
			; // prevents negative values	

		// Light_Strength
			#local Light_Strength= <0,0,0>+Light_Strength; // Ensures variable is a vector type
			#local Light_Strength=
				<abs(Light_Strength.x),
				 abs(Light_Strength.y),
				 abs(Light_Strength.z)>
			; // prevents negative values	


	// Setup internal variables
		#local Xstep= Panel_Size.x / Bulb_Amount.x; // Distance between..
		#local Ystep= Panel_Size.y / Bulb_Amount.y; // ..each bulb
	
		#local Bulb_Strength= Light_Strength / (Bulb_Amount.x * Bulb_Amount.y);


	// If Test_Condition is true, make visible bulb spheres, otherwise light_sources
		#if (Test_Condition=true)
			#local Panel_Strength= .5; 
			#local Bulb_Size= .1;
			#local Bulb_Object=union {
				sphere { <-Xstep,-Ystep,0>*.25, Bulb_Size pigment { rgb .75 } finish { ambient 1 } }
				sphere { < Xstep, Ystep,0>*.25, Bulb_Size pigment { rgb .75 } finish { ambient 1 } }
				sphere { <-Xstep, Ystep,0>*.25, Bulb_Size pigment { rgb .75 } finish { ambient 1 } }
				sphere { < Xstep,-Ystep,0>*.25, Bulb_Size pigment { rgb .75 } finish { ambient 1 } }			
				sphere { 0, Bulb_Size pigment { rgb 1 } finish { ambient 1 } }
			};

		#else	
			// Define one bulb light
			#local Bulb_Object=light_source {
				0, Bulb_Strength
				fade_distance 1 fade_power 2
				area_light (Xstep*.5)*x, (Ystep*.5)*y, 2,2 adaptive 1 jitter		
			};
		#end


	// Create panel
		union {
			// Making the panel area visible unless Glow_Size is zero
				#if (Glow_Size.x!=0 & Glow_Size.y!=0)
					box { <-Xstep/2,-Ystep/2,-.1>, Panel_Size + <-Xstep/2,-Ystep/2,-1>
						pigment { rgb 1 }
						finish { ambient Panel_Ambience diffuse 0 }
					}
				// Left Glow
					box { <0,-Ystep/2,-.1>, <-1,Panel_Size.y-Ystep/2,-1>
						pigment { gradient -x pigment_map { [ 0 rgb 1 ] [ 1 rgbt <0,0,0,1> ] } }
						finish { ambient Panel_Ambience diffuse 0 }
						scale <Glow_Size.x,1,1> translate (-Xstep/2)*x
					}
				// Right Glow
					box { <0,-Ystep/2,-.1>, <1,Panel_Size.y-Ystep/2,-1>
						pigment { gradient x pigment_map { [ 0 rgb 1 ] [ 1 rgbt <0,0,0,1> ] } }
						finish { ambient Panel_Ambience diffuse 0 }
						scale <Glow_Size.x,1,1> translate (Panel_Size.x-Xstep/2)*x
					}
				// Top Glow
					box { <-Xstep/2,0,-.1>, <Panel_Size.x-Xstep/2,1,-1>
						pigment { gradient y pigment_map { [ 0 rgb 1 ] [ 1 rgbt <0,0,0,1> ] } }
						finish { ambient Panel_Ambience diffuse 0 }
						scale <1,Glow_Size.y,1> translate (Panel_Size.y-Ystep/2)*y
					}
				// Buttom Glow
					box { <-Xstep/2,0,-.1>, <Panel_Size.x-Xstep/2,-1,-1>
						pigment { gradient -y pigment_map { [ 0 rgb 1 ] [ 1 rgbt <0,0,0,1> ] } }
						finish { ambient Panel_Ambience diffuse 0 }
						scale <1,Glow_Size.y,1> translate (-Ystep/2)*y
					}
				// The 4 edges Glow
					box { <0,0,-.1>, <-1,-1,-1>
						pigment { cylindrical pigment_map { [ 0 rgbt <0,0,0,1> ] [ 1 rgb 1 ] } rotate 90*x }
						finish { ambient Panel_Ambience diffuse 0 }
						scale <Glow_Size.x,Glow_Size.y,1>
						translate <-Xstep/2, -Ystep/2,0>
					}
					box { <0,0,-.1>, <1,-1,-1>
						pigment { cylindrical pigment_map { [ 0 rgbt <0,0,0,1> ] [ 1 rgb 1 ] } rotate 90*x }
						finish { ambient Panel_Ambience diffuse 0 }
						scale <Glow_Size.x,Glow_Size.y,1>
						translate <Panel_Size.x-Xstep/2, -Ystep/2,0>
					}
					box { <0,0,-.1>, <-1,1,-1>
						pigment { cylindrical pigment_map { [ 0 rgbt <0,0,0,1> ] [ 1 rgb 1 ] } rotate 90*x }
						finish { ambient Panel_Ambience diffuse 0 }
						scale <Glow_Size.x,Glow_Size.y,1>
						translate <-Xstep/2,Panel_Size.y-Ystep/2,0>
					}
					box { <0,0,-.1>, <1,1,-1>
						pigment { cylindrical pigment_map { [ 0 rgbt <0,0,0,1> ] [ 1 rgb 1 ] } rotate 90*x }
						finish { ambient Panel_Ambience diffuse 0 }
						scale <Glow_Size.x,Glow_Size.y,1>
						translate <Panel_Size.x-Xstep/2,Panel_Size.y-Ystep/2,0>
					}
                #end
	
			#local Xcnt=0;
			#while (Xcnt<Panel_Size.x)
				#local Ycnt=0;
				#while (Ycnt<Panel_Size.y)
					object { Bulb_Object translate <Xcnt,Ycnt,0> }
					#local Ycnt=Ycnt+Ystep;
				#end
				#local Xcnt=Xcnt+Xstep;
			#end
			
			// centering
			translate (-<Xcnt,Ycnt,0>*.5) + <Xstep,Ystep,0>*.5

			#if (Reflections_Only=true)
				no_image
			#end
		}
	// returns object from macro
#end


// Test the look
// camera { orthographic location -12*z look_at 0 }
// #local Test_Condition = true; // also try: false
// Light_Panel( <8,8>,1 )