// *****************************************
// **   3-Point-Lighting for POV-Ray3.5   **
// **        Non-Radiosity Version        **
// **                                     **
// **            2003 Hugo Asm            **
// **                                     **
// **     feel free to use and modify     **
// *****************************************

// *****************************************
// **    this file contains an object     **
// **           "Sphere Cube"             **
// **      along with it's material       **
// *****************************************


// White material
#local Blur_Strength = .3; // Blurred reflections

#local White_Material=material {
	texture {
		pigment { rgb .25 }
		finish { reflection .112 ambient 0 }

		#if (Blur_Strength>0)
			normal { bumps Blur_Strength scale .0000001 }
		#end
	}
};



// Cube of Spheres
union {
	#local Array=array[32] {
		<1,1,1>,<2,1,1>,<3,1,1>,<4,1,1>,<5,1,1>,<6,1,1>
		<1,1,2>,<2,1,2>,<3,1,2>,<4,1,2>,<5,1,2>,<6,1,2>
		<1,1,3>,<2,1,3>,                <5,1,3>,<6,1,3>
		<1,1,4>,<2,1,4>,                <5,1,4>,<6,1,4>
		<1,1,5>,<2,1,5>,<3,1,5>,<4,1,5>,<5,1,5>,<6,1,5>
		<1,1,6>,<2,1,6>,<3,1,6>,<4,1,6>,<5,1,6>,<6,1,6>
	};
			
	#local Make_Rows=6;
	#while (Make_Rows >0)

		#local Count=dimension_size(Array,1)-1;
		#while (Count >-1)
			sphere { Array[Count] + <0,Make_Rows-1,0>,.5 }
			#local Count=Count-1;
		#end

		#local Make_Rows=Make_Rows-1;
	#end
	translate -3 // centering
	rotate 90*x translate 1*y

	material { White_Material }
}