// *****************************************
// **   3-Point-Lighting for MegaPOV1.0   **
// **        Non-Radiosity Version        **
// **                                     **
// **            2003 Hugo Asm            **
// **                                     **
// **     feel free to use and modify     **
// *****************************************

// *****************************************
// **       this is the main file         **
// **                                     **
// **   it sets general parameters and    **
// ** #include the light, objects and cam **
// *****************************************


// Quality 1 = fast preview
// Quality 2 = final render

#declare RenderQuality = 1;


// Camera setup (these variables must be declared first)
#declare Cam_Location = <-4.6,3.7,-9>*2.5;
#declare Cam_Lookat = <.3,.2,0>;
#declare Cam_Angle = 36;


// Turn on/off lights

#declare KeyLight =   on;
#declare FillLight =  on;
#declare BackLight =  on;
#declare ExtraLight = on;


// Position lights
// Note: The rest of parameters regarding light, such as
//       strength, size and distance is found in "3PL_Light.inc"

// -- following feature not yet implemented --
//#declare Lights_PointAt   = Cam_Lookat;   // Follow the camera
//#declare Lights_OffCenter = Cam_Location;

#declare KeyLight_Elevation   = 30;
#declare KeyLight_Angle       = 60;

#declare FillLight_Elevation  = 20;
#declare FillLight_Angle      =-40;

#declare BackLight_Elevation  = 23;
#declare BackLight_Angle      =180;

// Ambient helper light; Follows the camera
#declare ExtraLight_Position = <Cam_Location.x,0,Cam_Location.z>*2;


// Dynamic Range Compression; you need MegaPOV1.0 or above.
// Especially useful when combined with radiosity!
// Uncommenting makes everything compatible with POV-Ray3.5
#declare Exposure = .15; // Compression factor
#declare Exposure_Gain = 30;


// Include objects, light & camera
#include "3PL_SphereCube.inc"
#include "3PL_GroundPlane.inc"

#include "3PL_Light.inc"

#include "3PL_Camera.inc"
