// *****************************************
// **   3-Point-Lighting for POV-Ray3.5   **
// **        Non-Radiosity Version        **
// **                                     **
// **            2003 Hugo Asm            **
// **                                     **
// **     feel free to use and modify     **
// *****************************************

// *****************************************
// **      this file sets up light        **
// **  and #include the panel_macro for   **
// **     setting up areas of light       **
// *****************************************

#include "3PL_lpanel_macro.inc"

#if (KeyLight=on)

	#declare Panel_Ambience = .6;
	#declare Panel_GlowSize = 30;

	#local LPanel = Light_Panel(
		<30,50>		// Panel Size
		1600		// Light Strength
	);
	
	object { LPanel rotate <KeyLight_Elevation,KeyLight_Angle,0>
		translate vrotate (Cam_Location*2,<KeyLight_Elevation,KeyLight_Angle,0>)
	}
#end



#if (FillLight=on)

	#declare Panel_Ambience = .05;
	#declare Panel_GlowSize = 30;
	#local LPanel = Light_Panel(
		<50,35>		// Panel Size
		80			// Light Strength
	);
	
	object { LPanel rotate <FillLight_Elevation,FillLight_Angle,0>
		translate vrotate (Cam_Location,<FillLight_Elevation,FillLight_Angle,0>)
	}
#end



#if (BackLight=on)

	#declare Panel_Ambience = .5;
	#declare Panel_GlowSize = 10;
	#local LPanel = Light_Panel(
		<50,50>		// Panel Size
		800*3		// Light Strength
	);
	
	object { LPanel rotate <BackLight_Elevation  *2   ,BackLight_Angle,0>
		translate vrotate (Cam_Location*2,<BackLight_Elevation,BackLight_Angle,0>)
	}
#end



// Ambient helper light
#if (ExtraLight=on)
	light_source { ExtraLight_Position , 80 fade_distance 1 fade_power 2 }
#end
