// *****************************************
// **   3-Point-Lighting for MegaPOV1.0   **
// **        Non-Radiosity Version        **
// **                                     **
// **            2003 Hugo Asm            **
// **                                     **
// **     feel free to use and modify     **
// *****************************************

// *****************************************
// **    this file sets up the camera     **
// ** and focal_blur, and global_settings **
// *****************************************


// Camera & Focal Blur
camera { right  image_height/image_width // Automatic Aspect Ratio
	location Cam_Location look_at Cam_Lookat angle Cam_Angle
		
	#if (RenderQuality = 2)
		aperture .35 blur_samples 38 // more blur_sampels = less grainy

		variance .00001 confidence .90
		focal_point Cam_Lookat
	#end
}


global_settings { adc_bailout 1/64 max_trace_level 3 assumed_gamma 1

	#ifdef (Exposure)
		#version unofficial megapov 1.0;

		exposure Exposure		    // Amount of compression
		exposure_gain Exposure_Gain	// Amount of gain
	#end
}
