// Persistence of Vision Raytracer Version 3.5 SDL File.
// Title 	:	chain.inc
// Version	:	0.1.0 alpha Serial (030804)
// Author	:	Peter Ketting

#version 3.5;

#ifndef (CHAIN)
#declare CHAIN = true;

#ifndef (MATH)
#include "math.inc"
#declare MATH = true;
#end

#ifndef (MATERIALS)
#include "materials.inc"
#end


#declare CHN_OUTERPLATE = 0;
#declare CHN_INNERPLATE = 1;

#declare CHN_LINKPLACEDBEFORE = CHN_INNERPLATE;					// Force start with OuterPlate.
#declare CHN_LINKNEXTPOSITION = <0, 0, 0>;						// Start chain at origin by default.
#declare CHN_LINKSCALE = <1, 1, 1>;								// No scaling by default.
#declare CHN_ROTATIONVALUE = 175;								// Used to calculate rotations.


#declare chn_Plate = object {
	difference {
		merge {
			cylinder { <-1.5, 0, 0>, <-1.5, 0, .1>, 1 }
			cylinder { <1.5, 0, 0>, <1.5, 0, .1>, 1 }
			box { <-1.5, -.8, 0>, <1.5, .8, .1> }
		}
		cylinder { <0, 2, -.5>, <0, 2, .5>, 1.5 }
		cylinder { <0, -2, -.5>, <0, -2, .5>, 1.5 }
	}
}

#declare chn_Pin = object {
	cylinder { <0, 0, 0>, <0, 0, 1.7>, .3 }
	translate -.1 * z
	material { Copper }
}

#declare chn_OuterPlate = object {
	union {
		object { chn_Plate }
		object { chn_Plate translate 1.4 * z }
		cylinder { <1.5, 0, .1>, <1.5, 0, 1.4>, .9 }
#ifndef (DEBUG)
		object { chn_Pin translate -1.5 * x}
		object { chn_Pin translate 1.5 * x }
#end // DEBUG
	}
	translate <1.5, 0, -.75>
	material { BlackChrome }
}	

#declare chn_InnerPlate = object {
	union {
		object { chn_Plate translate .1 * z }
		object { chn_Plate translate 1.2 * z }
		object {
			cylinder { <1.5, 0, .2>, <1.5, 0, 1.3>, .9 }
			material { BlackChrome }
		}
	}
	translate <1.5 , 0, -.7>
	material { DarkChrome }
}

#macro chn_SetScale (Scale)
//
// Set the scale factor of the chain.
//
	#declare CHN_LINKSCALE = Scale;
#end

#macro chn_SetStartLocation (Location)
//
// Set the starting location of the chain.
//
	#declare CHN_LINKNEXTPOSITION = Location;
#end

#macro chn_PlaceLink (Rotation)
//
// Place another link in the chain. There is no need to give destination
// coordinates, since the code keeps track of the next position in the link.
// 
// Parameter:
//
//		Rotation : Z rotation only.
//
	#local NewPosition = <0, 0, 0>;
	#switch (CHN_LINKPLACEDBEFORE)
		#case (CHN_INNERPLATE)
			object {
				chn_OuterPlate
				scale CHN_LINKSCALE
				rotate Rotation * z
				translate CHN_LINKNEXTPOSITION
			}
			// Switch plates for the next link.
			#declare CHN_LINKPLACEDBEFORE = CHN_OUTERPLATE;
		#break
		#case (CHN_OUTERPLATE)
#ifndef (DEBUG)
			object {
				chn_InnerPlate
				scale CHN_LINKSCALE
				rotate Rotation * z
				translate CHN_LINKNEXTPOSITION
			}
#end // DEBUG
			// Switch plates for the next link.
			#declare CHN_LINKPLACEDBEFORE = CHN_INNERPLATE;
		#break
	#end
	// Calculate next position.
	#declare NewPosition = vrotate (3 * x, Rotation * z);
	#declare CHN_LINKNEXTPOSITION = CHN_LINKNEXTPOSITION + NewPosition * CHN_LINKSCALE;
#end

#macro chn_CreateChain (LeftPosition, LeftRadius, RightPosition, RightRadius, Scale)
//
// Create a continuous chain around two circles with variable radius.
//
// Parameters:
//
//		LeftPosition	:	Location of circle on the left.
//		LeftRadius	  	:	Radius of left circle.
//		RightPosition	:	Location of circle on the right.
//		RightRadius	  	:	Radius of right circle.
//		Scale			:	Size of chain links.
//
	chn_SetScale (Scale)
	#local LeftDiameter = LeftRadius * 2;
	#local RightDiameter = RightRadius * 2;
	#local LeftTop = LeftPosition + (LeftRadius * y);
	#local RightTop = RightPosition + (RightRadius * y);
	#local RightBottom = RightPosition - (RightRadius * y);
	#local LeftBottom = LeftPosition - (LeftRadius * y);
	#local LinkSize = 3 * CHN_LINKSCALE;
	chn_SetStartLocation (LeftTop)			// Start on the top of the left circle.
	merge {
		// Create the top part of the chain.
		#local ChainAngle = VAngleD (<RightPosition.x + (-(LeftPosition.x)), LeftTop.y, 0>,
									<RightPosition.x + (- (LeftPosition.x)), RightTop.y, 0>);
		#while (CHN_LINKNEXTPOSITION.x < RightPosition.x)
			chn_PlaceLink (ChainAngle)
		#end
		// Create the right side of the chain.
		#local Rotation = CHN_ROTATIONVALUE / RightRadius * CHN_LINKSCALE;
		#local ThisRotation = Rotation;
		#while (ThisRotation < 180)
			chn_PlaceLink (360 - ThisRotation)
			#local ThisRotation = ThisRotation + Rotation;
		#end
		// Create the bottom part of the chain.
		#local ChainAngle = VAngleD (<LeftPosition.x - RightPosition.x, RightBottom.y, 0>,
									<LeftPosition.x - RightPosition.x, LeftBottom.y, 0>);
		#while (CHN_LINKNEXTPOSITION.x > LeftPosition.x)
			chn_PlaceLink (180 - ChainAngle)
		#end
		// Create the left part of the chain.
		#local Rotation = CHN_ROTATIONVALUE / LeftRadius * CHN_LINKSCALE;
		#local ThisRotation = Rotation;
		#while (ThisRotation < 180)
			chn_PlaceLink (180 - ThisRotation)
			#local ThisRotation = ThisRotation + Rotation;
		#end
		
	}
#end


#end // CHAIN
