//  Persistence of Vision Raytracer V3.5
//  World definition file.
//
//  Contains 2 lights, 3 materials and 15 primitives.
//
//  This file was generated for POV-Ray V3.5 by
//  Moray V3.5 For Windows Copyright (c) 1993-2003 Lutz + Kretzschmar
//

//  Date : 08/01/2003    (01.08.2003)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray V3.5 For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  noise_generator 2
  charset ascii
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera Camera01
  location  <     -2.596,     -17.159,      13.626>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.35783,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         39.60000    // Vertical      29.700
  look_at   <      0.000,       0.000,       0.576>
}


//
// *******  L I G H T S *******
//

light_source {   // Light001
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  translate  <-26.445096, -17.474272, 62.317968>
}

light_source {   // Light002
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  shadowless
  translate  <40.774415, 63.802442, 67.478696>
}


//
// ********  MATERIALS  *******
//

#include "nut02a.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare Seg01 = intersection {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <1.0, 1.732, 1.0>
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    rotate -0.0*z
    translate  1.0*x
    photons {
      collect off
    }
    scale <1.0, 2.25, 1.1>
    rotate -30.0*z
  }
  rotate -0.0*z
  translate  <-1.0, -1.732, 0.0>
  photons {
    collect off
  }
}
#declare Face01 = union {
  object { Seg01 }
  object { // Seg02 -> Seg01
    Seg01
    photons {
      collect off
    }
    rotate <180.0, 0.0, 180.0>
  }
  photons {
    collect off
  }
}
#declare Hex = union {
  object { Face01 }
  object { // Face02 -> Face01
    Face01
    photons {
      collect off
    }
    rotate -60.0*z
  }
  object { // Face03 -> Face01
    Face01
    photons {
      collect off
    }
    rotate -120.0*z
  }
  object { // Face04 -> Face01
    Face01
    photons {
      collect off
    }
    rotate 180.0*z
  }
  object { // Face05 -> Face01
    Face01
    photons {
      collect off
    }
    rotate 120.0*z
  }
  object { // Face06 -> Face01
    Face01
    photons {
      collect off
    }
    rotate 60.0*z
  }
  photons {
    collect off
  }
}
#declare Top = intersection {
  object { Hex }
  cone { // Cone001
    <0,0,0>, 0.85, <0,0,1>, 1.0
    photons {
      collect off
    }
    scale <4.2, 4.2, 1.0>
    rotate -180.0*y
    translate  1.01*z
  }
  photons {
    collect off
  }
  translate  -0.009905*z
}




//
// ********  OBJECTS  *******
//

#declare Nut_Body = merge {
  object { Top }
  object { // Body -> Hex
    Hex
    photons {
      collect off
    }
    translate  -0.999905*z
  }
  object { // Bottom -> Top
    Top
    photons {
      collect off
    }
    rotate <-180.0, 0.0, -180.0>
    translate  -1.999779*z
  }
  translate  <-0.022613, 0.0, 0.994964>
  material {
    Brass_Texture1
  }
  photons {
    collect off
  }
  translate  <0.045226, 0.0, 2.057767>
}
difference { // Nut
  object { Nut_Body }
  cylinder { // Inside_Thread
    <0,0,1>, <0,0,0>, 1 
    material {
      Brass_Texture1_Thread
    }
    hollow
    scale <2.0, 2.0, 4.4>
    translate  -0.1*z
  }
}


plane { // Plane001
  z,0
  material {
    Grey
  }
}






