// Macro to interpolate two sets of MESH2 data.
// Version 1.0 by Hugo Asm for POV3.5
// May 2003. Freeware.

#macro Interpolate_Mesh2( Percent )

	#local Opposite_Percent= 1-Percent;

	#ifndef (Number_of_Normals) #local Number_of_Normals=1; #end

	// Interpolate data
	#local New_Vertices=array[ Number_of_Vertices ];
	#local New_Normals=array[ Number_of_Normals ];
	
	#local Count=0;
	#local Count_Ends=Number_of_Vertices;
			
	#while( Count < Count_Ends )	

		#local New_Vertices[Count]=
			  KeyFrame1_Vertices[Count] * Percent
			+ KeyFrame2_Vertices[Count] * Opposite_Percent;

		#if (Number_of_Normals > 1)
			#local New_Normals[Count]=
				  KeyFrame1_Normals[Count]  * Percent
				+ KeyFrame2_Normals[Count]  * Opposite_Percent;
		#end

		#local Count=Count+1;
	#end

	// Data ready!
	// Create new object
	mesh2 {

		// Paste vertices
		vertex_vectors { Number_of_Vertices

			#local Count=0;
			#local Count_End=Number_of_Vertices;

			#while( Count < Count_End )	
				New_Vertices[Count]			
				#local Count=Count+1;
			#end
		}

		// Paste normals if present
		#if (Number_of_Normals > 1)				

			normal_vectors { Number_of_Normals

				#local Count=0;
				#local Count_End=Number_of_Normals;
	
				#while( Count < Count_End )		
					New_Normals[Count]
					#local Count=Count+1;
				#end
			}
		#end

		// Paste faces
		face_indices { Number_of_Faces

			#local Count=0;
			#local Count_End=Number_of_Faces;

			#while( Count < Count_End )	
				KeyFrame_Faces[Count]			
				#local Count=Count+1;
			#end
 		}
 
	}

// Returns with new object
#end 	