#include "shapes.inc"
#include "colors.inc"
#include "textures.inc"

// Put camera {} here...
// perspective (default) camera
camera {
  orthographic
  location  <0.0, 10, 0>
  look_at   <0.0, 0.0,  0.0>
  angle 45
}

// Put light_source {} here...
// create a regular point light source
light_source {
  0*x                  // light's position (translated below)
  color rgb <1,1,1> *1.2   // light's color
  translate <10, 20, 30>
}


light_source {
  0*x                  // light's position (translated below)
  color rgb <1,1,1> *1.2    // light's color
  translate <10, 20, -30>
}

#declare DxfObject =


union {
 // degenrate  triangle removed at input line 21

triangle{<0.677355, -0.134734, -0.117653>, <0.677355, -0.134734, -0.086056>, <0.677355, -0.134665, -0.086029>}

triangle{<0.677355, -0.134734, -0.117653>, <0.677355, -0.134665, -0.086029>, <0.677355, 0.199186, -0.086029>}

triangle{<0.677355, -0.134734, -0.117653>, <0.677355, 0.199186, -0.086029>, <0.677355, 0.199186, -0.117653>}

triangle{<0.677355, -0.134734, -0.086056>, <0.677355, -0.134734, -0.117653>, <0.677231, -0.135032, -0.117744>}

triangle{<0.677355, -0.134734, -0.086056>, <0.677231, -0.135032, -0.117744>, <0.574410, -0.383263, -0.117744>}

triangle{<0.677355, -0.134734, -0.086056>, <0.574410, -0.383263, -0.117744>, <0.574325, -0.383470, -0.117719>}

triangle{<0.677355, -0.134734, -0.086056>, <0.574325, -0.383470, -0.117719>, <0.574233, -0.383691, -0.117654>}

triangle{<0.677355, -0.134734, -0.086056>, <0.574233, -0.383691, -0.117654>, <0.574233, -0.383691, -0.086087>}

triangle{<0.677355, -0.134734, -0.086056>, <0.574233, -0.383691, -0.086087>, <0.574262, -0.383621, -0.086056>}

triangle{<0.574233, -0.383691, -0.086087>, <0.574233, -0.383691, -0.117654>, <0.383691, -0.574233, -0.117654>}

triangle{<0.574233, -0.383691, -0.086087>, <0.383691, -0.574233, -0.117654>, <0.383691, -0.574233, -0.086087>}

triangle{<0.383691, -0.574233, -0.086087>, <0.383691, -0.574233, -0.117654>, <0.383470, -0.574325, -0.117719>}

triangle{<0.383691, -0.574233, -0.086087>, <0.383470, -0.574325, -0.117719>, <0.383263, -0.574410, -0.117744>}

triangle{<0.383691, -0.574233, -0.086087>, <0.383263, -0.574410, -0.117744>, <0.135032, -0.677231, -0.117744>}

triangle{<0.383691, -0.574233, -0.086087>, <0.135032, -0.677231, -0.117744>, <0.134734, -0.677355, -0.117653>}

triangle{<0.383691, -0.574233, -0.086087>, <0.134734, -0.677355, -0.117653>, <0.134734, -0.677355, -0.086056>}

triangle{<0.383691, -0.574233, -0.086087>, <0.134734, -0.677355, -0.086056>, <0.383621, -0.574262, -0.086056>}

triangle{<0.134734, -0.677355, -0.086056>, <0.134734, -0.677355, -0.117653>, <-0.134734, -0.677355, -0.117653>}

triangle{<0.134734, -0.677355, -0.086056>, <-0.134734, -0.677355, -0.117653>, <-0.134734, -0.677355, -0.086056>}

triangle{<0.134734, -0.677355, -0.086056>, <-0.134734, -0.677355, -0.086056>, <-0.134665, -0.677355, -0.086029>}

triangle{<0.134734, -0.677355, -0.086056>, <-0.134665, -0.677355, -0.086029>, <0.134665, -0.677355, -0.086029>}

triangle{<-0.134734, -0.677355, -0.086056>, <-0.134734, -0.677355, -0.117653>, <-0.135032, -0.677231, -0.117744>}

triangle{<-0.134734, -0.677355, -0.086056>, <-0.135032, -0.677231, -0.117744>, <-0.383263, -0.574410, -0.117744>}

triangle{<-0.134734, -0.677355, -0.086056>, <-0.383263, -0.574410, -0.117744>, <-0.383470, -0.574325, -0.117719>}

triangle{<-0.134734, -0.677355, -0.086056>, <-0.383470, -0.574325, -0.117719>, <-0.383691, -0.574233, -0.117654>}

triangle{<-0.134734, -0.677355, -0.086056>, <-0.383691, -0.574233, -0.117654>, <-0.383691, -0.574233, -0.086087>}

triangle{<-0.134734, -0.677355, -0.086056>, <-0.383691, -0.574233, -0.086087>, <-0.383621, -0.574262, -0.086056>}

triangle{<-0.383691, -0.574233, -0.086087>, <-0.383691, -0.574233, -0.117654>, <-0.574233, -0.383691, -0.117654>}

triangle{<-0.383691, -0.574233, -0.086087>, <-0.574233, -0.383691, -0.117654>, <-0.574233, -0.383691, -0.086087>}

triangle{<-0.574233, -0.383691, -0.086087>, <-0.574233, -0.383691, -0.117654>, <-0.574325, -0.383470, -0.117719>}

triangle{<-0.574233, -0.383691, -0.086087>, <-0.574325, -0.383470, -0.117719>, <-0.574410, -0.383263, -0.117744>}

triangle{<-0.574233, -0.383691, -0.086087>, <-0.574410, -0.383263, -0.117744>, <-0.677231, -0.135032, -0.117744>}

triangle{<-0.574233, -0.383691, -0.086087>, <-0.677231, -0.135032, -0.117744>, <-0.677355, -0.134734, -0.117653>}

triangle{<-0.574233, -0.383691, -0.086087>, <-0.677355, -0.134734, -0.117653>, <-0.677355, -0.134734, -0.086056>}

triangle{<-0.574233, -0.383691, -0.086087>, <-0.677355, -0.134734, -0.086056>, <-0.574262, -0.383621, -0.086056>}

triangle{<-0.677355, -0.134734, -0.086056>, <-0.677355, -0.134734, -0.117653>, <-0.677355, 0.199186, -0.117653>}

triangle{<-0.677355, -0.134734, -0.086056>, <-0.677355, 0.199186, -0.117653>, <-0.677355, 0.199186, -0.086029>}

triangle{<-0.677355, -0.134734, -0.086056>, <-0.677355, 0.199186, -0.086029>, <-0.677355, -0.134665, -0.086029>}

triangle{<0.677355, 0.199186, -0.117653>, <0.677355, 0.199186, -0.086029>, <0.676436, 0.202614, -0.084853>}

triangle{<0.677355, 0.199186, -0.117653>, <0.676436, 0.202614, -0.084853>, <0.582725, 0.552349, -0.084853>}

triangle{<0.677355, 0.199186, -0.117653>, <0.582725, 0.552349, -0.084853>, <0.582699, 0.552444, -0.084881>}

triangle{<0.677355, 0.199186, -0.117653>, <0.582699, 0.552444, -0.084881>, <0.582699, 0.552444, -0.117087>}

triangle{<0.677355, 0.199186, -0.117653>, <0.582699, 0.552444, -0.117087>, <0.583404, 0.549813, -0.117652>}

triangle{<0.677355, 0.199186, -0.117653>, <0.583404, 0.549813, -0.117652>, <0.583716, 0.548651, -0.117737>}

triangle{<0.677355, 0.199186, -0.117653>, <0.583716, 0.548651, -0.117737>, <0.677241, 0.199610, -0.117737>}

triangle{<-0.677355, 0.199186, -0.086029>, <-0.677355, 0.199186, -0.117653>, <-0.677241, 0.199610, -0.117737>}

triangle{<-0.677355, 0.199186, -0.086029>, <-0.677241, 0.199610, -0.117737>, <-0.583716, 0.548651, -0.117737>}

triangle{<-0.677355, 0.199186, -0.086029>, <-0.583716, 0.548651, -0.117737>, <-0.583404, 0.549813, -0.117652>}

triangle{<-0.677355, 0.199186, -0.086029>, <-0.583404, 0.549813, -0.117652>, <-0.582699, 0.552444, -0.117087>}

triangle{<-0.677355, 0.199186, -0.086029>, <-0.582699, 0.552444, -0.117087>, <-0.582699, 0.552444, -0.084881>}

triangle{<-0.677355, 0.199186, -0.086029>, <-0.582699, 0.552444, -0.084881>, <-0.582725, 0.552349, -0.084853>}

triangle{<-0.677355, 0.199186, -0.086029>, <-0.582725, 0.552349, -0.084853>, <-0.676436, 0.202614, -0.084853>}

triangle{<0.582699, 0.552444, -0.117087>, <0.582699, 0.552444, -0.084881>, <0.375256, 0.862905, -0.084881>}

triangle{<0.582699, 0.552444, -0.117087>, <0.375256, 0.862905, -0.084881>, <0.375174, 0.863028, -0.084931>}

triangle{<0.582699, 0.552444, -0.117087>, <0.375174, 0.863028, -0.084931>, <0.375174, 0.863028, -0.117087>}

triangle{<-0.582699, 0.552444, -0.084881>, <-0.582699, 0.552444, -0.117087>, <-0.375174, 0.863028, -0.117087>}

triangle{<-0.582699, 0.552444, -0.084881>, <-0.375174, 0.863028, -0.117087>, <-0.375174, 0.863028, -0.084931>}

triangle{<-0.582699, 0.552444, -0.084881>, <-0.375174, 0.863028, -0.084931>, <-0.375256, 0.862905, -0.084881>}

triangle{<0.375174, 0.863028, -0.117087>, <0.375174, 0.863028, -0.084931>, <0.137931, 1.000000, -0.084931>}

triangle{<0.375174, 0.863028, -0.117087>, <0.137931, 1.000000, -0.084931>, <0.137931, 1.000000, -0.117463>}

triangle{<0.375174, 0.863028, -0.117087>, <0.137931, 1.000000, -0.117463>, <0.374032, 0.863687, -0.117463>}

triangle{<-0.375174, 0.863028, -0.084931>, <-0.375174, 0.863028, -0.117087>, <-0.374032, 0.863687, -0.117463>}

triangle{<-0.375174, 0.863028, -0.084931>, <-0.374032, 0.863687, -0.117463>, <-0.137931, 1.000000, -0.117463>}

triangle{<-0.375174, 0.863028, -0.084931>, <-0.137931, 1.000000, -0.117463>, <-0.137931, 1.000000, -0.084931>}

triangle{<0.137931, 1.000000, -0.117463>, <0.137931, 1.000000, -0.084931>, <0.137829, 1.000000, -0.084892>}

triangle{<0.137931, 1.000000, -0.117463>, <0.137829, 1.000000, -0.084892>, <-0.137829, 1.000000, -0.084892>}

triangle{<0.137931, 1.000000, -0.117463>, <-0.137829, 1.000000, -0.084892>, <-0.137931, 1.000000, -0.084931>}

triangle{<0.137931, 1.000000, -0.117463>, <-0.137931, 1.000000, -0.084931>, <-0.137931, 1.000000, -0.117463>}

triangle{<0.137931, 1.000000, -0.117463>, <-0.137931, 1.000000, -0.117463>, <-0.134413, 1.000000, -0.118332>}

triangle{<0.137931, 1.000000, -0.117463>, <-0.134413, 1.000000, -0.118332>, <0.134413, 1.000000, -0.118332>}

triangle{<-0.383621, -0.574262, -0.086056>, <-0.383691, -0.574233, -0.086087>, <-0.574233, -0.383691, -0.086087>}

triangle{<-0.383621, -0.574262, -0.086056>, <-0.574233, -0.383691, -0.086087>, <-0.574262, -0.383621, -0.086056>}

triangle{<-0.383621, -0.574262, -0.086056>, <-0.574262, -0.383621, -0.086056>, <-0.069710, -0.069709, 0.526803>}

triangle{<-0.383621, -0.574262, -0.086056>, <-0.069710, -0.069709, 0.526803>, <-0.069708, -0.069708, 0.526804>}

triangle{<-0.383621, -0.574262, -0.086056>, <-0.069708, -0.069708, 0.526804>, <-0.069709, -0.069710, 0.526803>}

triangle{<0.574262, -0.383621, -0.086056>, <0.574233, -0.383691, -0.086087>, <0.383691, -0.574233, -0.086087>}

triangle{<0.574262, -0.383621, -0.086056>, <0.383691, -0.574233, -0.086087>, <0.383621, -0.574262, -0.086056>}

triangle{<0.574262, -0.383621, -0.086056>, <0.383621, -0.574262, -0.086056>, <0.069709, -0.069710, 0.526803>}

triangle{<0.574262, -0.383621, -0.086056>, <0.069709, -0.069710, 0.526803>, <0.069708, -0.069708, 0.526804>}

triangle{<0.574262, -0.383621, -0.086056>, <0.069708, -0.069708, 0.526804>, <0.069710, -0.069709, 0.526803>}

triangle{<-0.574262, -0.383621, -0.086056>, <-0.677355, -0.134734, -0.086056>, <-0.677355, -0.134665, -0.086029>}

triangle{<-0.574262, -0.383621, -0.086056>, <-0.677355, -0.134665, -0.086029>, <-0.594506, -0.069600, 0.020013>}

triangle{<-0.574262, -0.383621, -0.086056>, <-0.594506, -0.069600, 0.020013>, <-0.069710, -0.069709, 0.526803>}

triangle{<-0.134665, -0.677355, -0.086029>, <-0.134734, -0.677355, -0.086056>, <-0.383621, -0.574262, -0.086056>}

triangle{<-0.134665, -0.677355, -0.086029>, <-0.383621, -0.574262, -0.086056>, <-0.069709, -0.069710, 0.526803>}

triangle{<-0.134665, -0.677355, -0.086029>, <-0.069709, -0.069710, 0.526803>, <-0.069600, -0.594506, 0.020013>}

triangle{<0.383621, -0.574262, -0.086056>, <0.134734, -0.677355, -0.086056>, <0.134665, -0.677355, -0.086029>}

triangle{<0.383621, -0.574262, -0.086056>, <0.134665, -0.677355, -0.086029>, <0.069600, -0.594506, 0.020013>}

triangle{<0.383621, -0.574262, -0.086056>, <0.069600, -0.594506, 0.020013>, <0.069709, -0.069710, 0.526803>}

triangle{<0.677355, -0.134665, -0.086029>, <0.677355, -0.134734, -0.086056>, <0.574262, -0.383621, -0.086056>}

triangle{<0.677355, -0.134665, -0.086029>, <0.574262, -0.383621, -0.086056>, <0.069710, -0.069709, 0.526803>}

triangle{<0.677355, -0.134665, -0.086029>, <0.069710, -0.069709, 0.526803>, <0.594506, -0.069600, 0.020013>}

triangle{<-0.677355, -0.134665, -0.086029>, <-0.677355, 0.199186, -0.086029>, <-0.676436, 0.202614, -0.084853>}

triangle{<-0.677355, -0.134665, -0.086029>, <-0.676436, 0.202614, -0.084853>, <-0.594506, 0.103070, 0.020013>}

triangle{<-0.677355, -0.134665, -0.086029>, <-0.594506, 0.103070, 0.020013>, <-0.594506, -0.069600, 0.020013>}

triangle{<0.134665, -0.677355, -0.086029>, <-0.134665, -0.677355, -0.086029>, <-0.069600, -0.594506, 0.020013>}

triangle{<0.134665, -0.677355, -0.086029>, <-0.069600, -0.594506, 0.020013>, <0.069600, -0.594506, 0.020013>}

triangle{<0.677355, 0.199186, -0.086029>, <0.677355, -0.134665, -0.086029>, <0.594506, -0.069600, 0.020013>}

triangle{<0.677355, 0.199186, -0.086029>, <0.594506, -0.069600, 0.020013>, <0.594506, 0.103070, 0.020013>}

triangle{<0.677355, 0.199186, -0.086029>, <0.594506, 0.103070, 0.020013>, <0.676436, 0.202614, -0.084853>}

triangle{<-0.676436, 0.202614, -0.084853>, <-0.582725, 0.552349, -0.084853>, <-0.069682, 0.103047, 0.526783>}

triangle{<-0.676436, 0.202614, -0.084853>, <-0.069682, 0.103047, 0.526783>, <-0.069608, 0.102867, 0.5269>}

triangle{<-0.676436, 0.202614, -0.084853>, <-0.069608, 0.102867, 0.5269>, <-0.594506, 0.103070, 0.020013>}

triangle{<0.582725, 0.552349, -0.084853>, <0.676436, 0.202614, -0.084853>, <0.594506, 0.103070, 0.020013>}

triangle{<0.582725, 0.552349, -0.084853>, <0.594506, 0.103070, 0.020013>, <0.069608, 0.102867, 0.5269>}

triangle{<0.582725, 0.552349, -0.084853>, <0.069608, 0.102867, 0.5269>, <0.069682, 0.103047, 0.526783>}

triangle{<-0.582725, 0.552349, -0.084853>, <-0.582699, 0.552444, -0.084881>, <-0.375256, 0.862905, -0.084881>}

triangle{<-0.582725, 0.552349, -0.084853>, <-0.375256, 0.862905, -0.084881>, <-0.069725, 0.103261, 0.526643>}

triangle{<-0.582725, 0.552349, -0.084853>, <-0.069725, 0.103261, 0.526643>, <-0.069682, 0.103047, 0.526783>}

triangle{<0.582699, 0.552444, -0.084881>, <0.582725, 0.552349, -0.084853>, <0.069682, 0.103047, 0.526783>}

triangle{<0.582699, 0.552444, -0.084881>, <0.069682, 0.103047, 0.526783>, <0.069725, 0.103261, 0.526643>}

triangle{<0.582699, 0.552444, -0.084881>, <0.069725, 0.103261, 0.526643>, <0.375256, 0.862905, -0.084881>}

triangle{<-0.375256, 0.862905, -0.084881>, <-0.375174, 0.863028, -0.084931>, <-0.137931, 1.000000, -0.084931>}

triangle{<-0.375256, 0.862905, -0.084881>, <-0.137931, 1.000000, -0.084931>, <-0.137829, 1.000000, -0.084892>}

triangle{<-0.375256, 0.862905, -0.084881>, <-0.137829, 1.000000, -0.084892>, <-0.069370, 0.880443, 0.019037>}

triangle{<-0.375256, 0.862905, -0.084881>, <-0.069370, 0.880443, 0.019037>, <-0.069725, 0.103261, 0.526643>}

triangle{<0.375174, 0.863028, -0.084931>, <0.375256, 0.862905, -0.084881>, <0.069725, 0.103261, 0.526643>}

triangle{<0.375174, 0.863028, -0.084931>, <0.069725, 0.103261, 0.526643>, <0.069370, 0.880443, 0.019037>}

triangle{<0.375174, 0.863028, -0.084931>, <0.069370, 0.880443, 0.019037>, <0.137829, 1.000000, -0.084892>}

triangle{<0.375174, 0.863028, -0.084931>, <0.137829, 1.000000, -0.084892>, <0.137931, 1.000000, -0.084931>}

triangle{<-0.137829, 1.000000, -0.084892>, <0.137829, 1.000000, -0.084892>, <0.069370, 0.880443, 0.019037>}

triangle{<-0.137829, 1.000000, -0.084892>, <0.069370, 0.880443, 0.019037>, <-0.069370, 0.880443, 0.019037>}

triangle{<-0.069608, 0.102867, 0.5269>, <-0.069682, 0.103047, 0.526783>, <-0.069725, 0.103261, 0.526643>}

triangle{<-0.069608, 0.102867, 0.5269>, <-0.069725, 0.103261, 0.526643>, <-0.069370, 0.880443, 0.019037>}

triangle{<-0.069608, 0.102867, 0.5269>, <-0.069370, 0.880443, 0.019037>, <0.069370, 0.880443, 0.019037>}

triangle{<-0.069608, 0.102867, 0.5269>, <0.069370, 0.880443, 0.019037>, <0.069725, 0.103261, 0.526643>}

triangle{<-0.069608, 0.102867, 0.5269>, <0.069725, 0.103261, 0.526643>, <0.069682, 0.103047, 0.526783>}

triangle{<-0.069608, 0.102867, 0.5269>, <0.069682, 0.103047, 0.526783>, <0.069608, 0.102867, 0.5269>}

triangle{<-0.069608, 0.102867, 0.5269>, <0.069608, 0.102867, 0.5269>, <0.000021, -0.000021, 0.5941>}

triangle{<-0.069608, 0.102867, 0.5269>, <0.000021, -0.000021, 0.5941>, <-0.000021, -0.000021, 0.5941>}

triangle{<-0.069708, -0.069708, 0.526804>, <-0.069710, -0.069709, 0.526803>, <-0.594506, -0.069600, 0.020013>}

triangle{<-0.069708, -0.069708, 0.526804>, <-0.594506, -0.069600, 0.020013>, <-0.594506, 0.103070, 0.020013>}

triangle{<-0.069708, -0.069708, 0.526804>, <-0.594506, 0.103070, 0.020013>, <-0.069608, 0.102867, 0.5269>}

triangle{<-0.069708, -0.069708, 0.526804>, <-0.069608, 0.102867, 0.5269>, <-0.000021, -0.000021, 0.5941>}

triangle{<-0.069709, -0.069710, 0.526803>, <-0.069708, -0.069708, 0.526804>, <-0.000021, -0.000021, 0.5941>}

triangle{<-0.069709, -0.069710, 0.526803>, <-0.000021, -0.000021, 0.5941>, <0.000021, -0.000021, 0.5941>}

triangle{<-0.069709, -0.069710, 0.526803>, <0.000021, -0.000021, 0.5941>, <0.069708, -0.069708, 0.526804>}

triangle{<-0.069709, -0.069710, 0.526803>, <0.069708, -0.069708, 0.526804>, <0.069709, -0.069710, 0.526803>}

triangle{<-0.069709, -0.069710, 0.526803>, <0.069709, -0.069710, 0.526803>, <0.069600, -0.594506, 0.020013>}

triangle{<-0.069709, -0.069710, 0.526803>, <0.069600, -0.594506, 0.020013>, <-0.069600, -0.594506, 0.020013>}

triangle{<0.069710, -0.069709, 0.526803>, <0.069708, -0.069708, 0.526804>, <0.000021, -0.000021, 0.5941>}

triangle{<0.069710, -0.069709, 0.526803>, <0.000021, -0.000021, 0.5941>, <0.069608, 0.102867, 0.5269>}

triangle{<0.069710, -0.069709, 0.526803>, <0.069608, 0.102867, 0.5269>, <0.594506, 0.103070, 0.020013>}

triangle{<0.069710, -0.069709, 0.526803>, <0.594506, 0.103070, 0.020013>, <0.594506, -0.069600, 0.020013>}

triangle{<0.677355, -0.134734, -0.117653>, <0.677355, 0.199186, -0.117653>, <0.677241, 0.199610, -0.117737>}

triangle{<0.677355, -0.134734, -0.117653>, <0.677241, 0.199610, -0.117737>, <0.483413, 0.101114, -0.259493>}

triangle{<0.677355, -0.134734, -0.117653>, <0.483413, 0.101114, -0.259493>, <0.482978, 0.100616, -0.259812>}

triangle{<0.677355, -0.134734, -0.117653>, <0.482978, 0.100616, -0.259812>, <0.482978, -0.068126, -0.259812>}

triangle{<0.677355, -0.134734, -0.117653>, <0.482978, -0.068126, -0.259812>, <0.483253, -0.068355, -0.25961>}

triangle{<0.677355, -0.134734, -0.117653>, <0.483253, -0.068355, -0.25961>, <0.677231, -0.135032, -0.117744>}

triangle{<0.134734, -0.677355, -0.117653>, <0.135032, -0.677231, -0.117744>, <0.068355, -0.483253, -0.25961>}

triangle{<0.134734, -0.677355, -0.117653>, <0.068355, -0.483253, -0.25961>, <0.068126, -0.482978, -0.259812>}

triangle{<0.134734, -0.677355, -0.117653>, <0.068126, -0.482978, -0.259812>, <-0.068126, -0.482978, -0.259812>}

triangle{<0.134734, -0.677355, -0.117653>, <-0.068126, -0.482978, -0.259812>, <-0.068355, -0.483253, -0.25961>}

triangle{<0.134734, -0.677355, -0.117653>, <-0.068355, -0.483253, -0.25961>, <-0.135032, -0.677231, -0.117744>}

triangle{<0.134734, -0.677355, -0.117653>, <-0.135032, -0.677231, -0.117744>, <-0.134734, -0.677355, -0.117653>}

triangle{<-0.677355, -0.134734, -0.117653>, <-0.677231, -0.135032, -0.117744>, <-0.483253, -0.068355, -0.25961>}

triangle{<-0.677355, -0.134734, -0.117653>, <-0.483253, -0.068355, -0.25961>, <-0.482978, -0.068126, -0.259812>}

triangle{<-0.677355, -0.134734, -0.117653>, <-0.482978, -0.068126, -0.259812>, <-0.482978, 0.100616, -0.259812>}

triangle{<-0.677355, -0.134734, -0.117653>, <-0.482978, 0.100616, -0.259812>, <-0.483413, 0.101114, -0.259493>}

triangle{<-0.677355, -0.134734, -0.117653>, <-0.483413, 0.101114, -0.259493>, <-0.677241, 0.199610, -0.117737>}

triangle{<-0.677355, -0.134734, -0.117653>, <-0.677241, 0.199610, -0.117737>, <-0.677355, 0.199186, -0.117653>}

triangle{<0.574410, -0.383263, -0.117744>, <0.677231, -0.135032, -0.117744>, <0.483253, -0.068355, -0.25961>}

triangle{<0.135032, -0.677231, -0.117744>, <0.383263, -0.574410, -0.117744>, <0.068355, -0.483253, -0.25961>}

triangle{<-0.383263, -0.574410, -0.117744>, <-0.135032, -0.677231, -0.117744>, <-0.068355, -0.483253, -0.25961>}

triangle{<-0.677231, -0.135032, -0.117744>, <-0.574410, -0.383263, -0.117744>, <-0.483253, -0.068355, -0.25961>}

triangle{<0.574233, -0.383691, -0.117654>, <0.574325, -0.383470, -0.117719>, <0.412064, -0.412064, -0.185062>}

triangle{<0.574233, -0.383691, -0.117654>, <0.412064, -0.412064, -0.185062>, <0.383470, -0.574325, -0.117719>}

triangle{<0.574233, -0.383691, -0.117654>, <0.383470, -0.574325, -0.117719>, <0.383691, -0.574233, -0.117654>}

triangle{<-0.383691, -0.574233, -0.117654>, <-0.383470, -0.574325, -0.117719>, <-0.412064, -0.412064, -0.185062>}

triangle{<-0.383691, -0.574233, -0.117654>, <-0.412064, -0.412064, -0.185062>, <-0.574325, -0.383470, -0.117719>}

triangle{<-0.383691, -0.574233, -0.117654>, <-0.574325, -0.383470, -0.117719>, <-0.574233, -0.383691, -0.117654>}

triangle{<0.677241, 0.199610, -0.117737>, <0.583716, 0.548651, -0.117737>, <0.483413, 0.101114, -0.259493>}

triangle{<-0.583716, 0.548651, -0.117737>, <-0.677241, 0.199610, -0.117737>, <-0.483413, 0.101114, -0.259493>}

triangle{<0.583404, 0.549813, -0.117652>, <0.582699, 0.552444, -0.117087>, <0.375174, 0.863028, -0.117087>}

triangle{<0.583404, 0.549813, -0.117652>, <0.375174, 0.863028, -0.117087>, <0.374032, 0.863687, -0.117463>}

triangle{<0.583404, 0.549813, -0.117652>, <0.374032, 0.863687, -0.117463>, <0.373854, 0.862934, -0.117829>}

triangle{<0.583404, 0.549813, -0.117652>, <0.373854, 0.862934, -0.117829>, <0.430334, 0.590781, -0.185187>}

triangle{<-0.582699, 0.552444, -0.117087>, <-0.583404, 0.549813, -0.117652>, <-0.430334, 0.590781, -0.185187>}

triangle{<-0.582699, 0.552444, -0.117087>, <-0.430334, 0.590781, -0.185187>, <-0.373854, 0.862934, -0.117829>}

triangle{<-0.582699, 0.552444, -0.117087>, <-0.373854, 0.862934, -0.117829>, <-0.374032, 0.863687, -0.117463>}

triangle{<-0.582699, 0.552444, -0.117087>, <-0.374032, 0.863687, -0.117463>, <-0.375174, 0.863028, -0.117087>}

triangle{<0.374032, 0.863687, -0.117463>, <0.137931, 1.000000, -0.117463>, <0.134413, 1.000000, -0.118332>}

triangle{<0.374032, 0.863687, -0.117463>, <0.134413, 1.000000, -0.118332>, <0.083607, 0.698841, -0.259726>}

triangle{<0.374032, 0.863687, -0.117463>, <0.083607, 0.698841, -0.259726>, <0.373854, 0.862934, -0.117829>}

triangle{<-0.137931, 1.000000, -0.117463>, <-0.374032, 0.863687, -0.117463>, <-0.373854, 0.862934, -0.117829>}

triangle{<-0.137931, 1.000000, -0.117463>, <-0.373854, 0.862934, -0.117829>, <-0.083607, 0.698841, -0.259726>}

triangle{<-0.137931, 1.000000, -0.117463>, <-0.083607, 0.698841, -0.259726>, <-0.134413, 1.000000, -0.118332>}

triangle{<0.134413, 1.000000, -0.118332>, <-0.134413, 1.000000, -0.118332>, <-0.083607, 0.698841, -0.259726>}

triangle{<0.134413, 1.000000, -0.118332>, <-0.083607, 0.698841, -0.259726>, <-0.083515, 0.698659, -0.259812>}

triangle{<0.134413, 1.000000, -0.118332>, <-0.083515, 0.698659, -0.259812>, <0.083515, 0.698659, -0.259812>}

triangle{<0.134413, 1.000000, -0.118332>, <0.083515, 0.698659, -0.259812>, <0.083607, 0.698841, -0.259726>}

triangle{<0.430334, 0.590781, -0.185187>, <0.373854, 0.862934, -0.117829>, <0.083607, 0.698841, -0.259726>}

triangle{<0.430334, 0.590781, -0.185187>, <0.083607, 0.698841, -0.259726>, <0.083515, 0.698659, -0.259812>}

triangle{<0.430334, 0.590781, -0.185187>, <0.083515, 0.698659, -0.259812>, <0.083544, 0.698629, -0.259812>}

triangle{<0.430334, 0.590781, -0.185187>, <0.083544, 0.698629, -0.259812>, <0.430307, 0.590735, -0.18521>}

triangle{<-0.373854, 0.862934, -0.117829>, <-0.430334, 0.590781, -0.185187>, <-0.430307, 0.590735, -0.18521>}

triangle{<-0.373854, 0.862934, -0.117829>, <-0.430307, 0.590735, -0.18521>, <-0.083544, 0.698629, -0.259812>}

triangle{<-0.373854, 0.862934, -0.117829>, <-0.083544, 0.698629, -0.259812>, <-0.083515, 0.698659, -0.259812>}

triangle{<-0.373854, 0.862934, -0.117829>, <-0.083515, 0.698659, -0.259812>, <-0.083607, 0.698841, -0.259726>}

triangle{<0.583716, 0.548651, -0.117737>, <0.583404, 0.549813, -0.117652>, <0.430334, 0.590781, -0.185187>}

triangle{<0.583716, 0.548651, -0.117737>, <0.430334, 0.590781, -0.185187>, <0.430307, 0.590735, -0.18521>}

triangle{<0.583716, 0.548651, -0.117737>, <0.430307, 0.590735, -0.18521>, <0.482740, 0.101191, -0.259812>}

triangle{<0.583716, 0.548651, -0.117737>, <0.482740, 0.101191, -0.259812>, <0.482978, 0.100616, -0.259812>}

triangle{<0.583716, 0.548651, -0.117737>, <0.482978, 0.100616, -0.259812>, <0.483413, 0.101114, -0.259493>}

triangle{<-0.583404, 0.549813, -0.117652>, <-0.583716, 0.548651, -0.117737>, <-0.483413, 0.101114, -0.259493>}

triangle{<-0.583404, 0.549813, -0.117652>, <-0.483413, 0.101114, -0.259493>, <-0.482978, 0.100616, -0.259812>}

triangle{<-0.583404, 0.549813, -0.117652>, <-0.482978, 0.100616, -0.259812>, <-0.482740, 0.101191, -0.259812>}

triangle{<-0.583404, 0.549813, -0.117652>, <-0.482740, 0.101191, -0.259812>, <-0.430307, 0.590735, -0.18521>}

triangle{<-0.583404, 0.549813, -0.117652>, <-0.430307, 0.590735, -0.18521>, <-0.430334, 0.590781, -0.185187>}

triangle{<0.430307, 0.590735, -0.18521>, <0.083544, 0.698629, -0.259812>, <0.482740, 0.101191, -0.259812>}

triangle{<-0.083544, 0.698629, -0.259812>, <-0.430307, 0.590735, -0.18521>, <-0.482740, 0.101191, -0.259812>}

triangle{<0.574325, -0.383470, -0.117719>, <0.574410, -0.383263, -0.117744>, <0.483253, -0.068355, -0.25961>}

triangle{<0.574325, -0.383470, -0.117719>, <0.483253, -0.068355, -0.25961>, <0.482978, -0.068126, -0.259812>}

triangle{<0.574325, -0.383470, -0.117719>, <0.482978, -0.068126, -0.259812>, <0.482852, -0.068313, -0.259812>}

triangle{<0.574325, -0.383470, -0.117719>, <0.482852, -0.068313, -0.259812>, <0.412061, -0.412061, -0.185065>}

triangle{<0.574325, -0.383470, -0.117719>, <0.412061, -0.412061, -0.185065>, <0.412064, -0.412064, -0.185062>}

triangle{<0.383263, -0.574410, -0.117744>, <0.383470, -0.574325, -0.117719>, <0.412064, -0.412064, -0.185062>}

triangle{<0.383263, -0.574410, -0.117744>, <0.412064, -0.412064, -0.185062>, <0.412061, -0.412061, -0.185065>}

triangle{<0.383263, -0.574410, -0.117744>, <0.412061, -0.412061, -0.185065>, <0.068313, -0.482852, -0.259812>}

triangle{<0.383263, -0.574410, -0.117744>, <0.068313, -0.482852, -0.259812>, <0.068126, -0.482978, -0.259812>}

triangle{<0.383263, -0.574410, -0.117744>, <0.068126, -0.482978, -0.259812>, <0.068355, -0.483253, -0.25961>}

triangle{<-0.383470, -0.574325, -0.117719>, <-0.383263, -0.574410, -0.117744>, <-0.068355, -0.483253, -0.25961>}

triangle{<-0.383470, -0.574325, -0.117719>, <-0.068355, -0.483253, -0.25961>, <-0.068126, -0.482978, -0.259812>}

triangle{<-0.383470, -0.574325, -0.117719>, <-0.068126, -0.482978, -0.259812>, <-0.068313, -0.482852, -0.259812>}

triangle{<-0.383470, -0.574325, -0.117719>, <-0.068313, -0.482852, -0.259812>, <-0.412061, -0.412061, -0.185065>}

triangle{<-0.383470, -0.574325, -0.117719>, <-0.412061, -0.412061, -0.185065>, <-0.412064, -0.412064, -0.185062>}

triangle{<-0.574410, -0.383263, -0.117744>, <-0.574325, -0.383470, -0.117719>, <-0.412064, -0.412064, -0.185062>}

triangle{<-0.574410, -0.383263, -0.117744>, <-0.412064, -0.412064, -0.185062>, <-0.412061, -0.412061, -0.185065>}

triangle{<-0.574410, -0.383263, -0.117744>, <-0.412061, -0.412061, -0.185065>, <-0.482852, -0.068313, -0.259812>}

triangle{<-0.574410, -0.383263, -0.117744>, <-0.482852, -0.068313, -0.259812>, <-0.482978, -0.068126, -0.259812>}

triangle{<-0.574410, -0.383263, -0.117744>, <-0.482978, -0.068126, -0.259812>, <-0.483253, -0.068355, -0.25961>}

triangle{<0.412061, -0.412061, -0.185065>, <0.482852, -0.068313, -0.259812>, <0.068313, -0.482852, -0.259812>}

triangle{<-0.412061, -0.412061, -0.185065>, <-0.068313, -0.482852, -0.259812>, <-0.482852, -0.068313, -0.259812>}

triangle{<0.482978, -0.068126, -0.259812>, <0.482978, 0.100616, -0.259812>, <0.482740, 0.101191, -0.259812>}

triangle{<0.482978, -0.068126, -0.259812>, <0.482740, 0.101191, -0.259812>, <0.083544, 0.698629, -0.259812>}

triangle{<0.482978, -0.068126, -0.259812>, <0.083544, 0.698629, -0.259812>, <0.083515, 0.698659, -0.259812>}

triangle{<0.482978, -0.068126, -0.259812>, <0.083515, 0.698659, -0.259812>, <-0.083515, 0.698659, -0.259812>}

triangle{<0.482978, -0.068126, -0.259812>, <-0.083515, 0.698659, -0.259812>, <-0.083544, 0.698629, -0.259812>}

triangle{<0.482978, -0.068126, -0.259812>, <-0.083544, 0.698629, -0.259812>, <-0.482740, 0.101191, -0.259812>}

triangle{<0.482978, -0.068126, -0.259812>, <-0.482740, 0.101191, -0.259812>, <-0.482978, 0.100616, -0.259812>}

triangle{<0.482978, -0.068126, -0.259812>, <-0.482978, 0.100616, -0.259812>, <-0.482978, -0.068126, -0.259812>}

triangle{<0.482978, -0.068126, -0.259812>, <-0.482978, -0.068126, -0.259812>, <-0.482852, -0.068313, -0.259812>}

triangle{<0.482978, -0.068126, -0.259812>, <-0.482852, -0.068313, -0.259812>, <-0.068313, -0.482852, -0.259812>}

triangle{<0.482978, -0.068126, -0.259812>, <-0.068313, -0.482852, -0.259812>, <-0.068126, -0.482978, -0.259812>}

triangle{<0.482978, -0.068126, -0.259812>, <-0.068126, -0.482978, -0.259812>, <0.068126, -0.482978, -0.259812>}

triangle{<0.482978, -0.068126, -0.259812>, <0.068126, -0.482978, -0.259812>, <0.068313, -0.482852, -0.259812>}

triangle{<0.482978, -0.068126, -0.259812>, <0.068313, -0.482852, -0.259812>, <0.482852, -0.068313, -0.259812>}
}
object {
    DxfObject
    pigment {color Yellow}
    rotate x*180
    translate -x*2
}
object {
    DxfObject
    pigment {color Yellow}
    rotate -x*90
    translate -z*1.5
}
object {
    DxfObject
    pigment {color Yellow}
    rotate x*90
    translate z*1.5
}
object {
    DxfObject
    pigment {color Yellow}
    rotate x*150
    translate x*2
}