#include "shapes.inc"
#include "colors.inc"
#include "textures.inc"

// Put camera {} here...
// perspective (default) camera
camera {
  orthographic
  location  <0.0, 10, 0>
  look_at   <0.0, 0.0,  0.0>
  angle 45
}

// Put light_source {} here...
// create a regular point light source
light_source {
  0*x                  // light's position (translated below)
  color rgb <1,1,1> *1.2   // light's color
  translate <10, 20, 30>
}


light_source {
  0*x                  // light's position (translated below)
  color rgb <1,1,1> *1.2    // light's color
  translate <10, 20, -30>
}

#declare DxfObject =

union {
 // degenrate  triangle removed at input line 21

triangle{<-0.128824, -0.074377, 0.603462>, <0.000000, -0.000000, 0.680481>, <0.128824, -0.074377, 0.603462>}

triangle{<-0.128824, -0.074377, 0.603462>, <0.128824, -0.074377, 0.603462>, <0.128836, -0.074417, 0.60342>}

triangle{<-0.128824, -0.074377, 0.603462>, <0.128836, -0.074417, 0.60342>, <0.000041, -0.726083, -0.071399>}

triangle{<-0.128824, -0.074377, 0.603462>, <0.000041, -0.726083, -0.071399>, <0.000000, -0.726088, -0.071405>}

triangle{<-0.128824, -0.074377, 0.603462>, <0.000000, -0.726088, -0.071405>, <-0.000041, -0.726083, -0.071399>}

triangle{<-0.128824, -0.074377, 0.603462>, <-0.000041, -0.726083, -0.071399>, <-0.128836, -0.074417, 0.60342>}

triangle{<0.000000, -0.000000, 0.680481>, <-0.128824, -0.074377, 0.603462>, <-0.128865, -0.074367, 0.60342>}

triangle{<0.000000, -0.000000, 0.680481>, <-0.128865, -0.074367, 0.60342>, <-0.628826, 0.363006, -0.071399>}

triangle{<0.000000, -0.000000, 0.680481>, <-0.628826, 0.363006, -0.071399>, <-0.628811, 0.363044, -0.071405>}

triangle{<0.000000, -0.000000, 0.680481>, <-0.628811, 0.363044, -0.071405>, <-0.628786, 0.363077, -0.071399>}

triangle{<0.000000, -0.000000, 0.680481>, <-0.628786, 0.363077, -0.071399>, <-0.000029, 0.148784, 0.60342>}

triangle{<0.000000, -0.000000, 0.680481>, <-0.000029, 0.148784, 0.60342>, <-0.000000, 0.148753, 0.603462>}

triangle{<0.128824, -0.074377, 0.603462>, <0.000000, -0.000000, 0.680481>, <-0.000000, 0.148753, 0.603462>}

triangle{<0.128824, -0.074377, 0.603462>, <-0.000000, 0.148753, 0.603462>, <0.000029, 0.148784, 0.60342>}

triangle{<0.128824, -0.074377, 0.603462>, <0.000029, 0.148784, 0.60342>, <0.628786, 0.363077, -0.071399>}

triangle{<0.128824, -0.074377, 0.603462>, <0.628786, 0.363077, -0.071399>, <0.628811, 0.363044, -0.071405>}

triangle{<0.128824, -0.074377, 0.603462>, <0.628811, 0.363044, -0.071405>, <0.628826, 0.363006, -0.071399>}

triangle{<0.128824, -0.074377, 0.603462>, <0.628826, 0.363006, -0.071399>, <0.128865, -0.074367, 0.60342>}

triangle{<-0.128836, -0.074417, 0.60342>, <-0.000041, -0.726083, -0.071399>, <-0.467559, -0.664533, -0.071399>}

triangle{<-0.628826, 0.363006, -0.071399>, <-0.128865, -0.074367, 0.60342>, <-0.809282, -0.072652, -0.071399>}

triangle{<-0.000029, 0.148784, 0.60342>, <-0.628786, 0.363077, -0.071399>, <-0.341723, 0.737184, -0.071399>}

triangle{<0.628786, 0.363077, -0.071399>, <0.000029, 0.148784, 0.60342>, <0.341723, 0.737184, -0.071399>}

triangle{<0.128865, -0.074367, 0.60342>, <0.628826, 0.363006, -0.071399>, <0.809282, -0.072652, -0.071399>}

triangle{<0.000041, -0.726083, -0.071399>, <0.128836, -0.074417, 0.60342>, <0.467559, -0.664533, -0.071399>}

triangle{<-0.128824, -0.074377, 0.603462>, <-0.128836, -0.074417, 0.60342>, <-0.467559, -0.664533, -0.071399>}

triangle{<-0.128824, -0.074377, 0.603462>, <-0.467559, -0.664533, -0.071399>, <-0.469390, -0.664292, -0.071877>}

triangle{<-0.128824, -0.074377, 0.603462>, <-0.469390, -0.664292, -0.071877>, <-0.866025, -0.500000, -0.071877>}

triangle{<-0.128865, -0.074367, 0.60342>, <-0.128824, -0.074377, 0.603462>, <-0.866025, -0.500000, -0.071877>}

triangle{<-0.128865, -0.074367, 0.60342>, <-0.866025, -0.500000, -0.071877>, <-0.809989, -0.074358, -0.071877>}

triangle{<-0.128865, -0.074367, 0.60342>, <-0.809989, -0.074358, -0.071877>, <-0.809282, -0.072652, -0.071399>}

triangle{<-0.000000, 0.148753, 0.603462>, <-0.000029, 0.148784, 0.60342>, <-0.341723, 0.737184, -0.071399>}

triangle{<-0.000000, 0.148753, 0.603462>, <-0.341723, 0.737184, -0.071399>, <-0.340599, 0.738650, -0.071877>}

triangle{<-0.000000, 0.148753, 0.603462>, <-0.340599, 0.738650, -0.071877>, <-0.000000, 1.000000, -0.071877>}

triangle{<0.000029, 0.148784, 0.60342>, <-0.000000, 0.148753, 0.603462>, <-0.000000, 1.000000, -0.071877>}

triangle{<0.000029, 0.148784, 0.60342>, <-0.000000, 1.000000, -0.071877>, <0.340599, 0.738650, -0.071877>}

triangle{<0.000029, 0.148784, 0.60342>, <0.340599, 0.738650, -0.071877>, <0.341723, 0.737184, -0.071399>}

triangle{<0.128824, -0.074377, 0.603462>, <0.128865, -0.074367, 0.60342>, <0.809282, -0.072652, -0.071399>}

triangle{<0.128824, -0.074377, 0.603462>, <0.809282, -0.072652, -0.071399>, <0.809989, -0.074358, -0.071877>}

triangle{<0.128824, -0.074377, 0.603462>, <0.809989, -0.074358, -0.071877>, <0.866025, -0.500000, -0.071877>}

triangle{<0.128836, -0.074417, 0.60342>, <0.128824, -0.074377, 0.603462>, <0.866025, -0.500000, -0.071877>}

triangle{<0.128836, -0.074417, 0.60342>, <0.866025, -0.500000, -0.071877>, <0.469390, -0.664292, -0.071877>}

triangle{<0.128836, -0.074417, 0.60342>, <0.469390, -0.664292, -0.071877>, <0.467559, -0.664533, -0.071399>}

triangle{<-0.000041, -0.726083, -0.071399>, <0.000000, -0.726088, -0.071405>, <0.000000, -0.726088, -0.100569>}

triangle{<-0.000041, -0.726083, -0.071399>, <0.000000, -0.726088, -0.100569>, <-0.469390, -0.664292, -0.100569>}

triangle{<-0.000041, -0.726083, -0.071399>, <-0.469390, -0.664292, -0.100569>, <-0.469390, -0.664292, -0.071877>}

triangle{<-0.000041, -0.726083, -0.071399>, <-0.469390, -0.664292, -0.071877>, <-0.467559, -0.664533, -0.071399>}

triangle{<-0.628811, 0.363044, -0.071405>, <-0.628826, 0.363006, -0.071399>, <-0.809282, -0.072652, -0.071399>}

triangle{<-0.628811, 0.363044, -0.071405>, <-0.809282, -0.072652, -0.071399>, <-0.809989, -0.074358, -0.071877>}

triangle{<-0.628811, 0.363044, -0.071405>, <-0.809989, -0.074358, -0.071877>, <-0.809989, -0.074358, -0.100569>}

triangle{<-0.628811, 0.363044, -0.071405>, <-0.809989, -0.074358, -0.100569>, <-0.628811, 0.363044, -0.100569>}

triangle{<-0.628786, 0.363077, -0.071399>, <-0.628811, 0.363044, -0.071405>, <-0.628811, 0.363044, -0.100569>}

triangle{<-0.628786, 0.363077, -0.071399>, <-0.628811, 0.363044, -0.100569>, <-0.340599, 0.738650, -0.100569>}

triangle{<-0.628786, 0.363077, -0.071399>, <-0.340599, 0.738650, -0.100569>, <-0.340599, 0.738650, -0.071877>}

triangle{<-0.628786, 0.363077, -0.071399>, <-0.340599, 0.738650, -0.071877>, <-0.341723, 0.737184, -0.071399>}

triangle{<0.628811, 0.363044, -0.071405>, <0.628786, 0.363077, -0.071399>, <0.341723, 0.737184, -0.071399>}

triangle{<0.628811, 0.363044, -0.071405>, <0.341723, 0.737184, -0.071399>, <0.340599, 0.738650, -0.071877>}

triangle{<0.628811, 0.363044, -0.071405>, <0.340599, 0.738650, -0.071877>, <0.340599, 0.738650, -0.100569>}

triangle{<0.628811, 0.363044, -0.071405>, <0.340599, 0.738650, -0.100569>, <0.628811, 0.363044, -0.100569>}

triangle{<0.628826, 0.363006, -0.071399>, <0.628811, 0.363044, -0.071405>, <0.628811, 0.363044, -0.100569>}

triangle{<0.628826, 0.363006, -0.071399>, <0.628811, 0.363044, -0.100569>, <0.809989, -0.074358, -0.100569>}

triangle{<0.628826, 0.363006, -0.071399>, <0.809989, -0.074358, -0.100569>, <0.809989, -0.074358, -0.071877>}

triangle{<0.628826, 0.363006, -0.071399>, <0.809989, -0.074358, -0.071877>, <0.809282, -0.072652, -0.071399>}

triangle{<0.000000, -0.726088, -0.071405>, <0.000041, -0.726083, -0.071399>, <0.467559, -0.664533, -0.071399>}

triangle{<0.000000, -0.726088, -0.071405>, <0.467559, -0.664533, -0.071399>, <0.469390, -0.664292, -0.071877>}

triangle{<0.000000, -0.726088, -0.071405>, <0.469390, -0.664292, -0.071877>, <0.469390, -0.664292, -0.100569>}

triangle{<0.000000, -0.726088, -0.071405>, <0.469390, -0.664292, -0.100569>, <0.000000, -0.726088, -0.100569>}

triangle{<-0.866025, -0.500000, -0.071877>, <-0.469390, -0.664292, -0.071877>, <-0.469390, -0.664292, -0.100569>}

triangle{<-0.866025, -0.500000, -0.071877>, <-0.469390, -0.664292, -0.100569>, <-0.469429, -0.664276, -0.100578>}

triangle{<-0.866025, -0.500000, -0.071877>, <-0.469429, -0.664276, -0.100578>, <-0.866025, -0.500000, -0.100578>}

triangle{<-0.809989, -0.074358, -0.071877>, <-0.866025, -0.500000, -0.071877>, <-0.866025, -0.500000, -0.100578>}

triangle{<-0.809989, -0.074358, -0.071877>, <-0.866025, -0.500000, -0.100578>, <-0.809994, -0.074399, -0.100578>}

triangle{<-0.809989, -0.074358, -0.071877>, <-0.809994, -0.074399, -0.100578>, <-0.809989, -0.074358, -0.100569>}

triangle{<-0.000000, 1.000000, -0.071877>, <-0.340599, 0.738650, -0.071877>, <-0.340599, 0.738650, -0.100569>}

triangle{<-0.000000, 1.000000, -0.071877>, <-0.340599, 0.738650, -0.100569>, <-0.340565, 0.738675, -0.100578>}

triangle{<-0.000000, 1.000000, -0.071877>, <-0.340565, 0.738675, -0.100578>, <-0.000000, 1.000000, -0.100578>}

triangle{<0.340599, 0.738650, -0.071877>, <-0.000000, 1.000000, -0.071877>, <-0.000000, 1.000000, -0.100578>}

triangle{<0.340599, 0.738650, -0.071877>, <-0.000000, 1.000000, -0.100578>, <0.340565, 0.738675, -0.100578>}

triangle{<0.340599, 0.738650, -0.071877>, <0.340565, 0.738675, -0.100578>, <0.340599, 0.738650, -0.100569>}

triangle{<0.866025, -0.500000, -0.071877>, <0.809989, -0.074358, -0.071877>, <0.809989, -0.074358, -0.100569>}

triangle{<0.866025, -0.500000, -0.071877>, <0.809989, -0.074358, -0.100569>, <0.809994, -0.074399, -0.100578>}

triangle{<0.866025, -0.500000, -0.071877>, <0.809994, -0.074399, -0.100578>, <0.866025, -0.500000, -0.100578>}

triangle{<0.469390, -0.664292, -0.071877>, <0.866025, -0.500000, -0.071877>, <0.866025, -0.500000, -0.100578>}

triangle{<0.469390, -0.664292, -0.071877>, <0.866025, -0.500000, -0.100578>, <0.469429, -0.664276, -0.100578>}

triangle{<0.469390, -0.664292, -0.071877>, <0.469429, -0.664276, -0.100578>, <0.469390, -0.664292, -0.100569>}

triangle{<0.000000, -0.726088, -0.100569>, <0.469390, -0.664292, -0.100569>, <0.469429, -0.664276, -0.100578>}

triangle{<0.000000, -0.726088, -0.100569>, <0.469429, -0.664276, -0.100578>, <0.288151, -0.559624, -0.212755>}

triangle{<0.000000, -0.726088, -0.100569>, <0.288151, -0.559624, -0.212755>, <0.000000, -0.725933, -0.100704>}

triangle{<0.809989, -0.074358, -0.100569>, <0.628811, 0.363044, -0.100569>, <0.628676, 0.362966, -0.100704>}

triangle{<0.809989, -0.074358, -0.100569>, <0.628676, 0.362966, -0.100704>, <0.628724, 0.030266, -0.212755>}

triangle{<0.809989, -0.074358, -0.100569>, <0.628724, 0.030266, -0.212755>, <0.809994, -0.074399, -0.100578>}

triangle{<0.628811, 0.363044, -0.100569>, <0.340599, 0.738650, -0.100569>, <0.340565, 0.738675, -0.100578>}

triangle{<0.628811, 0.363044, -0.100569>, <0.340565, 0.738675, -0.100578>, <0.340573, 0.529357, -0.212755>}

triangle{<0.628811, 0.363044, -0.100569>, <0.340573, 0.529357, -0.212755>, <0.628676, 0.362966, -0.100704>}

triangle{<-0.340599, 0.738650, -0.100569>, <-0.628811, 0.363044, -0.100569>, <-0.628676, 0.362966, -0.100704>}

triangle{<-0.340599, 0.738650, -0.100569>, <-0.628676, 0.362966, -0.100704>, <-0.340573, 0.529357, -0.212755>}

triangle{<-0.340599, 0.738650, -0.100569>, <-0.340573, 0.529357, -0.212755>, <-0.340565, 0.738675, -0.100578>}

triangle{<-0.628811, 0.363044, -0.100569>, <-0.809989, -0.074358, -0.100569>, <-0.809994, -0.074399, -0.100578>}

triangle{<-0.628811, 0.363044, -0.100569>, <-0.809994, -0.074399, -0.100578>, <-0.628724, 0.030266, -0.212755>}

triangle{<-0.628811, 0.363044, -0.100569>, <-0.628724, 0.030266, -0.212755>, <-0.628676, 0.362966, -0.100704>}

triangle{<-0.469390, -0.664292, -0.100569>, <0.000000, -0.726088, -0.100569>, <0.000000, -0.725933, -0.100704>}

triangle{<-0.469390, -0.664292, -0.100569>, <0.000000, -0.725933, -0.100704>, <-0.288151, -0.559624, -0.212755>}

triangle{<-0.469390, -0.664292, -0.100569>, <-0.288151, -0.559624, -0.212755>, <-0.469429, -0.664276, -0.100578>}

triangle{<0.469429, -0.664276, -0.100578>, <0.866025, -0.500000, -0.100578>, <0.629730, -0.363575, -0.246807>}

triangle{<0.469429, -0.664276, -0.100578>, <0.629730, -0.363575, -0.246807>, <0.288126, -0.559493, -0.212842>}

triangle{<0.469429, -0.664276, -0.100578>, <0.288126, -0.559493, -0.212842>, <0.288151, -0.559624, -0.212755>}

triangle{<0.866025, -0.500000, -0.100578>, <0.809994, -0.074399, -0.100578>, <0.628724, 0.030266, -0.212755>}

triangle{<0.866025, -0.500000, -0.100578>, <0.628724, 0.030266, -0.212755>, <0.628598, 0.030223, -0.212842>}

triangle{<0.866025, -0.500000, -0.100578>, <0.628598, 0.030223, -0.212842>, <0.629730, -0.363575, -0.246807>}

triangle{<0.340565, 0.738675, -0.100578>, <-0.000000, 1.000000, -0.100578>, <-0.000000, 0.727149, -0.246807>}

triangle{<0.340565, 0.738675, -0.100578>, <-0.000000, 0.727149, -0.246807>, <0.340473, 0.529271, -0.212842>}

triangle{<0.340565, 0.738675, -0.100578>, <0.340473, 0.529271, -0.212842>, <0.340573, 0.529357, -0.212755>}

triangle{<-0.000000, 1.000000, -0.100578>, <-0.340565, 0.738675, -0.100578>, <-0.340573, 0.529357, -0.212755>}

triangle{<-0.000000, 1.000000, -0.100578>, <-0.340573, 0.529357, -0.212755>, <-0.340473, 0.529271, -0.212842>}

triangle{<-0.000000, 1.000000, -0.100578>, <-0.340473, 0.529271, -0.212842>, <-0.000000, 0.727149, -0.246807>}

triangle{<-0.809994, -0.074399, -0.100578>, <-0.866025, -0.500000, -0.100578>, <-0.629730, -0.363575, -0.246807>}

triangle{<-0.809994, -0.074399, -0.100578>, <-0.629730, -0.363575, -0.246807>, <-0.628598, 0.030223, -0.212842>}

triangle{<-0.809994, -0.074399, -0.100578>, <-0.628598, 0.030223, -0.212842>, <-0.628724, 0.030266, -0.212755>}

triangle{<-0.866025, -0.500000, -0.100578>, <-0.469429, -0.664276, -0.100578>, <-0.288151, -0.559624, -0.212755>}

triangle{<-0.866025, -0.500000, -0.100578>, <-0.288151, -0.559624, -0.212755>, <-0.288126, -0.559493, -0.212842>}

triangle{<-0.866025, -0.500000, -0.100578>, <-0.288126, -0.559493, -0.212842>, <-0.629730, -0.363575, -0.246807>}

triangle{<0.000000, -0.725933, -0.100704>, <0.288151, -0.559624, -0.212755>, <0.288126, -0.559493, -0.212842>}

triangle{<0.000000, -0.725933, -0.100704>, <0.288126, -0.559493, -0.212842>, <0.000114, -0.392694, -0.325223>}

triangle{<0.000000, -0.725933, -0.100704>, <0.000114, -0.392694, -0.325223>, <-0.000114, -0.392694, -0.325223>}

triangle{<0.000000, -0.725933, -0.100704>, <-0.000114, -0.392694, -0.325223>, <-0.288126, -0.559493, -0.212842>}

triangle{<0.000000, -0.725933, -0.100704>, <-0.288126, -0.559493, -0.212842>, <-0.288151, -0.559624, -0.212755>}

triangle{<0.628724, 0.030266, -0.212755>, <0.628676, 0.362966, -0.100704>, <0.340573, 0.529357, -0.212755>}

triangle{<0.628724, 0.030266, -0.212755>, <0.340573, 0.529357, -0.212755>, <0.340473, 0.529271, -0.212842>}

triangle{<0.628724, 0.030266, -0.212755>, <0.340473, 0.529271, -0.212842>, <0.340026, 0.196446, -0.325223>}

triangle{<0.628724, 0.030266, -0.212755>, <0.340026, 0.196446, -0.325223>, <0.340140, 0.196248, -0.325223>}

triangle{<0.628724, 0.030266, -0.212755>, <0.340140, 0.196248, -0.325223>, <0.628598, 0.030223, -0.212842>}

triangle{<-0.340573, 0.529357, -0.212755>, <-0.628676, 0.362966, -0.100704>, <-0.628724, 0.030266, -0.212755>}

triangle{<-0.340573, 0.529357, -0.212755>, <-0.628724, 0.030266, -0.212755>, <-0.628598, 0.030223, -0.212842>}

triangle{<-0.340573, 0.529357, -0.212755>, <-0.628598, 0.030223, -0.212842>, <-0.340140, 0.196248, -0.325223>}

triangle{<-0.340573, 0.529357, -0.212755>, <-0.340140, 0.196248, -0.325223>, <-0.340026, 0.196446, -0.325223>}

triangle{<-0.340573, 0.529357, -0.212755>, <-0.340026, 0.196446, -0.325223>, <-0.340473, 0.529271, -0.212842>}

triangle{<0.288126, -0.559493, -0.212842>, <0.629730, -0.363575, -0.246807>, <0.339253, -0.195868, -0.359929>}

triangle{<0.288126, -0.559493, -0.212842>, <0.339253, -0.195868, -0.359929>, <0.000114, -0.392694, -0.325223>}

triangle{<0.629730, -0.363575, -0.246807>, <0.628598, 0.030223, -0.212842>, <0.340140, 0.196248, -0.325223>}

triangle{<0.629730, -0.363575, -0.246807>, <0.340140, 0.196248, -0.325223>, <0.339253, -0.195868, -0.359929>}

triangle{<0.340473, 0.529271, -0.212842>, <-0.000000, 0.727149, -0.246807>, <-0.000000, 0.391735, -0.359929>}

triangle{<0.340473, 0.529271, -0.212842>, <-0.000000, 0.391735, -0.359929>, <0.340026, 0.196446, -0.325223>}

triangle{<-0.000000, 0.727149, -0.246807>, <-0.340473, 0.529271, -0.212842>, <-0.340026, 0.196446, -0.325223>}

triangle{<-0.000000, 0.727149, -0.246807>, <-0.340026, 0.196446, -0.325223>, <-0.000000, 0.391735, -0.359929>}

triangle{<-0.628598, 0.030223, -0.212842>, <-0.629730, -0.363575, -0.246807>, <-0.339253, -0.195868, -0.359929>}

triangle{<-0.628598, 0.030223, -0.212842>, <-0.339253, -0.195868, -0.359929>, <-0.340140, 0.196248, -0.325223>}

triangle{<-0.629730, -0.363575, -0.246807>, <-0.288126, -0.559493, -0.212842>, <-0.000114, -0.392694, -0.325223>}

triangle{<-0.629730, -0.363575, -0.246807>, <-0.000114, -0.392694, -0.325223>, <-0.339253, -0.195868, -0.359929>}

triangle{<-0.000114, -0.392694, -0.325223>, <0.000114, -0.392694, -0.325223>, <0.339253, -0.195868, -0.359929>}

triangle{<-0.000114, -0.392694, -0.325223>, <0.339253, -0.195868, -0.359929>, <-0.000000, -0.000000, -0.394465>}

triangle{<-0.000114, -0.392694, -0.325223>, <-0.000000, -0.000000, -0.394465>, <-0.339253, -0.195868, -0.359929>}

triangle{<0.340140, 0.196248, -0.325223>, <0.340026, 0.196446, -0.325223>, <-0.000000, 0.391735, -0.359929>}

triangle{<0.340140, 0.196248, -0.325223>, <-0.000000, 0.391735, -0.359929>, <-0.000000, -0.000000, -0.394465>}

triangle{<0.340140, 0.196248, -0.325223>, <-0.000000, -0.000000, -0.394465>, <0.339253, -0.195868, -0.359929>}

triangle{<-0.340026, 0.196446, -0.325223>, <-0.340140, 0.196248, -0.325223>, <-0.339253, -0.195868, -0.359929>}

triangle{<-0.340026, 0.196446, -0.325223>, <-0.339253, -0.195868, -0.359929>, <-0.000000, -0.000000, -0.394465>}

triangle{<-0.340026, 0.196446, -0.325223>, <-0.000000, -0.000000, -0.394465>, <-0.000000, 0.391735, -0.359929>}
}

object {
    DxfObject
    pigment {color Yellow}
    rotate x*180
    translate -x*2
}
object {
    DxfObject
    pigment {color Yellow}
    rotate -x*90
    translate -z*1.5
}
object {
    DxfObject
    pigment {color Yellow}
    rotate x*90
    translate z*1.5
}
object {
    DxfObject
    pigment {color Yellow}
    rotate x*150
    translate x*2
}